/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.embedded;

import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.internal.server.embedded.EmbeddedClientSession;
import org.eclipse.emf.cdo.internal.server.embedded.EmbeddedClientSessionProtocol;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.emf.cdo.spi.common.CDOAuthenticationResult;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.server.ISessionProtocol;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

public class EmbeddedServerSessionProtocol
extends Lifecycle
implements ISessionProtocol {
    private EmbeddedClientSessionProtocol clientSessionProtocol;
    private InternalSession session;

    public EmbeddedServerSessionProtocol(EmbeddedClientSessionProtocol clientSessionProtocol) {
        this.clientSessionProtocol = clientSessionProtocol;
    }

    public EmbeddedClientSessionProtocol getClientSessionProtocol() {
        return this.clientSessionProtocol;
    }

    public InternalSession openSession(InternalRepository repository, boolean passiveUpdateEnabled) {
        this.session = repository.getSessionManager().openSession(this);
        this.session.setPassiveUpdateEnabled(passiveUpdateEnabled);
        return this.session;
    }

    public InternalSession getSession() {
        return this.session;
    }

    public CDOAuthenticationResult sendAuthenticationChallenge(byte[] randomToken) throws Exception {
        return this.clientSessionProtocol.handleAuthenticationChallenge(randomToken);
    }

    public void sendRepositoryTypeNotification(CDOCommonRepository.Type oldType, CDOCommonRepository.Type newType) {
        EmbeddedClientSession clientSession = this.clientSessionProtocol.getSession();
        clientSession.handleRepositoryTypeChanged(oldType, newType);
    }

    public void sendRepositoryStateNotification(CDOCommonRepository.State oldState, CDOCommonRepository.State newState) {
        EmbeddedClientSession clientSession = this.clientSessionProtocol.getSession();
        clientSession.handleRepositoryStateChanged(oldState, newState);
    }

    public void sendBranchNotification(InternalCDOBranch branch) {
        EmbeddedClientSession clientSession = this.clientSessionProtocol.getSession();
        clientSession.handleBranchNotification(branch);
    }

    public void sendCommitNotification(CDOCommitInfo commitInfo) {
        EmbeddedClientSession clientSession = this.clientSessionProtocol.getSession();
        clientSession.handleCommitNotification(commitInfo);
    }

    public void sendRemoteSessionNotification(InternalSession sender, byte opcode) {
        throw new UnsupportedOperationException();
    }

    public void sendRemoteMessageNotification(InternalSession sender, CDORemoteSessionMessage message) {
        throw new UnsupportedOperationException();
    }
}

