/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class View
extends Lifecycle
implements InternalView {
    private InternalSession session;
    private int viewID;
    private CDOBranchPoint branchPoint;
    private String durableLockingID;
    private InternalRepository repository;
    private Set<CDOID> changeSubscriptionIDs = new HashSet<CDOID>();

    public View(InternalSession session, int viewID, CDOBranchPoint branchPoint) {
        this.session = session;
        this.viewID = viewID;
        this.repository = session.getManager().getRepository();
        this.setBranchPoint(branchPoint);
    }

    @Override
    public InternalSession getSession() {
        return this.session;
    }

    public int getViewID() {
        return this.viewID;
    }

    public CDOBranch getBranch() {
        return this.branchPoint.getBranch();
    }

    public long getTimeStamp() {
        return this.branchPoint.getTimeStamp();
    }

    public boolean isReadOnly() {
        return true;
    }

    public String getDurableLockingID() {
        return this.durableLockingID;
    }

    @Override
    public InternalRepository getRepository() {
        this.checkOpen();
        return this.repository;
    }

    public InternalCDORevision getRevision(CDOID id) {
        InternalCDORevisionManager revisionManager = this.repository.getRevisionManager();
        return (InternalCDORevision)revisionManager.getRevision(id, (CDOBranchPoint)this, -1, 0, true);
    }

    @Override
    public void changeTarget(CDOBranchPoint branchPoint, List<CDOID> invalidObjects, List<CDORevisionDelta> allChangedObjects, List<CDOID> allDetachedObjects) {
        List<CDORevision> oldRevisions = this.getRevisions(invalidObjects);
        this.setBranchPoint(branchPoint);
        List<CDORevision> newRevisions = this.getRevisions(invalidObjects);
        Iterator<CDORevision> it = newRevisions.iterator();
        for (CDORevision oldRevision : oldRevisions) {
            CDORevision newRevision = it.next();
            if (newRevision == null) {
                allDetachedObjects.add(oldRevision.getID());
                continue;
            }
            if (newRevision == oldRevision) continue;
            CDORevisionDelta delta = newRevision.compare(oldRevision);
            allChangedObjects.add(delta);
        }
    }

    private List<CDORevision> getRevisions(List<CDOID> ids) {
        return this.repository.getRevisionManager().getRevisions(ids, this.branchPoint, -1, 0, true);
    }

    @Override
    public void setBranchPoint(CDOBranchPoint branchPoint) {
        this.checkOpen();
        long timeStamp = branchPoint.getTimeStamp();
        branchPoint = branchPoint.getBranch().getPoint(timeStamp);
        this.validateTimeStamp(timeStamp);
        this.branchPoint = branchPoint;
    }

    protected void validateTimeStamp(long timeStamp) throws IllegalArgumentException {
        if (timeStamp != 0L) {
            this.repository.validateTimeStamp(timeStamp);
        }
    }

    @Override
    public void setDurableLockingID(String durableLockingID) {
        this.durableLockingID = durableLockingID;
    }

    @Override
    public synchronized void subscribe(CDOID id) {
        this.checkOpen();
        this.changeSubscriptionIDs.add(id);
    }

    @Override
    public synchronized void unsubscribe(CDOID id) {
        this.checkOpen();
        this.changeSubscriptionIDs.remove(id);
    }

    @Override
    public synchronized boolean hasSubscription(CDOID id) {
        this.checkOpen();
        return this.changeSubscriptionIDs.contains(id);
    }

    @Override
    public synchronized void clearChangeSubscription() {
        this.checkOpen();
        this.changeSubscriptionIDs.clear();
    }

    public String toString() {
        int sessionID = this.session == null ? 0 : this.session.getSessionID();
        return MessageFormat.format("{0}[{1}:{2}]", this.getClassName(), sessionID, this.viewID);
    }

    protected String getClassName() {
        return "View";
    }

    public void close() {
        this.deactivate();
    }

    protected void doDeactivate() throws Exception {
        if (!this.isClosed()) {
            this.session.viewClosed(this);
        }
        super.doDeactivate();
    }

    @Override
    public void doClose() {
        this.clearChangeSubscription();
        this.changeSubscriptionIDs = null;
        this.session = null;
        this.repository = null;
    }

    public boolean isClosed() {
        return this.repository == null;
    }

    private void checkOpen() {
        if (this.isClosed()) {
            throw new IllegalStateException("View closed");
        }
    }
}

