/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

class TimeStampAuthority {
    private InternalRepository repository;
    @ReflectUtil.ExcludeFromDump
    private transient long lastIssuedTimeStamp = 0L;
    private long lastFinishedTimeStamp;
    private LastCommitTimeStampLock lastCommitTimeStampLock = new LastCommitTimeStampLock();
    private boolean strictOrdering;
    private StrictOrderingLock strictOrderingLock = new StrictOrderingLock();
    private List<Long> runningTransactions = new LinkedList<Long>();
    private SortedSet<Long> finishedTransactions = new TreeSet<Long>();

    TimeStampAuthority(InternalRepository repository) {
        this.repository = repository;
    }

    synchronized long[] startCommit(OMMonitor monitor) {
        return this.startCommit(0L, monitor);
    }

    synchronized long[] startCommit(long timeStampOverride, OMMonitor monitor) {
        monitor.begin();
        if (this.strictOrdering) {
            this.strictOrderingLock.lock();
        }
        try {
            long now = this.repository.getTimeStamp();
            if (this.lastIssuedTimeStamp != 0L) {
                while (this.lastIssuedTimeStamp == now) {
                    ConcurrencyUtil.sleep((long)1L);
                    now = this.repository.getTimeStamp();
                    monitor.checkCanceled();
                }
            }
            if (timeStampOverride != 0L) {
                now = timeStampOverride;
            }
            long previousIssuedTimeStamp = this.lastIssuedTimeStamp;
            this.lastIssuedTimeStamp = now;
            this.runningTransactions.add(this.lastIssuedTimeStamp);
            long[] lArray = new long[]{this.lastIssuedTimeStamp, previousIssuedTimeStamp};
            return lArray;
        }
        finally {
            monitor.done();
        }
    }

    synchronized void endCommit(long timeStamp) {
        long oldestFinished;
        if (!this.runningTransactions.remove(timeStamp)) {
            throw new IllegalArgumentException("Cannot end transaction with unknown timestamp " + timeStamp);
        }
        this.finishedTransactions.add(timeStamp);
        long oldestRunning = this.runningTransactions.isEmpty() ? Long.MAX_VALUE : this.runningTransactions.get(0);
        while (!this.finishedTransactions.isEmpty() && (oldestFinished = this.finishedTransactions.first().longValue()) < oldestRunning) {
            this.finishedTransactions.remove(oldestFinished);
            this.lastFinishedTimeStamp = oldestFinished;
        }
        if (this.strictOrdering) {
            this.strictOrderingLock.unlock();
        }
    }

    synchronized void failCommit(long timeStamp) {
        if (timeStamp != 0L && !this.runningTransactions.remove(timeStamp)) {
            throw new IllegalArgumentException("Cannot fail transaction with unknown timestamp " + timeStamp);
        }
        if (this.strictOrdering) {
            this.strictOrderingLock.unlock();
        }
    }

    synchronized long getLastFinishedTimeStamp() {
        if (this.lastFinishedTimeStamp != 0L) {
            return this.lastFinishedTimeStamp;
        }
        if (this.lastIssuedTimeStamp == 0L) {
            return this.repository.getTimeStamp() - 1L;
        }
        return this.runningTransactions.get(0) - 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long waitForCommit(long timeout) {
        LastCommitTimeStampLock lastCommitTimeStampLock = this.lastCommitTimeStampLock;
        synchronized (lastCommitTimeStampLock) {
            try {
                this.lastCommitTimeStampLock.wait(timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.lastFinishedTimeStamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLastFinishedTimeStamp(long lastCommitTimeStamp) {
        LastCommitTimeStampLock lastCommitTimeStampLock = this.lastCommitTimeStampLock;
        synchronized (lastCommitTimeStampLock) {
            if (this.lastFinishedTimeStamp < lastCommitTimeStamp) {
                this.lastFinishedTimeStamp = lastCommitTimeStamp;
                this.lastCommitTimeStampLock.notifyAll();
            }
        }
    }

    private static final class LastCommitTimeStampLock {
        private LastCommitTimeStampLock() {
        }
    }

    private static final class StrictOrderingLock
    extends ReentrantLock {
        private static final long serialVersionUID = 1L;

        private StrictOrderingLock() {
        }
    }
}

