/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchHandler;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchVersion;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lob.CDOLobHandler;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCacheAdder;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.common.util.CDOTimeProvider;
import org.eclipse.emf.cdo.common.util.RepositoryStateChangedEvent;
import org.eclipse.emf.cdo.common.util.RepositoryTypeChangedEvent;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.etypes.EtypesPackage;
import org.eclipse.emf.cdo.internal.common.model.CDOPackageRegistryImpl;
import org.eclipse.emf.cdo.internal.server.CommitManager;
import org.eclipse.emf.cdo.internal.server.LockManager;
import org.eclipse.emf.cdo.internal.server.QueryManager;
import org.eclipse.emf.cdo.internal.server.ResourcesQueryHandler;
import org.eclipse.emf.cdo.internal.server.SessionManager;
import org.eclipse.emf.cdo.internal.server.TimeStampAuthority;
import org.eclipse.emf.cdo.internal.server.TransactionCommitContext;
import org.eclipse.emf.cdo.internal.server.XRefsQueryHandler;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.IQueryHandlerProvider;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.IStoreChunkReader;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.CDOReplicationContext;
import org.eclipse.emf.cdo.spi.common.CDOReplicationInfo;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOChangeSetSegment;
import org.eclipse.emf.cdo.spi.common.commit.CDOCommitInfoUtil;
import org.eclipse.emf.cdo.spi.common.commit.CDORevisionAvailabilityInfo;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.DetachedCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDOList;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.spi.common.revision.PointerCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.RevisionInfo;
import org.eclipse.emf.cdo.spi.common.revision.SyntheticCDORevision;
import org.eclipse.emf.cdo.spi.server.ContainerQueryHandlerProvider;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalCommitManager;
import org.eclipse.emf.cdo.spi.server.InternalLockManager;
import org.eclipse.emf.cdo.spi.server.InternalQueryManager;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalSession;
import org.eclipse.emf.cdo.spi.server.InternalSessionManager;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.internal.cdo.object.CDOFactoryImpl;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.collection.MoveableList;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.transaction.TransactionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repository
extends Container<Object>
implements InternalRepository {
    private String name;
    private String uuid;
    private InternalStore store;
    private CDOCommonRepository.Type type = CDOCommonRepository.Type.MASTER;
    private CDOCommonRepository.State state = CDOCommonRepository.State.ONLINE;
    private Map<String, String> properties;
    private boolean supportingAudits;
    private boolean supportingBranches;
    private boolean supportingEcore;
    private boolean ensuringReferentialIntegrity;
    private InternalCDOPackageRegistry packageRegistry;
    private InternalCDOBranchManager branchManager;
    private InternalCDORevisionManager revisionManager;
    private InternalCDOCommitInfoManager commitInfoManager;
    private InternalSessionManager sessionManager;
    private InternalQueryManager queryManager;
    private InternalCommitManager commitManager;
    private InternalLockManager lockManager;
    private IQueryHandlerProvider queryHandlerProvider;
    private List<IRepository.ReadAccessHandler> readAccessHandlers = new ArrayList<IRepository.ReadAccessHandler>();
    private List<IRepository.WriteAccessHandler> writeAccessHandlers = new ArrayList<IRepository.WriteAccessHandler>();
    private List<CDOCommitInfoHandler> commitInfoHandlers = new ArrayList<CDOCommitInfoHandler>();
    private EPackage[] initialPackages;
    private TimeStampAuthority timeStampAuthority = new TimeStampAuthority(this);
    @ReflectUtil.ExcludeFromDump
    private transient Object createBranchLock = new Object();
    private boolean skipInitialization;
    private CDOID rootResourceID;

    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getUUID() {
        if (this.uuid == null) {
            this.uuid = this.getProperties().get("overrideUUID");
            if (this.uuid == null) {
                this.uuid = UUID.randomUUID().toString();
            } else if (this.uuid.length() == 0) {
                this.uuid = this.getName();
            }
        }
        return this.uuid;
    }

    @Override
    public InternalStore getStore() {
        return this.store;
    }

    @Override
    public void setStore(InternalStore store) {
        this.store = store;
    }

    public CDOCommonRepository.Type getType() {
        return this.type;
    }

    @Override
    public void setType(CDOCommonRepository.Type type) {
        this.checkArg(type, "type");
        if (this.type != type) {
            this.changingType(this.type, type);
        }
    }

    protected void changingType(CDOCommonRepository.Type oldType, CDOCommonRepository.Type newType) {
        this.type = newType;
        this.fireEvent((IEvent)new RepositoryTypeChangedEvent((INotifier)this, oldType, newType));
        if (this.sessionManager != null) {
            this.sessionManager.sendRepositoryTypeNotification(oldType, newType);
        }
    }

    public CDOCommonRepository.State getState() {
        return this.state;
    }

    @Override
    public void setState(CDOCommonRepository.State state) {
        this.checkArg(state, "state");
        if (this.state != state) {
            this.changingState(this.state, state);
        }
    }

    protected void changingState(CDOCommonRepository.State oldState, CDOCommonRepository.State newState) {
        this.state = newState;
        this.fireEvent((IEvent)new RepositoryStateChangedEvent((INotifier)this, oldState, newState));
        if (this.sessionManager != null) {
            this.sessionManager.sendRepositoryStateNotification(oldState, newState);
        }
    }

    @Override
    public synchronized Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    @Override
    public synchronized void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public boolean isSupportingAudits() {
        return this.supportingAudits;
    }

    public boolean isSupportingBranches() {
        return this.supportingBranches;
    }

    public boolean isSupportingEcore() {
        return this.supportingEcore;
    }

    public boolean isEnsuringReferentialIntegrity() {
        return this.ensuringReferentialIntegrity;
    }

    public String getStoreType() {
        return this.store.getType();
    }

    public Set<CDOID.ObjectType> getObjectIDTypes() {
        return this.store.getObjectIDTypes();
    }

    public CDOID getRootResourceID() {
        return this.rootResourceID;
    }

    @Override
    public void setRootResourceID(CDOID rootResourceID) {
        this.rootResourceID = rootResourceID;
    }

    public Object processPackage(Object value) {
        CDOFactoryImpl.prepareDynamicEPackage((Object)value);
        return value;
    }

    public EPackage[] loadPackages(CDOPackageUnit packageUnit) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.loadPackageUnit((InternalCDOPackageUnit)packageUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<Integer, Long> createBranch(int branchID, InternalCDOBranchManager.BranchLoader.BranchInfo branchInfo) {
        if (!this.isSupportingBranches()) {
            throw new IllegalStateException("Branching is not supported by " + this);
        }
        long baseTimeStamp = branchInfo.getBaseTimeStamp();
        if (baseTimeStamp == 0L) {
            baseTimeStamp = this.getTimeStamp();
            branchInfo = new InternalCDOBranchManager.BranchLoader.BranchInfo(branchInfo.getName(), branchInfo.getBaseBranchID(), baseTimeStamp);
        }
        Object object = this.createBranchLock;
        synchronized (object) {
            IStoreAccessor accessor = StoreThreadLocal.getAccessor();
            return accessor.createBranch(branchID, branchInfo);
        }
    }

    public InternalCDOBranchManager.BranchLoader.BranchInfo loadBranch(int branchID) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.loadBranch(branchID);
    }

    public InternalCDOBranchManager.BranchLoader.SubBranchInfo[] loadSubBranches(int branchID) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.loadSubBranches(branchID);
    }

    public int loadBranches(int startID, int endID, CDOBranchHandler branchHandler) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.loadBranches(startID, endID, branchHandler);
    }

    public void loadCommitInfos(CDOBranch branch, long startTime, long endTime, CDOCommitInfoHandler handler) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        accessor.loadCommitInfos(branch, startTime, endTime, handler);
    }

    public CDOCommitData loadCommitData(long timeStamp) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.loadCommitData(timeStamp);
    }

    public List<InternalCDORevision> loadRevisions(List<RevisionInfo> infos, CDOBranchPoint branchPoint, int referenceChunk, int prefetchDepth) {
        block6: for (RevisionInfo info : infos) {
            CDOID id = info.getID();
            RevisionInfo.Type type = info.getType();
            switch (type) {
                case AVAILABLE_NORMAL: {
                    RevisionInfo.Available.Normal availableInfo = (RevisionInfo.Available.Normal)info;
                    this.checkArg(!availableInfo.isDirect(), "Load is not needed");
                    break;
                }
                case AVAILABLE_POINTER: {
                    RevisionInfo.Available.Pointer pointerInfo = (RevisionInfo.Available.Pointer)info;
                    boolean needsTarget = !pointerInfo.hasTarget();
                    this.checkArg(!pointerInfo.isDirect() || needsTarget, "Load is not needed");
                    if (!needsTarget) break;
                    CDOBranchVersion targetBranchVersion = pointerInfo.getTargetBranchVersion();
                    InternalCDORevision target = this.loadRevisionByVersion(id, targetBranchVersion, referenceChunk);
                    PointerCDORevision pointer = new PointerCDORevision(target.getEClass(), id, pointerInfo.getAvailableBranchVersion().getBranch(), 0L, (CDOBranchVersion)target);
                    info.setResult(target);
                    info.setSynthetic((SyntheticCDORevision)pointer);
                    continue block6;
                }
                case AVAILABLE_DETACHED: {
                    RevisionInfo.Available.Detached detachedInfo = (RevisionInfo.Available.Detached)info;
                    this.checkArg(!detachedInfo.isDirect(), "Load is not needed");
                    break;
                }
                case MISSING: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid revision info type: " + type);
                }
            }
            IStoreAccessor accessor = StoreThreadLocal.getAccessor();
            InternalCDORevision revision = accessor.readRevision(id, branchPoint, referenceChunk, (CDORevisionCacheAdder)this.revisionManager);
            if (revision == null) {
                if (this.isSupportingAudits()) {
                    InternalCDORevision target = this.loadRevisionTarget(id, branchPoint, referenceChunk, accessor);
                    if (target != null) {
                        CDOBranch branch = branchPoint.getBranch();
                        long revised = this.loadRevisionRevised(id, branch);
                        PointerCDORevision pointer = new PointerCDORevision(target.getEClass(), id, branch, revised, (CDOBranchVersion)target);
                        info.setSynthetic((SyntheticCDORevision)pointer);
                    }
                    info.setResult(target);
                    continue;
                }
                DetachedCDORevision detachedRevision = new DetachedCDORevision(EcorePackage.Literals.ECLASS, id, branchPoint.getBranch(), 0, 0L);
                info.setSynthetic((SyntheticCDORevision)detachedRevision);
                continue;
            }
            if (revision instanceof DetachedCDORevision) {
                DetachedCDORevision detached = (DetachedCDORevision)revision;
                info.setSynthetic((SyntheticCDORevision)detached);
                continue;
            }
            revision.freeze();
            info.setResult(revision);
        }
        return null;
    }

    private InternalCDORevision loadRevisionTarget(CDOID id, CDOBranchPoint branchPoint, int referenceChunk, IStoreAccessor accessor) {
        CDOBranch branch = branchPoint.getBranch();
        while (!branch.isMainBranch()) {
            branchPoint = branch.getBase();
            branch = branchPoint.getBranch();
            InternalCDORevision revision = accessor.readRevision(id, branchPoint, referenceChunk, (CDORevisionCacheAdder)this.revisionManager);
            if (revision == null) continue;
            revision.freeze();
            return revision;
        }
        return null;
    }

    private long loadRevisionRevised(CDOID id, CDOBranch branch) {
        InternalCDORevision revision = this.loadRevisionByVersion(id, branch.getVersion(1), -1);
        if (revision != null) {
            return revision.getTimeStamp() - 1L;
        }
        return 0L;
    }

    public InternalCDORevision loadRevisionByVersion(CDOID id, CDOBranchVersion branchVersion, int referenceChunk) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.readRevisionByVersion(id, branchVersion, referenceChunk, (CDORevisionCacheAdder)this.revisionManager);
    }

    protected void ensureChunks(InternalCDORevision revision, int referenceChunk, IStoreAccessor accessor) {
        EClass eClass = revision.getEClass();
        EStructuralFeature[] features = CDOModelUtil.getAllPersistentFeatures((EClass)eClass);
        int i = 0;
        while (i < features.length) {
            EStructuralFeature feature = features[i];
            if (feature.isMany()) {
                CDOList list = revision.getList(feature);
                int chunkEnd = Math.min(referenceChunk, list.size());
                accessor = this.ensureChunk(revision, feature, accessor, (MoveableList<Object>)list, 0, chunkEnd);
            }
            ++i;
        }
    }

    @Override
    public IStoreAccessor ensureChunk(InternalCDORevision revision, EStructuralFeature feature, int chunkStart, int chunkEnd) {
        CDOList list = revision.getList(feature);
        chunkEnd = Math.min(chunkEnd, list.size());
        return this.ensureChunk(revision, feature, StoreThreadLocal.getAccessor(), (MoveableList<Object>)list, chunkStart, chunkEnd);
    }

    protected IStoreAccessor ensureChunk(InternalCDORevision revision, EStructuralFeature feature, IStoreAccessor accessor, MoveableList<Object> list, int chunkStart, int chunkEnd) {
        IStoreChunkReader chunkReader = null;
        int fromIndex = -1;
        int j = chunkStart;
        while (j < chunkEnd) {
            if (list.get(j) == InternalCDOList.UNINITIALIZED) {
                if (fromIndex == -1) {
                    fromIndex = j;
                }
            } else if (fromIndex != -1) {
                int toIndex;
                if (chunkReader == null) {
                    if (accessor == null) {
                        accessor = StoreThreadLocal.getAccessor();
                    }
                    chunkReader = accessor.createChunkReader(revision, feature);
                }
                if (fromIndex == (toIndex = j) - 1) {
                    chunkReader.addSimpleChunk(fromIndex);
                } else {
                    chunkReader.addRangedChunk(fromIndex, toIndex);
                }
                fromIndex = -1;
            }
            ++j;
        }
        if (fromIndex != -1) {
            int toIndex;
            if (chunkReader == null) {
                if (accessor == null) {
                    accessor = StoreThreadLocal.getAccessor();
                }
                chunkReader = accessor.createChunkReader(revision, feature);
            }
            if (fromIndex == (toIndex = chunkEnd) - 1) {
                chunkReader.addSimpleChunk(fromIndex);
            } else {
                chunkReader.addRangedChunk(fromIndex, toIndex);
            }
        }
        if (chunkReader != null) {
            InternalCDOList cdoList = list instanceof InternalCDOList ? (InternalCDOList)list : null;
            List<IStoreChunkReader.Chunk> chunks = chunkReader.executeRead();
            for (IStoreChunkReader.Chunk chunk : chunks) {
                int startIndex = chunk.getStartIndex();
                int indexInChunk = 0;
                while (indexInChunk < chunk.size()) {
                    Object id = chunk.get(indexInChunk);
                    if (cdoList != null) {
                        cdoList.setWithoutFrozenCheck(startIndex + indexInChunk, id);
                    } else {
                        list.set(startIndex + indexInChunk, id);
                    }
                    ++indexInChunk;
                }
            }
        }
        return accessor;
    }

    @Override
    public InternalCDOPackageRegistry getPackageRegistry(boolean considerCommitContext) {
        InternalCDOPackageRegistry contextualPackageRegistry;
        IStoreAccessor.CommitContext commitContext;
        if (considerCommitContext && (commitContext = StoreThreadLocal.getCommitContext()) != null && (contextualPackageRegistry = commitContext.getPackageRegistry()) != null) {
            return contextualPackageRegistry;
        }
        return this.packageRegistry;
    }

    @Override
    public InternalCDOPackageRegistry getPackageRegistry() {
        return this.getPackageRegistry(true);
    }

    public void setPackageRegistry(InternalCDOPackageRegistry packageRegistry) {
        this.checkInactive();
        this.packageRegistry = packageRegistry;
    }

    @Override
    public InternalSessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public void setSessionManager(InternalSessionManager sessionManager) {
        this.checkInactive();
        this.sessionManager = sessionManager;
    }

    @Override
    public InternalCDOBranchManager getBranchManager() {
        return this.branchManager;
    }

    @Override
    public void setBranchManager(InternalCDOBranchManager branchManager) {
        this.checkInactive();
        this.branchManager = branchManager;
    }

    @Override
    public InternalCDOCommitInfoManager getCommitInfoManager() {
        return this.commitInfoManager;
    }

    public void setCommitInfoManager(InternalCDOCommitInfoManager commitInfoManager) {
        this.checkInactive();
        this.commitInfoManager = commitInfoManager;
    }

    @Override
    public InternalCDORevisionManager getRevisionManager() {
        return this.revisionManager;
    }

    @Override
    public void setRevisionManager(InternalCDORevisionManager revisionManager) {
        this.checkInactive();
        this.revisionManager = revisionManager;
    }

    @Override
    public InternalQueryManager getQueryManager() {
        return this.queryManager;
    }

    public void setQueryManager(InternalQueryManager queryManager) {
        this.checkInactive();
        this.queryManager = queryManager;
    }

    @Override
    public InternalCommitManager getCommitManager() {
        return this.commitManager;
    }

    public void setCommitManager(InternalCommitManager commitManager) {
        this.checkInactive();
        this.commitManager = commitManager;
    }

    @Override
    public InternalLockManager getLockManager() {
        return this.lockManager;
    }

    public void setLockManager(InternalLockManager lockManager) {
        this.checkInactive();
        this.lockManager = lockManager;
    }

    @Override
    public InternalCommitContext createCommitContext(InternalTransaction transaction) {
        return new TransactionCommitContext(transaction);
    }

    @Override
    public long getLastCommitTimeStamp() {
        return this.timeStampAuthority.getLastFinishedTimeStamp();
    }

    @Override
    public void setLastCommitTimeStamp(long lastCommitTimeStamp) {
        this.timeStampAuthority.setLastFinishedTimeStamp(lastCommitTimeStamp);
    }

    @Override
    public long waitForCommit(long timeout) {
        return this.timeStampAuthority.waitForCommit(timeout);
    }

    @Override
    public long[] createCommitTimeStamp(OMMonitor monitor) {
        return this.timeStampAuthority.startCommit(0L, monitor);
    }

    @Override
    public long[] forceCommitTimeStamp(long override, OMMonitor monitor) {
        return this.timeStampAuthority.startCommit(override, monitor);
    }

    @Override
    public void endCommit(long timestamp) {
        this.timeStampAuthority.endCommit(timestamp);
    }

    @Override
    public void failCommit(long timestamp) {
        this.timeStampAuthority.failCommit(timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCommitInfoHandler(CDOCommitInfoHandler handler) {
        List<CDOCommitInfoHandler> list = this.commitInfoHandlers;
        synchronized (list) {
            if (!this.commitInfoHandlers.contains(handler)) {
                this.commitInfoHandlers.add(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCommitInfoHandler(CDOCommitInfoHandler handler) {
        List<CDOCommitInfoHandler> list = this.commitInfoHandlers;
        synchronized (list) {
            this.commitInfoHandlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendCommitNotification(InternalSession sender, CDOCommitInfo commitInfo) {
        CDOCommitInfoHandler[] handlers;
        this.sessionManager.sendCommitNotification(sender, commitInfo);
        List<CDOCommitInfoHandler> list = this.commitInfoHandlers;
        synchronized (list) {
            handlers = this.commitInfoHandlers.toArray(new CDOCommitInfoHandler[this.commitInfoHandlers.size()]);
        }
        CDOCommitInfoHandler[] cDOCommitInfoHandlerArray = handlers;
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            CDOCommitInfoHandler handler = cDOCommitInfoHandlerArray[n2];
            try {
                handler.handleCommitInfo(commitInfo);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++n2;
        }
    }

    @Override
    public IQueryHandlerProvider getQueryHandlerProvider() {
        return this.queryHandlerProvider;
    }

    @Override
    public void setQueryHandlerProvider(IQueryHandlerProvider queryHandlerProvider) {
        this.queryHandlerProvider = queryHandlerProvider;
    }

    @Override
    public synchronized IQueryHandler getQueryHandler(CDOQueryInfo info) {
        IQueryHandler handler;
        String language = info.getQueryLanguage();
        if ("resources".equals(language)) {
            return new ResourcesQueryHandler();
        }
        if ("xrefs".equals(language)) {
            return new XRefsQueryHandler();
        }
        IStoreAccessor storeAccessor = StoreThreadLocal.getAccessor();
        if (storeAccessor != null && (handler = storeAccessor.getQueryHandler(info)) != null) {
            return handler;
        }
        if (this.queryHandlerProvider == null) {
            this.queryHandlerProvider = new ContainerQueryHandlerProvider((IManagedContainer)IPluginContainer.INSTANCE);
        }
        if ((handler = this.queryHandlerProvider.getQueryHandler(info)) != null) {
            return handler;
        }
        return null;
    }

    public Object[] getElements() {
        Object[] elements = new Object[]{this.packageRegistry, this.branchManager, this.revisionManager, this.sessionManager, this.queryManager, this.commitManager, this.commitInfoManager, this.lockManager, this.store};
        return elements;
    }

    public boolean isEmpty() {
        return false;
    }

    public long getCreationTime() {
        return this.store.getCreationTime();
    }

    @Override
    public void validateTimeStamp(long timeStamp) throws IllegalArgumentException {
        long creationTimeStamp = this.getCreationTime();
        if (timeStamp < creationTimeStamp) {
            throw new IllegalArgumentException(MessageFormat.format("timeStamp ({0}) < repository creation time ({1})", CDOCommonUtil.formatTimeStamp((long)timeStamp), CDOCommonUtil.formatTimeStamp((long)creationTimeStamp)));
        }
        long currentTimeStamp = this.getTimeStamp();
        if (timeStamp > currentTimeStamp) {
            throw new IllegalArgumentException(MessageFormat.format("timeStamp ({0}) > current time ({1})", CDOCommonUtil.formatTimeStamp((long)timeStamp), CDOCommonUtil.formatTimeStamp((long)currentTimeStamp)));
        }
    }

    public long getTimeStamp() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHandler(IRepository.Handler handler) {
        List<IRepository.Handler> list;
        if (handler instanceof IRepository.ReadAccessHandler) {
            list = this.readAccessHandlers;
            synchronized (list) {
                if (!this.readAccessHandlers.contains(handler)) {
                    this.readAccessHandlers.add((IRepository.ReadAccessHandler)handler);
                }
            }
        }
        if (handler instanceof IRepository.WriteAccessHandler) {
            list = this.writeAccessHandlers;
            synchronized (list) {
                if (!this.writeAccessHandlers.contains(handler)) {
                    this.writeAccessHandlers.add((IRepository.WriteAccessHandler)handler);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHandler(IRepository.Handler handler) {
        List<IRepository.Handler> list;
        if (handler instanceof IRepository.ReadAccessHandler) {
            list = this.readAccessHandlers;
            synchronized (list) {
                this.readAccessHandlers.remove(handler);
            }
        }
        if (handler instanceof IRepository.WriteAccessHandler) {
            list = this.writeAccessHandlers;
            synchronized (list) {
                this.writeAccessHandlers.remove(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyReadAccessHandlers(InternalSession session, CDORevision[] revisions, List<CDORevision> additionalRevisions) {
        IRepository.ReadAccessHandler[] handlers;
        List<IRepository.ReadAccessHandler> list = this.readAccessHandlers;
        synchronized (list) {
            int size = this.readAccessHandlers.size();
            if (size == 0) {
                return;
            }
            handlers = this.readAccessHandlers.toArray(new IRepository.ReadAccessHandler[size]);
        }
        IRepository.ReadAccessHandler[] readAccessHandlerArray = handlers;
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            IRepository.ReadAccessHandler handler = readAccessHandlerArray[n2];
            handler.handleRevisionsBeforeSending(session, revisions, additionalRevisions);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyWriteAccessHandlers(ITransaction transaction, IStoreAccessor.CommitContext commitContext, boolean beforeCommit, OMMonitor monitor) {
        IRepository.WriteAccessHandler[] handlers;
        List<IRepository.WriteAccessHandler> list = this.writeAccessHandlers;
        synchronized (list) {
            int size = this.writeAccessHandlers.size();
            if (size == 0) {
                return;
            }
            handlers = this.writeAccessHandlers.toArray(new IRepository.WriteAccessHandler[size]);
        }
        try {
            monitor.begin((double)handlers.length);
            IRepository.WriteAccessHandler[] writeAccessHandlerArray = handlers;
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                IRepository.WriteAccessHandler handler = writeAccessHandlerArray[n2];
                try {
                    if (beforeCommit) {
                        handler.handleTransactionBeforeCommitting(transaction, commitContext, monitor.fork());
                    } else {
                        handler.handleTransactionAfterCommitted(transaction, commitContext, monitor.fork());
                    }
                }
                catch (RuntimeException ex) {
                    if (!beforeCommit) {
                        OM.LOG.error((Throwable)ex);
                    }
                    throw ex;
                }
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void setInitialPackages(EPackage ... initialPackages) {
        this.checkInactive();
        this.initialPackages = initialPackages;
    }

    @Override
    public CDOReplicationInfo replicateRaw(CDODataOutput out, int lastReplicatedBranchID, long lastReplicatedCommitTime) throws IOException {
        int fromBranchID = lastReplicatedBranchID + 1;
        final int toBranchID = this.getStore().getLastBranchID();
        long fromCommitTime = lastReplicatedCommitTime + 1L;
        final long toCommitTime = this.getStore().getLastCommitTime();
        out.writeInt(toBranchID);
        out.writeLong(toCommitTime);
        IStoreAccessor.Raw accessor = (IStoreAccessor.Raw)StoreThreadLocal.getAccessor();
        accessor.rawExport(out, fromBranchID, toBranchID, fromCommitTime, toCommitTime);
        return new CDOReplicationInfo(){

            public int getLastReplicatedBranchID() {
                return toBranchID;
            }

            public long getLastReplicatedCommitTime() {
                return toCommitTime;
            }
        };
    }

    @Override
    public void replicate(CDOReplicationContext context) {
        int startID = context.getLastReplicatedBranchID() + 1;
        this.branchManager.getBranches(startID, 0, (CDOBranchHandler)context);
        long startTime = context.getLastReplicatedCommitTime();
        this.commitInfoManager.getCommitInfos(null, startTime + 1L, 0L, (CDOCommitInfoHandler)context);
    }

    @Override
    public CDOChangeSetData getChangeSet(CDOBranchPoint startPoint, CDOBranchPoint endPoint) {
        CDOChangeSetSegment[] segments = CDOChangeSetSegment.createFrom((CDOBranchPoint)startPoint, (CDOBranchPoint)endPoint);
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        Set<CDOID> ids = accessor.readChangeSet((OMMonitor)new Monitor(), segments);
        return CDORevisionUtil.createChangeSetData(ids, (CDOBranchPoint)startPoint, (CDOBranchPoint)endPoint, (CDORevisionManager)this.revisionManager);
    }

    @Override
    public Set<CDOID> getMergeData(CDORevisionAvailabilityInfo targetInfo, CDORevisionAvailabilityInfo sourceInfo, CDORevisionAvailabilityInfo targetBaseInfo, CDORevisionAvailabilityInfo sourceBaseInfo, OMMonitor monitor) {
        CDOBranchPoint target = targetInfo.getBranchPoint();
        CDOBranchPoint source = sourceInfo.getBranchPoint();
        monitor.begin(5.0);
        try {
            IStoreAccessor accessor = StoreThreadLocal.getAccessor();
            HashSet<CDOID> ids = new HashSet<CDOID>();
            if (targetBaseInfo == null && sourceBaseInfo == null) {
                if (CDOBranchUtil.isContainedBy((CDOBranchPoint)source, (CDOBranchPoint)target)) {
                    ids.addAll(accessor.readChangeSet(monitor.fork(), CDOChangeSetSegment.createFrom((CDOBranchPoint)source, (CDOBranchPoint)target)));
                } else if (CDOBranchUtil.isContainedBy((CDOBranchPoint)target, (CDOBranchPoint)source)) {
                    ids.addAll(accessor.readChangeSet(monitor.fork(), CDOChangeSetSegment.createFrom((CDOBranchPoint)target, (CDOBranchPoint)source)));
                } else {
                    CDOBranchPoint ancestor = CDOBranchUtil.getAncestor((CDOBranchPoint)target, (CDOBranchPoint)source);
                    ids.addAll(accessor.readChangeSet(monitor.fork(), CDOChangeSetSegment.createFrom((CDOBranchPoint)ancestor, (CDOBranchPoint)target)));
                    ids.addAll(accessor.readChangeSet(monitor.fork(), CDOChangeSetSegment.createFrom((CDOBranchPoint)ancestor, (CDOBranchPoint)source)));
                }
            } else {
                CDORevisionAvailabilityInfo sourceBaseInfoToUse = sourceBaseInfo == null ? targetBaseInfo : sourceBaseInfo;
                ids.addAll(accessor.readChangeSet(monitor.fork(), CDOChangeSetSegment.createFrom((CDOBranchPoint)targetBaseInfo.getBranchPoint(), (CDOBranchPoint)target)));
                ids.addAll(accessor.readChangeSet(monitor.fork(), CDOChangeSetSegment.createFrom((CDOBranchPoint)sourceBaseInfoToUse.getBranchPoint(), (CDOBranchPoint)source)));
            }
            this.loadMergeData(ids, targetInfo, monitor.fork());
            this.loadMergeData(ids, sourceInfo, monitor.fork());
            if (targetBaseInfo != null) {
                this.loadMergeData(ids, targetBaseInfo, monitor.fork());
            }
            if (sourceBaseInfo != null) {
                this.loadMergeData(ids, sourceBaseInfo, monitor.fork());
            }
            HashSet<CDOID> hashSet = ids;
            return hashSet;
        }
        finally {
            monitor.done();
        }
    }

    private void loadMergeData(Set<CDOID> ids, CDORevisionAvailabilityInfo info, OMMonitor monitor) {
        int size = ids.size();
        monitor.begin((double)size);
        try {
            CDOBranchPoint branchPoint = info.getBranchPoint();
            for (CDOID id : ids) {
                if (info.containsRevision(id)) {
                    info.removeRevision(id);
                } else {
                    InternalCDORevision revision = this.getRevisionFromBranch(id, branchPoint);
                    if (revision != null) {
                        info.addRevision((CDORevisionKey)revision);
                    } else {
                        info.removeRevision(id);
                    }
                }
                monitor.worked();
            }
        }
        finally {
            monitor.done();
        }
    }

    private InternalCDORevision getRevisionFromBranch(CDOID id, CDOBranchPoint branchPoint) {
        InternalCDORevision revision = this.revisionManager.getRevision(id, branchPoint, -1, 0, true);
        return revision;
    }

    @Override
    public void queryLobs(List<byte[]> ids) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        accessor.queryLobs(ids);
    }

    @Override
    public void handleLobs(long fromTime, long toTime, CDOLobHandler handler) throws IOException {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        accessor.handleLobs(fromTime, toTime, handler);
    }

    @Override
    public void loadLob(byte[] id, OutputStream out) throws IOException {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        accessor.loadLob(id, out);
    }

    @Override
    public void handleRevisions(EClass eClass, CDOBranch branch, boolean exactBranch, long timeStamp, boolean exactTime, final CDORevisionHandler handler) {
        CDORevisionHandler wrapper = handler;
        if (!exactBranch) {
            if (exactTime && timeStamp == 0L) {
                throw new IllegalArgumentException("Time stamp must be specified if exactBranch==false and exactTime==true");
            }
            wrapper = new CDORevisionHandler(){
                private Set<CDOID> handled = new HashSet<CDOID>();

                public boolean handleRevision(CDORevision revision) {
                    if (this.handled.add(revision.getID())) {
                        return handler.handleRevision(revision);
                    }
                    return true;
                }
            };
        }
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        while (branch != null) {
            accessor.handleRevisions(eClass, branch, timeStamp, exactTime, wrapper);
            if (exactBranch) break;
            CDOBranchPoint base = branch.getBase();
            branch = base.getBranch();
            timeStamp = base.getTimeStamp();
        }
    }

    public String toString() {
        return MessageFormat.format("Repository[{0}]", this.name);
    }

    @Override
    public boolean isSkipInitialization() {
        return this.skipInitialization;
    }

    @Override
    public void setSkipInitialization(boolean skipInitialization) {
        this.skipInitialization = skipInitialization;
    }

    protected void initProperties() {
        String valueIntegrity;
        String valueAudits = this.properties.get("supportingAudits");
        this.supportingAudits = valueAudits != null ? Boolean.valueOf(valueAudits) : this.store.getRevisionTemporality() == IStore.RevisionTemporality.AUDITING;
        String valueBranches = this.properties.get("supportingBranches");
        this.supportingBranches = valueBranches != null ? Boolean.valueOf(valueBranches) : this.store.getRevisionParallelism() == IStore.RevisionParallelism.BRANCHING;
        String valueEcore = this.properties.get("supportingEcore");
        if (valueEcore != null) {
            this.supportingEcore = Boolean.valueOf(valueEcore);
        }
        if ((valueIntegrity = this.properties.get("ensureReferentialIntegrity")) != null) {
            this.ensuringReferentialIntegrity = Boolean.valueOf(valueIntegrity);
        }
    }

    @Override
    public void initSystemPackages() {
        IStoreAccessor writer = this.store.getWriter(null);
        StoreThreadLocal.setAccessor(writer);
        try {
            ArrayList<InternalCDOPackageUnit> units = new ArrayList<InternalCDOPackageUnit>();
            units.add(this.initSystemPackage((EPackage)EcorePackage.eINSTANCE));
            units.add(this.initSystemPackage((EPackage)EresourcePackage.eINSTANCE));
            units.add(this.initSystemPackage((EPackage)EtypesPackage.eINSTANCE));
            if (this.initialPackages != null) {
                EPackage[] ePackageArray = this.initialPackages;
                int n = this.initialPackages.length;
                int n2 = 0;
                while (n2 < n) {
                    EPackage initialPackage = ePackageArray[n2];
                    if (!this.packageRegistry.containsKey((Object)initialPackage.getNsURI())) {
                        units.add(this.initSystemPackage(initialPackage));
                    }
                    ++n2;
                }
            }
            InternalCDOPackageUnit[] systemUnits = units.toArray(new InternalCDOPackageUnit[units.size()]);
            writer.writePackageUnits(systemUnits, (OMMonitor)new Monitor());
            writer.commit((OMMonitor)new Monitor());
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    protected InternalCDOPackageUnit initSystemPackage(EPackage ePackage) {
        EMFUtil.registerPackage((EPackage)ePackage, (EPackage.Registry[])new EPackage.Registry[]{this.packageRegistry});
        InternalCDOPackageInfo packageInfo = this.packageRegistry.getPackageInfo(ePackage);
        InternalCDOPackageUnit packageUnit = packageInfo.getPackageUnit();
        packageUnit.setTimeStamp(this.store.getCreationTime());
        packageUnit.setState(CDOPackageUnit.State.LOADED);
        return packageUnit;
    }

    @Override
    public void initMainBranch(InternalCDOBranchManager branchManager, long timeStamp) {
        branchManager.initMainBranch(false, timeStamp);
    }

    protected void initRootResource() {
        CDOBranchPoint head = this.branchManager.getMainBranch().getHead();
        CDOIDTemp tempID = CDOIDUtil.createTempObject((int)1);
        CDORevisionFactory factory = this.getRevisionManager().getFactory();
        InternalCDORevision rootResource = (InternalCDORevision)factory.createRevision(EresourcePackage.Literals.CDO_RESOURCE);
        rootResource.setBranchPoint(head);
        rootResource.setContainerID((Object)CDOID.NULL);
        rootResource.setContainingFeatureID(0);
        rootResource.setID((CDOID)tempID);
        rootResource.setResourceID((CDOID)tempID);
        InternalSession session = this.getSessionManager().openSession(null);
        InternalTransaction transaction = session.openTransaction(1, head);
        TransactionCommitContext commitContext = new TransactionCommitContext(transaction){

            protected long[] createTimeStamp(OMMonitor monitor) {
                InternalRepository repository = this.getTransaction().getSession().getManager().getRepository();
                return repository.forceCommitTimeStamp(Repository.this.store.getCreationTime(), monitor);
            }

            public String getUserID() {
                return "CDO_SYSTEM";
            }

            public String getCommitComment() {
                return "<initialize>";
            }
        };
        commitContext.setNewObjects(new InternalCDORevision[]{rootResource});
        commitContext.preWrite();
        commitContext.write((OMMonitor)new Monitor());
        commitContext.commit((OMMonitor)new Monitor());
        String rollbackMessage = commitContext.getRollbackMessage();
        if (rollbackMessage != null) {
            throw new TransactionException(rollbackMessage);
        }
        this.rootResourceID = commitContext.getIDMappings().get(tempID);
        commitContext.postCommit(true);
        session.close();
    }

    protected void readRootResource() {
        IStoreAccessor reader = this.store.getReader(null);
        StoreThreadLocal.setAccessor(reader);
        try {
            CDOBranchPoint head = this.branchManager.getMainBranch().getHead();
            this.rootResourceID = reader.readResourceID(CDOID.NULL, null, head);
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    protected void readPackageUnits() {
        IStoreAccessor reader = this.store.getReader(null);
        StoreThreadLocal.setAccessor(reader);
        try {
            Collection<InternalCDOPackageUnit> packageUnits = reader.readPackageUnits();
            for (InternalCDOPackageUnit packageUnit : packageUnits) {
                this.packageRegistry.putPackageUnit(packageUnit);
            }
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.store, "store");
        this.checkState(!StringUtil.isEmpty((String)this.name), "name is empty");
        this.checkState(this.packageRegistry, "packageRegistry");
        this.checkState(this.sessionManager, "sessionManager");
        this.checkState(this.branchManager, "branchManager");
        this.checkState(this.revisionManager, "revisionManager");
        this.checkState(this.queryManager, "queryManager");
        this.checkState(this.commitInfoManager, "commitInfoManager");
        this.checkState(this.commitManager, "commitManager");
        this.checkState(this.lockManager, "lockingManager");
        this.packageRegistry.setReplacingDescriptors(true);
        this.packageRegistry.setPackageProcessor((InternalCDOPackageRegistry.PackageProcessor)this);
        this.packageRegistry.setPackageLoader((InternalCDOPackageRegistry.PackageLoader)this);
        this.branchManager.setBranchLoader((InternalCDOBranchManager.BranchLoader)this);
        this.branchManager.setTimeProvider((CDOTimeProvider)this);
        this.revisionManager.setRevisionLoader((InternalCDORevisionManager.RevisionLoader)this);
        this.sessionManager.setRepository(this);
        this.queryManager.setRepository(this);
        this.commitInfoManager.setCommitInfoLoader((InternalCDOCommitInfoManager.CommitInfoLoader)this);
        this.commitManager.setRepository(this);
        this.lockManager.setRepository(this);
        this.store.setRepository(this);
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.initProperties();
        this.store.setRevisionTemporality(this.supportingAudits ? IStore.RevisionTemporality.AUDITING : IStore.RevisionTemporality.NONE);
        this.store.setRevisionParallelism(this.supportingBranches ? IStore.RevisionParallelism.BRANCHING : IStore.RevisionParallelism.NONE);
        this.revisionManager.setSupportingAudits(this.supportingAudits);
        this.revisionManager.setSupportingBranches(this.supportingBranches);
        LifecycleUtil.activate((Object)this.store);
        LifecycleUtil.activate((Object)this.packageRegistry);
        LifecycleUtil.activate((Object)this.sessionManager);
        LifecycleUtil.activate((Object)this.revisionManager);
        LifecycleUtil.activate((Object)this.branchManager);
        LifecycleUtil.activate((Object)this.queryManager);
        LifecycleUtil.activate((Object)this.commitInfoManager);
        LifecycleUtil.activate((Object)this.commitManager);
        LifecycleUtil.activate((Object)this.queryHandlerProvider);
        if (!this.skipInitialization) {
            long lastCommitTimeStamp = Math.max(this.store.getCreationTime(), this.store.getLastCommitTime());
            this.timeStampAuthority.setLastFinishedTimeStamp(lastCommitTimeStamp);
            this.initMainBranch(this.branchManager, lastCommitTimeStamp);
            if (this.store.isFirstStart()) {
                this.initSystemPackages();
                this.initRootResource();
            } else {
                this.readPackageUnits();
                this.readRootResource();
            }
        }
        LifecycleUtil.activate((Object)this.lockManager);
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.lockManager);
        LifecycleUtil.deactivate((Object)this.queryHandlerProvider);
        LifecycleUtil.deactivate((Object)this.commitManager);
        LifecycleUtil.deactivate((Object)this.commitInfoManager);
        LifecycleUtil.deactivate((Object)this.queryManager);
        LifecycleUtil.deactivate((Object)this.revisionManager);
        LifecycleUtil.deactivate((Object)this.sessionManager);
        LifecycleUtil.deactivate((Object)this.store);
        LifecycleUtil.deactivate((Object)this.branchManager);
        LifecycleUtil.deactivate((Object)this.packageRegistry);
        super.doDeactivate();
    }

    public static class Default
    extends Repository {
        protected void doBeforeActivate() throws Exception {
            if (this.getPackageRegistry(false) == null) {
                this.setPackageRegistry(this.createPackageRegistry());
            }
            if (this.getSessionManager() == null) {
                this.setSessionManager(this.createSessionManager());
            }
            if (this.getBranchManager() == null) {
                this.setBranchManager(this.createBranchManager());
            }
            if (this.getRevisionManager() == null) {
                this.setRevisionManager(this.createRevisionManager());
            }
            if (this.getQueryManager() == null) {
                this.setQueryManager(this.createQueryManager());
            }
            if (this.getCommitInfoManager() == null) {
                this.setCommitInfoManager(this.createCommitInfoManager());
            }
            if (this.getCommitManager() == null) {
                this.setCommitManager(this.createCommitManager());
            }
            if (this.getLockManager() == null) {
                this.setLockManager(this.createLockManager());
            }
            super.doBeforeActivate();
        }

        protected InternalCDOPackageRegistry createPackageRegistry() {
            return new CDOPackageRegistryImpl();
        }

        protected InternalSessionManager createSessionManager() {
            return new SessionManager();
        }

        protected InternalCDOBranchManager createBranchManager() {
            return CDOBranchUtil.createBranchManager();
        }

        protected InternalCDORevisionManager createRevisionManager() {
            return (InternalCDORevisionManager)CDORevisionUtil.createRevisionManager();
        }

        protected InternalQueryManager createQueryManager() {
            return new QueryManager();
        }

        protected InternalCDOCommitInfoManager createCommitInfoManager() {
            return CDOCommitInfoUtil.createCommitInfoManager();
        }

        protected InternalCommitManager createCommitManager() {
            return new CommitManager();
        }

        protected InternalLockManager createLockManager() {
            return new LockManager();
        }
    }
}

