/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.wfm.documenteditor.editor;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.EditFormPage;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.PreviewFormPage;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.provider.InfoelementsItemProviderAdapterFactory;
import es.upv.dsic.issi.dplfw.om.User;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.CredentialsManagerPlugin;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ICredentialsManager;
import es.upv.dsic.issi.dplfw.wfm.Activity;
import es.upv.dsic.issi.dplfw.wfm.Actor;
import es.upv.dsic.issi.dplfw.wfm.FlowNode;
import es.upv.dsic.issi.dplfw.wfm.Process;
import es.upv.dsic.issi.dplfw.wfm.Subprocess;
import es.upv.dsic.issi.dplfw.wfm.WfmPackage;
import es.upv.dsic.issi.dplfw.wfm.documenteditor.WfmDocumentEditorPlugin;
import es.upv.dsic.issi.dplfw.wfm.documenteditor.editor.DocumentFormEditor;
import es.upv.dsic.issi.dplfw.wfm.documenteditor.editor.util.JFaceUtil;
import es.upv.dsic.issi.dplfw.wfm.provider.WfmItemProviderAdapterFactory;
import java.util.ArrayList;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class UserTasksPage
extends FormPage {
    private static final int MARGIN = 10;
    private static final int SPACING = 5;
    private ICredentialsManager credentialsManager;
    private User user;
    private Button viewButton;
    private Button editButton;
    private TreeViewer viewer;

    public UserTasksPage(DocumentFormEditor documentFormEditor, User user) {
        super((FormEditor)documentFormEditor, "es.upv.dsic.issi.dplfw.wfm.documenteditor.editor.UserTasksPage", "Tasks for " + user.getName());
        this.user = user;
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.credentialsManager = CredentialsManagerPlugin.getDefault().getManagersRegistry().getActiveManager();
    }

    public void refresh() {
        this.viewer.refresh();
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        form.setText(this.getTitle());
        FillLayout bodyLayout = new FillLayout(768);
        bodyLayout.marginHeight = 10;
        bodyLayout.marginWidth = 10;
        form.getBody().setLayout((Layout)bodyLayout);
        toolkit.decorateFormHeading(form.getForm());
        Section section = toolkit.createSection(form.getBody(), 256);
        section.setText("User Tasks Summary");
        section.setLayout((Layout)bodyLayout);
        Composite topComposite = toolkit.createComposite((Composite)section);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 10;
        topComposite.setLayout((Layout)gridLayout);
        Composite treeComposite = toolkit.createComposite(topComposite);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        treeComposite.setLayout((Layout)treeColumnLayout);
        treeComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new TreeViewer(treeComposite, 67588);
        this.createColumns(this.viewer);
        treeColumnLayout.setColumnData((Widget)this.viewer.getTree().getColumn(0), (ColumnLayoutData)new ColumnWeightData(1));
        treeColumnLayout.setColumnData((Widget)this.viewer.getTree().getColumn(1), (ColumnLayoutData)new ColumnWeightData(1));
        treeColumnLayout.setColumnData((Widget)this.viewer.getTree().getColumn(2), (ColumnLayoutData)new ColumnPixelData(70));
        treeColumnLayout.setColumnData((Widget)this.viewer.getTree().getColumn(3), (ColumnLayoutData)new ColumnPixelData(70));
        treeColumnLayout.setColumnData((Widget)this.viewer.getTree().getColumn(4), (ColumnLayoutData)new ColumnPixelData(70));
        this.viewer.setContentProvider((IContentProvider)new EditingActivitiesSetContentProvider());
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.setInput((Object)this.getProcess());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Activity activity;
                IStructuredSelection structuredSelection = (IStructuredSelection)event.getSelection();
                if (!structuredSelection.isEmpty() && (activity = (Activity)structuredSelection.getFirstElement()).getInfoElement() != null) {
                    UserTasksPage.this.editButton.setEnabled(UserTasksPage.this.canEdit(activity) && !activity.isAproved());
                    UserTasksPage.this.viewButton.setEnabled(UserTasksPage.this.canRead(activity));
                }
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.viewer, (int)2);
        Composite buttonsComposite = toolkit.createComposite(topComposite);
        FillLayout buttonsLayout = new FillLayout(512);
        buttonsLayout.spacing = 5;
        buttonsComposite.setLayout((Layout)buttonsLayout);
        buttonsComposite.setLayoutData((Object)new GridData(4, 1, false, false));
        this.viewButton = toolkit.createButton(buttonsComposite, "Open in Viewer...", 0);
        this.viewButton.setEnabled(false);
        this.editButton = toolkit.createButton(buttonsComposite, "Open in Editor...", 0);
        this.editButton.setEnabled(false);
        this.viewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)UserTasksPage.this.viewer.getSelection();
                Activity activity = (Activity)selection.getFirstElement();
                try {
                    InfoElement infoElement = activity.getInfoElement();
                    if (infoElement != null) {
                        PreviewFormPage page = new PreviewFormPage(UserTasksPage.this.getEditor(), infoElement, activity.getName());
                        UserTasksPage.this.getEditor().addPage((IFormPage)page);
                        UserTasksPage.this.getEditor().setActivePage(page.getId());
                        Composite composite = UserTasksPage.this.getPartControl().getParent();
                        if (composite instanceof CTabFolder) {
                            CTabFolder tabFolder = (CTabFolder)composite;
                            tabFolder.getItem(tabFolder.getItemCount() - 1).setShowClose(true);
                        }
                    }
                }
                catch (PartInitException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)UserTasksPage.this.viewer.getSelection();
                Activity activity = (Activity)selection.getFirstElement();
                try {
                    InfoElement infoElement = activity.getInfoElement();
                    if (infoElement != null) {
                        EditFormPage page = new EditFormPage(UserTasksPage.this.getEditor(), infoElement, activity.getName());
                        UserTasksPage.this.getEditor().addPage((IFormPage)page);
                        UserTasksPage.this.getEditor().setActivePage(page.getId());
                        Composite composite = UserTasksPage.this.getPartControl().getParent();
                        if (composite instanceof CTabFolder) {
                            CTabFolder tabFolder = (CTabFolder)composite;
                            tabFolder.getItem(tabFolder.getItemCount() - 1).setShowClose(true);
                        }
                    }
                }
                catch (PartInitException e1) {
                    e1.printStackTrace();
                }
            }
        });
        section.setClient((Control)topComposite);
    }

    private void createColumns(TreeViewer viewer) {
        String[] titles = new String[]{"Activity", "Content", "Visible", "Editable", "Approved"};
        TreeViewerColumn col0 = this.createTreeViewerColumn(viewer, titles[0]);
        col0.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new WfmItemProviderAdapterFactory());

            public String getText(Object element) {
                return ((Activity)element).getName();
            }

            public Image getImage(Object element) {
                return this.labelProvider.getImage(element);
            }

            public String getToolTipText(Object element) {
                return ((Activity)element).getDescription();
            }
        });
        TreeViewerColumn col1 = this.createTreeViewerColumn(viewer, titles[1]);
        col1.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
            AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)new InfoelementsItemProviderAdapterFactory());

            public String getText(Object element) {
                return ((Activity)element).getName();
            }

            public Image getImage(Object element) {
                return this.labelProvider.getImage(element);
            }

            public String getToolTipText(Object element) {
                InfoElement infoElement = ((Activity)element).getInfoElement();
                if (infoElement != null) {
                    return infoElement.getDescription();
                }
                return null;
            }
        });
        TreeViewerColumn col2 = this.createTreeViewerColumn(viewer, titles[2], 0x1000000);
        col2.setLabelProvider((CellLabelProvider)new CheckboxCellLabelProvider(this){

            @Override
            public Image getImage(Object element) {
                if (this.canRead((Activity)element)) {
                    return WfmDocumentEditorPlugin.getPlugin().getImageRegistry().get("IMG_OBJ16_BULLETGREEN");
                }
                return WfmDocumentEditorPlugin.getPlugin().getImageRegistry().get("IMG_OBJ16_BULLETRED");
            }
        });
        TreeViewerColumn col3 = this.createTreeViewerColumn(viewer, titles[3], 0x1000000);
        col3.setLabelProvider((CellLabelProvider)new CheckboxCellLabelProvider(this){

            @Override
            public Image getImage(Object element) {
                if (this.canEdit((Activity)element)) {
                    return WfmDocumentEditorPlugin.getPlugin().getImageRegistry().get("IMG_OBJ16_BULLETGREEN");
                }
                return WfmDocumentEditorPlugin.getPlugin().getImageRegistry().get("IMG_OBJ16_BULLETRED");
            }
        });
        TreeViewerColumn col4 = this.createTreeViewerColumn(viewer, titles[4], 0x1000000);
        col4.setLabelProvider((CellLabelProvider)new CheckboxCellLabelProvider(this){

            @Override
            public Image getImage(Object element) {
                return JFaceUtil.getCheckboxImage(((Activity)element).isAproved(), this.canApprove((Activity)element));
            }
        });
        col4.setEditingSupport((EditingSupport)new ApprovingEditingSupport(viewer));
        col4.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ((DocumentFormEditor)UserTasksPage.this.getEditor()).refreshDocumentPage();
            }
        });
    }

    private TreeViewerColumn createTreeViewerColumn(TreeViewer viewer, String title, int style) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(viewer, style);
        TreeColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    private TreeViewerColumn createTreeViewerColumn(TreeViewer viewer, String title) {
        return this.createTreeViewerColumn(viewer, title, 0);
    }

    protected EditingDomain getEditingDomain() {
        return ((IEditingDomainProvider)this.getEditor()).getEditingDomain();
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.getEditingDomain().getCommandStack()).isSaveNeeded();
    }

    private EObject getProcess() {
        return (EObject)this.getResource().getContents().get(0);
    }

    private Resource getResource() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        return this.getEditingDomain().getResourceSet().getResource(resourceURI, true);
    }

    private boolean isResponsible(Activity activity) {
        if (activity.getResponsible() != null) {
            es.upv.dsic.issi.dplfw.om.Actor activityResponsible = this.credentialsManager.resolveActor(activity.getResponsible().getUuid());
            return this.credentialsManager.isIncluded((es.upv.dsic.issi.dplfw.om.Actor)this.user, activityResponsible);
        }
        return false;
    }

    private boolean canRead(Activity activity) {
        for (Actor wfmActor : activity.getReaders()) {
            es.upv.dsic.issi.dplfw.om.Actor omActor = this.credentialsManager.resolveActor(wfmActor.getUuid());
            if (!this.credentialsManager.isIncluded((es.upv.dsic.issi.dplfw.om.Actor)this.user, omActor)) continue;
            return true;
        }
        return false;
    }

    private boolean canEdit(Activity activity) {
        for (Actor wfmActor : activity.getEditors()) {
            es.upv.dsic.issi.dplfw.om.Actor omActor = this.credentialsManager.resolveActor(wfmActor.getUuid());
            if (!this.credentialsManager.isIncluded((es.upv.dsic.issi.dplfw.om.Actor)this.user, omActor)) continue;
            return true;
        }
        return false;
    }

    private boolean canApprove(Activity activity) {
        return this.isResponsible(activity);
    }

    private class ApprovingEditingSupport
    extends EditingSupport {
        TreeViewer viewer;

        public ApprovingEditingSupport(TreeViewer viewer) {
            super((ColumnViewer)viewer);
            this.viewer = viewer;
        }

        protected void setValue(Object element, Object value) {
            Activity activity = (Activity)element;
            Command command = SetCommand.create((EditingDomain)UserTasksPage.this.getEditingDomain(), (Object)activity, (Object)WfmPackage.Literals.ACTIVITY__APROVED, (Object)value);
            if (command.canExecute()) {
                UserTasksPage.this.getEditingDomain().getCommandStack().execute(command);
                this.viewer.update(element, null);
            }
        }

        protected Object getValue(Object element) {
            return ((Activity)element).isAproved();
        }

        protected CellEditor getCellEditor(Object element) {
            CheckboxCellEditor checkboxCellEditor = new CheckboxCellEditor((Composite)this.viewer.getTree());
            checkboxCellEditor.setValue(this.getValue(element));
            return checkboxCellEditor;
        }

        protected boolean canEdit(Object element) {
            return UserTasksPage.this.canApprove((Activity)element);
        }
    }

    abstract class CheckboxCellLabelProvider
    extends StyledCellLabelProvider {
        CheckboxCellLabelProvider() {
        }

        protected void paint(Event event, Object element) {
            Image tmpImage = this.getImage(element);
            int x = event.x;
            int y = event.y;
            int height = event.height;
            int width = ((Tree)event.widget).getColumn(event.index).getWidth();
            GC gc = event.gc;
            int tmpX = (width - tmpImage.getBounds().width) / 2;
            int tmpY = (height - tmpImage.getBounds().height) / 2;
            tmpX = Math.max(tmpX, 0);
            tmpY = Math.max(tmpY, 0);
            gc.drawImage(tmpImage, tmpX + x, tmpY + y);
        }

        public abstract Image getImage(Object var1);
    }

    private class EditingActivitiesSetContentProvider
    implements ITreeContentProvider {
        private EditingActivitiesSetContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Process process = (Process)inputElement;
            ArrayList<Activity> activities = new ArrayList<Activity>();
            for (FlowNode node : process.getNodes()) {
                if (!(node instanceof Activity)) continue;
                activities.add((Activity)node);
            }
            return activities.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Subprocess;
        }
    }
}

