/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.wfm.documenteditor.editor;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEDisplayViewer;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEEditViewer;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IPropertyModifier;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl.InfoElementPropertyModifier;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.om.User;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.CredentialsManagerPlugin;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ICredentialsManager;
import es.upv.dsic.issi.dplfw.wfm.Activity;
import es.upv.dsic.issi.dplfw.wfm.Actor;
import es.upv.dsic.issi.dplfw.wfm.FlowNode;
import es.upv.dsic.issi.dplfw.wfm.Process;
import es.upv.dsic.issi.dplfw.wfm.documenteditor.WfmDocumentEditorPlugin;
import es.upv.dsic.issi.dplfw.wfm.documenteditor.editor.DocumentFormEditor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class FullDocumentPage
extends FormPage {
    private static final int MARGIN_WIDTH = 10;
    private static final String TITLE_BACKGROUND_COLOR = "TITLE_BACKGROUND_COLOR";
    private User user;
    private Section topSection;
    private boolean needsRefresh;
    private List<Section> sections = new ArrayList<Section>();

    public FullDocumentPage(DocumentFormEditor documentFormEditor, User user) {
        super((FormEditor)documentFormEditor, "es.upv.dsic.issi.dplfw.wfm.documenteditor.editor.FullDocumentPage", "Document");
        this.user = user;
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
    }

    protected static ICredentialsManager getCredentialsManager() {
        return CredentialsManagerPlugin.getDefault().getManagersRegistry().getActiveManager();
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        Color bgColor = toolkit.getColors().getBackground();
        JFaceResources.getColorRegistry().put(TITLE_BACKGROUND_COLOR, new RGB(bgColor.getRGB().getHSB()[0], bgColor.getRGB().getHSB()[1], (float)((double)bgColor.getRGB().getHSB()[2] * 0.9)));
        ScrolledForm form = managedForm.getForm();
        form.setText("Document");
        TableWrapLayout layout = new TableWrapLayout();
        layout.leftMargin = 10;
        layout.rightMargin = 10;
        layout.makeColumnsEqualWidth = true;
        form.getBody().setLayout((Layout)layout);
        form.setDelayedReflow(true);
        toolkit.decorateFormHeading(form.getForm());
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(managedForm.getForm().getShell());
        try {
            dialog.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.setTaskName("Creating custom editor...");
                    FullDocumentPage.this.sections.clear();
                    FullDocumentPage.this.topSection = FullDocumentPage.this.createSectionForActivity((Activity)FullDocumentPage.this.getProcess(), FullDocumentPage.this.getManagedForm().getToolkit(), FullDocumentPage.this.getManagedForm().getForm().getBody());
                    FullDocumentPage.this.getManagedForm().getForm().reflow(true);
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.createToolBarActions(managedForm);
    }

    protected void createToolBarActions(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        Action collapseAction = new Action("Expand", 1){

            public void run() {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(FullDocumentPage.this.getManagedForm().getForm().getShell());
                try {
                    dialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.setTaskName("Expanding document contents...");
                            for (final Section section : FullDocumentPage.this.sections) {
                                if (monitor.isCanceled()) break;
                                FullDocumentPage.this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!section.isDisposed()) {
                                            section.setExpanded(true);
                                        }
                                    }
                                });
                            }
                            FullDocumentPage.this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!FullDocumentPage.this.getManagedForm().getForm().isDisposed()) {
                                        FullDocumentPage.this.getManagedForm().getForm().reflow(true);
                                    }
                                }
                            });
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        collapseAction.setToolTipText("Expand All");
        collapseAction.setImageDescriptor(WfmDocumentEditorPlugin.getPlugin().getImageRegistry().getDescriptor("IMG_ETOOL16_EXPAND"));
        Action expandAction = new Action("Collapse", 1){

            public void run() {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(FullDocumentPage.this.getManagedForm().getForm().getShell());
                try {
                    dialog.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.setTaskName("Collapsing document contents...");
                            for (final Section section : FullDocumentPage.this.sections) {
                                if (monitor.isCanceled()) break;
                                FullDocumentPage.this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!section.isDisposed()) {
                                            section.setExpanded(false);
                                        }
                                    }
                                });
                            }
                            FullDocumentPage.this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (!FullDocumentPage.this.getManagedForm().getForm().isDisposed()) {
                                        FullDocumentPage.this.getManagedForm().getForm().reflow(true);
                                    }
                                }
                            });
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        expandAction.setToolTipText("Collapse All");
        expandAction.setImageDescriptor(WfmDocumentEditorPlugin.getPlugin().getImageRegistry().getDescriptor("IMG_ETOOL16_COLLAPSE"));
        form.getToolBarManager().add((IAction)collapseAction);
        form.getToolBarManager().add((IAction)expandAction);
        form.getToolBarManager().update(true);
    }

    protected Section createSectionForActivity(Activity activity, FormToolkit toolkit, Composite parent) {
        Section section = toolkit.createSection(parent, 4);
        section.setBackground(JFaceResources.getColorRegistry().get(TITLE_BACKGROUND_COLOR));
        section.setText(activity.getName() != null ? activity.getName() : "");
        this.sections.add(section);
        Composite composite = toolkit.createComposite((Composite)section, 0);
        composite.setBackground(toolkit.getColors().getBackground());
        TableWrapLayout layout = new TableWrapLayout();
        layout.rightMargin = 0;
        composite.setLayout((Layout)layout);
        TableWrapData layoutData = new TableWrapData(256);
        composite.setLayoutData((Object)layoutData);
        if (activity.getInfoElement() != null && (FullDocumentPage.canRead(activity, this.user) || FullDocumentPage.canEdit(activity, this.user))) {
            try {
                IIEDisplayViewer viewer = this.createDisseminatorForInfoElement(activity, toolkit, composite);
                viewer.getControl().setLayoutData((Object)layoutData);
                viewer.getControl().addListener(11, new Listener(){
                    Runnable reflowRunnable = new Runnable(){

                        @Override
                        public void run() {
                            if (!FullDocumentPage.this.getManagedForm().getForm().isDisposed()) {
                                FullDocumentPage.this.getManagedForm().getForm().reflow(true);
                            }
                        }
                    };

                    public void handleEvent(Event event) {
                        Display.getDefault().timerExec(50, this.reflowRunnable);
                    }
                });
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (activity instanceof Process) {
            for (FlowNode node : ((Process)activity).getNodes()) {
                if (!(node instanceof Activity)) continue;
                this.createSectionForActivity((Activity)node, toolkit, composite);
            }
        }
        section.setLayoutData((Object)new TableWrapData(256, 256));
        section.setClient((Control)composite);
        return section;
    }

    protected IIEDisplayViewer createDisseminatorForInfoElement(Activity activity, FormToolkit toolkit, Composite parent) throws ClassNotFoundException {
        IIEDisplayViewer ieViewer = null;
        try {
            if (activity.getInfoElement() != null) {
                InfoElement infoElement = activity.getInfoElement();
                IConfigurationElement configElement = FullDocumentPage.getConfigurationElementForIE(infoElement);
                String viewerClassName = FullDocumentPage.canEdit(activity, this.user) && !activity.isAproved() ? configElement.getAttribute("editViewer") : configElement.getAttribute("displayViewer");
                if (viewerClassName == null) {
                    throw new ClassNotFoundException();
                }
                Class<?> viewerClass = Class.forName(viewerClassName);
                Constructor<?> viewerConstructor = viewerClass.getConstructor(Composite.class);
                ieViewer = (IIEDisplayViewer)viewerConstructor.newInstance(parent);
                ieViewer.getControl().setBackground(toolkit.getColors().getBackground());
                IContentProvider contentProvider = (IContentProvider)configElement.createExecutableExtension("contentProvider");
                IBaseLabelProvider labelProvider = (IBaseLabelProvider)configElement.createExecutableExtension("labelProvider");
                ieViewer.setContentProvider(contentProvider);
                ieViewer.setLabelProvider(labelProvider);
                FullDocumentPage.cascadeAdapt(parent, toolkit);
                if (ieViewer instanceof IIEEditViewer) {
                    ((IIEEditViewer)ieViewer).setPropertyModifier((IPropertyModifier)new InfoElementPropertyModifier(this.getEditingDomain()));
                }
                ieViewer.setInput((Object)infoElement);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return ieViewer;
    }

    protected static IConfigurationElement getConfigurationElementForIE(InfoElement infoElement) {
        IConfigurationElement[] extensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = registry.getConfigurationElementsFor("es.upv.dsic.issi.dplfw.infoelement.editor");
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            String infoElementType = configElement.getAttribute("infoElement");
            try {
                Class<?> elementClass = Class.forName(infoElementType);
                if (elementClass.isInstance(infoElement)) {
                    return configElement;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }

    private Process getProcess() {
        return (Process)this.getResource().getContents().get(0);
    }

    private Resource getResource() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        return this.getEditingDomain().getResourceSet().getResource(resourceURI, true);
    }

    protected EditingDomain getEditingDomain() {
        return ((IEditingDomainProvider)this.getEditor()).getEditingDomain();
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.getEditingDomain().getCommandStack()).isSaveNeeded();
    }

    private static boolean canRead(Activity activity, User user) {
        for (Actor wfmActor : activity.getReaders()) {
            es.upv.dsic.issi.dplfw.om.Actor omActor = FullDocumentPage.getCredentialsManager().resolveActor(wfmActor.getUuid());
            if (!FullDocumentPage.getCredentialsManager().isIncluded((es.upv.dsic.issi.dplfw.om.Actor)user, omActor)) continue;
            return true;
        }
        return false;
    }

    private static boolean canEdit(Activity activity, User user) {
        for (Actor wfmActor : activity.getEditors()) {
            es.upv.dsic.issi.dplfw.om.Actor omActor = FullDocumentPage.getCredentialsManager().resolveActor(wfmActor.getUuid());
            if (!FullDocumentPage.getCredentialsManager().isIncluded((es.upv.dsic.issi.dplfw.om.Actor)user, omActor)) continue;
            return true;
        }
        return false;
    }

    protected static void cascadeAdapt(Composite composite, FormToolkit toolkit) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            toolkit.adapt(control, true, true);
            if (control instanceof Composite) {
                Composite childComposite = (Composite)control;
                FullDocumentPage.cascadeAdapt(childComposite, toolkit);
            }
            ++n2;
        }
    }

    public void refresh() {
        this.needsRefresh = true;
    }

    protected void handleActivate() {
        if (this.needsRefresh) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getManagedForm().getForm().getShell());
            try {
                dialog.run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.setTaskName("Contents have been modified! Updating custom editor...");
                        FullDocumentPage.this.topSection.dispose();
                        FullDocumentPage.this.sections.clear();
                        FullDocumentPage.this.topSection = FullDocumentPage.this.createSectionForActivity((Activity)FullDocumentPage.this.getProcess(), FullDocumentPage.this.getManagedForm().getToolkit(), FullDocumentPage.this.getManagedForm().getForm().getBody());
                        FullDocumentPage.this.getManagedForm().getForm().reflow(true);
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.needsRefresh = false;
        }
    }
}

