package es.upv.dsic.issi.dplfw.wfm.documenteditor.editor.util;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class JFaceUtil {

	public static final String CHECKED_KEY = "CHECKED";
	public static final String UNCHECKED_KEY = "UNCHECKED";
	public static final String CHANGEABLE_KEY = "CHANGEABLE";
	public static final String UNCHANGEABLE_KEY = "UNCHANGEABLE";

	private static Image makeShot(boolean type, boolean changeable) {
		
		Shell shell = new Shell(Display.getDefault().getActiveShell(), SWT.NO_TRIM);

		Button button = new Button(shell, SWT.CHECK);
		button.setSelection(type);
		button.setEnabled(changeable);

		// otherwise an image is located in a corner
		button.setLocation(1, 1);
		Point bsize = button.computeSize(SWT.DEFAULT, SWT.DEFAULT);

		// otherwise an image is stretched by width
		bsize.x = Math.max(bsize.x-1, bsize.y-1);
		bsize.y = Math.max(bsize.x-1, bsize.y-1);
		button.setSize(bsize);
		shell.setSize(bsize);

		shell.open();
		GC gc = new GC(shell);
		Image image = new Image(Display.getDefault(), bsize.x, bsize.y);
		gc.copyArea(image, 0, 0);
		gc.dispose();
		shell.close();

		return image;
	}

	public static Image getCheckboxImage(boolean value, boolean changeable) {
		
		String key = (value ? CHECKED_KEY : UNCHECKED_KEY) +
				(changeable ? CHANGEABLE_KEY : UNCHANGEABLE_KEY);
		
		if (JFaceResources.getImageRegistry().get(key) == null) {
			JFaceResources.getImageRegistry().put(key, makeShot(value, changeable));
		}
		
		return JFaceResources.getImageRegistry().getDescriptor(key).createImage();
	}

	
}
