package es.upv.dsic.issi.dplfw.wfm.documenteditor.editor;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.EditFormPage;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.PreviewFormPage;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.provider.InfoelementsItemProviderAdapterFactory;
import es.upv.dsic.issi.dplfw.om.Actor;
import es.upv.dsic.issi.dplfw.om.User;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.CredentialsManagerPlugin;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ICredentialsManager;
import es.upv.dsic.issi.dplfw.wfm.Activity;
import es.upv.dsic.issi.dplfw.wfm.FlowNode;
import es.upv.dsic.issi.dplfw.wfm.Process;
import es.upv.dsic.issi.dplfw.wfm.Subprocess;
import es.upv.dsic.issi.dplfw.wfm.WfmPackage;
import es.upv.dsic.issi.dplfw.wfm.documenteditor.WfmDocumentEditorPlugin;
import es.upv.dsic.issi.dplfw.wfm.documenteditor.editor.util.JFaceUtil;
import es.upv.dsic.issi.dplfw.wfm.provider.WfmItemProviderAdapterFactory;

public class UserTasksPage extends FormPage {

	private static final int MARGIN = 10;
	private static final int SPACING = 5;
	
	private ICredentialsManager credentialsManager;
	private User user;
	private Button viewButton;
	private Button editButton;
	private TreeViewer viewer;


	public UserTasksPage(DocumentFormEditor documentFormEditor, User user) {
		super(documentFormEditor,
				"es.upv.dsic.issi.dplfw.wfm.documenteditor.editor.UserTasksPage",
				"Tasks for " + user.getName());
		this.user = user;
	}

	@Override
	public void init(IEditorSite site, IEditorInput input) {
		super.init(site, input);
		this.credentialsManager = CredentialsManagerPlugin.getDefault().getManagersRegistry().getActiveManager();
	}
	
	public void refresh() {
		viewer.refresh();
	}
	
	@Override
	protected void createFormContent(IManagedForm managedForm) {
		
		FormToolkit toolkit = managedForm.getToolkit();

		ScrolledForm form = managedForm.getForm();
		form.setText(this.getTitle());
		
		FillLayout bodyLayout = new FillLayout(SWT.HORIZONTAL | SWT.VERTICAL);
		bodyLayout.marginHeight = MARGIN;
		bodyLayout.marginWidth = MARGIN;
		form.getBody().setLayout(bodyLayout);
		
		toolkit.decorateFormHeading(form.getForm());

		Section section = toolkit.createSection(form.getBody(), Section.TITLE_BAR);
		section.setText("User Tasks Summary");
		section.setLayout(bodyLayout);
		
		Composite topComposite = toolkit.createComposite(section);
		GridLayout gridLayout = new GridLayout(2, false);
		gridLayout.horizontalSpacing = MARGIN;
		topComposite.setLayout(gridLayout);

		Composite treeComposite = toolkit.createComposite(topComposite);
		TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
		treeComposite.setLayout(treeColumnLayout);
		treeComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		
		viewer = new TreeViewer(treeComposite, SWT.FULL_SELECTION | SWT.BORDER | SWT.SINGLE);
		createColumns(viewer);
		treeColumnLayout.setColumnData(viewer.getTree().getColumn(0), new ColumnWeightData(1));
		treeColumnLayout.setColumnData(viewer.getTree().getColumn(1), new ColumnWeightData(1));
		treeColumnLayout.setColumnData(viewer.getTree().getColumn(2), new ColumnPixelData(70));
		treeColumnLayout.setColumnData(viewer.getTree().getColumn(3), new ColumnPixelData(70));
		treeColumnLayout.setColumnData(viewer.getTree().getColumn(4), new ColumnPixelData(70));

		viewer.setContentProvider(new EditingActivitiesSetContentProvider());
		viewer.getTree().setHeaderVisible(true);
		viewer.getTree().setLinesVisible(true);
		viewer.setInput(getProcess());
		viewer.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				IStructuredSelection structuredSelection = (IStructuredSelection) event.getSelection();
				if (!structuredSelection.isEmpty()) {
					Activity activity = (Activity) structuredSelection.getFirstElement();
					if (activity.getInfoElement() != null) {
						editButton.setEnabled(canEdit(activity) && !activity.isAproved());
						viewButton.setEnabled(canRead(activity));
					}
				}
			}
		});
		ColumnViewerToolTipSupport.enableFor(viewer, ToolTip.NO_RECREATE);
		
		Composite buttonsComposite = toolkit.createComposite(topComposite);
		FillLayout buttonsLayout = new FillLayout(SWT.VERTICAL);
		buttonsLayout.spacing = SPACING;
		buttonsComposite.setLayout(buttonsLayout);
		buttonsComposite.setLayoutData(new GridData(SWT.FILL, SWT.BEGINNING, false, false));
		
		viewButton = toolkit.createButton(buttonsComposite, "Open in Viewer...", SWT.NONE);
		viewButton.setEnabled(false);
		editButton = toolkit.createButton(buttonsComposite, "Open in Editor...", SWT.NONE);
		editButton.setEnabled(false);
		
		viewButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = (IStructuredSelection) viewer.getSelection();
				Activity activity = (Activity) selection.getFirstElement();
				try {
					InfoElement infoElement = activity.getInfoElement();
					if (infoElement != null) {
						PreviewFormPage page = new PreviewFormPage(getEditor(), infoElement, activity.getName());
						getEditor().addPage(page);
						getEditor().setActivePage(page.getId());
						// HACK: Enable the close button in the new tab
						Composite composite = getPartControl().getParent();
						if (composite instanceof CTabFolder) {
						CTabFolder tabFolder = (CTabFolder) composite;
							tabFolder.getItem(tabFolder.getItemCount() - 1).setShowClose(true);
						}
					}
				} catch (PartInitException e1) {
					e1.printStackTrace();
				}
			}
		});
		
		editButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				IStructuredSelection selection = (IStructuredSelection) viewer.getSelection();
				Activity activity = (Activity) selection.getFirstElement();
				try {
					InfoElement infoElement = activity.getInfoElement();
					if (infoElement != null) {
						EditFormPage page = new EditFormPage(getEditor(), infoElement, activity.getName());
						getEditor().addPage(page);
						getEditor().setActivePage(page.getId());
						// HACK: Enable the close button in the new tab
						Composite composite = getPartControl().getParent();
						if (composite instanceof CTabFolder) {
						CTabFolder tabFolder = (CTabFolder) composite;
							tabFolder.getItem(tabFolder.getItemCount() - 1).setShowClose(true);
						}
					}
				} catch (PartInitException e1) {
					e1.printStackTrace();
				}
			}
		});
		
		section.setClient(topComposite);
	}


	// This will create the columns for the tree
	private void createColumns(TreeViewer viewer) {
		String[] titles = { "Activity", "Content", "Visible", "Editable", "Approved" };

		// Task Name
		TreeViewerColumn col0 = createTreeViewerColumn(viewer, titles[0]);
		col0.setLabelProvider(new ColumnLabelProvider() {
			AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider(new WfmItemProviderAdapterFactory());
			
			@Override
			public String getText(Object element) {
				return ((Activity) element).getName();
			}
			@Override
			public Image getImage(Object element) {
				return labelProvider.getImage(element);
			}
			@Override
			public String getToolTipText(Object element) {
				return ((Activity) element).getDescription();
			}
		});
		
		// Info Element title
		TreeViewerColumn col1 = createTreeViewerColumn(viewer, titles[1]);
		col1.setLabelProvider(new ColumnLabelProvider() {
			AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider(new InfoelementsItemProviderAdapterFactory());

			@Override
			public String getText(Object element) {
				return ((Activity) element).getName();
			}
			@Override
			public Image getImage(Object element) {
				return labelProvider.getImage(element);
			}
			@Override
			public String getToolTipText(Object element) {
				InfoElement infoElement = ((Activity) element).getInfoElement();
				if (infoElement != null)
					return infoElement.getDescription();
				else
					return null;
			}
		});
		
		// Is visible
		TreeViewerColumn col2 = createTreeViewerColumn(viewer, titles[2], SWT.CENTER);
		col2.setLabelProvider(new CheckboxCellLabelProvider() {
			@Override
			public Image getImage(Object element) {
				if (canRead((Activity) element))
					return WfmDocumentEditorPlugin.getPlugin().getImageRegistry().get(WfmDocumentEditorPlugin.IMG_OBJ16_BULLETGREEN);
				else
					return WfmDocumentEditorPlugin.getPlugin().getImageRegistry().get(WfmDocumentEditorPlugin.IMG_OBJ16_BULLETRED);
			}
		});
		
		// Is editable
		TreeViewerColumn col3 = createTreeViewerColumn(viewer, titles[3], SWT.CENTER);
		col3.setLabelProvider(new CheckboxCellLabelProvider() {
			@Override
			public Image getImage(Object element) {
				if (canEdit((Activity) element)) 
					return WfmDocumentEditorPlugin.getPlugin().getImageRegistry().get(WfmDocumentEditorPlugin.IMG_OBJ16_BULLETGREEN);
				else
					return WfmDocumentEditorPlugin.getPlugin().getImageRegistry().get(WfmDocumentEditorPlugin.IMG_OBJ16_BULLETRED);
			}
		});
		
		// Is approved
		TreeViewerColumn col4 = createTreeViewerColumn(viewer, titles[4], SWT.CENTER);
		col4.setLabelProvider(new CheckboxCellLabelProvider() {
			@Override
			public Image getImage(Object element) {
				return JFaceUtil.getCheckboxImage(
						((Activity) element).isAproved(),
						canApprove((Activity) element));
			}
		});
		col4.setEditingSupport(new ApprovingEditingSupport(viewer));
		col4.getViewer().addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				((DocumentFormEditor) getEditor()).refreshDocumentPage();
			}
		});
	}
	
	private TreeViewerColumn createTreeViewerColumn(TreeViewer viewer, String title, int style) {
		final TreeViewerColumn viewerColumn = new TreeViewerColumn(viewer, SWT.NONE | style);
		final TreeColumn column = viewerColumn.getColumn();
		column.setText(title);
		column.setResizable(true);
		column.setMoveable(true);
		return viewerColumn;
		
	}

	private TreeViewerColumn createTreeViewerColumn(TreeViewer viewer, String title) {
		return createTreeViewerColumn(viewer, title, SWT.NONE);

	}
	
	protected EditingDomain getEditingDomain() {
		return ((IEditingDomainProvider) getEditor()).getEditingDomain();
	}
	
	@Override
	public boolean isDirty() {
		return ((BasicCommandStack) getEditingDomain().getCommandStack()).isSaveNeeded();
	}
	
	private EObject getProcess() {
		return getResource().getContents().get(0);
	}

	private Resource getResource() {
		URI resourceURI = EditUIUtil.getURI(getEditorInput());
		return getEditingDomain().getResourceSet().getResource(resourceURI, true);
	}

	private boolean isResponsible(Activity activity) {
		if (activity.getResponsible() != null) {
			Actor activityResponsible = credentialsManager.resolveActor(activity.getResponsible().getUuid());
			return credentialsManager.isIncluded(user, activityResponsible);
		}
		return false;
	}
	
	private boolean canRead(Activity activity) {
		for (es.upv.dsic.issi.dplfw.wfm.Actor wfmActor : activity.getReaders()) {
			Actor omActor = credentialsManager.resolveActor(wfmActor.getUuid());
			if (credentialsManager.isIncluded(user, omActor))
				return true;
		}
		return false;
	}

	private boolean canEdit(Activity activity) {
		for (es.upv.dsic.issi.dplfw.wfm.Actor wfmActor : activity.getEditors()) {
			Actor omActor = credentialsManager.resolveActor(wfmActor.getUuid());
			if (credentialsManager.isIncluded(user, omActor))
				return true;
		}
		return false;
	}
	
	private boolean canApprove(Activity activity) {
		return isResponsible(activity);
	}
	
	private class EditingActivitiesSetContentProvider implements ITreeContentProvider {

		@Override
		public void dispose() {
		}

		@Override
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}

		@Override
		public Object[] getElements(Object inputElement) {
			Process process = (Process) inputElement;
			List<Activity> activities = new ArrayList<Activity>();
			for (FlowNode node : process.getNodes()) {
				if (node instanceof Activity)
					activities.add((Activity) node);
			}
			return activities.toArray();
		}

		@Override
		public Object[] getChildren(Object parentElement) {
			return getElements(parentElement);
		}

		@Override
		public Object getParent(Object element) {
			return null;
		}

		@Override
		public boolean hasChildren(Object element) {
			if (element instanceof Subprocess) 
				return true;
			else
				return false;
		}
	}
	
	private class ApprovingEditingSupport extends EditingSupport {
		
		TreeViewer viewer;
		
		public ApprovingEditingSupport(TreeViewer viewer) {
			super(viewer);
			this.viewer = viewer;
		}

		@Override
		protected void setValue(Object element, Object value) {
			Activity activity = (Activity) element;
			Command command = SetCommand.create(getEditingDomain(), activity, WfmPackage.Literals.ACTIVITY__APROVED, value);
			if (command.canExecute()) {
				getEditingDomain().getCommandStack().execute(command);
				viewer.update(element, null);
			}
		}
		
		@Override
		protected Object getValue(Object element) {
			return ((Activity)element).isAproved();
		}
		
		@Override
		protected CellEditor getCellEditor(Object element) {
			CheckboxCellEditor checkboxCellEditor = new CheckboxCellEditor(viewer.getTree());
			checkboxCellEditor.setValue(getValue(element));
			return checkboxCellEditor;
		}
		
		@Override
		protected boolean canEdit(Object element) {
			return canApprove((Activity) element);
		}

	}

	abstract class CheckboxCellLabelProvider extends StyledCellLabelProvider {
		@Override
		protected void paint(Event event, Object element) {
				Image tmpImage = getImage(element);
				int x = event.x;
				int y = event.y;
				int height = event.height;
				int width = ((Tree)event.widget).getColumn(event.index).getWidth();
				
				GC gc = event.gc;
				int tmpX = (width - tmpImage.getBounds().width) / 2;
				int tmpY = (height - tmpImage.getBounds().height) / 2;
				
				tmpX = Math.max(tmpX, 0);
				tmpY = Math.max(tmpY, 0);
						
	            gc.drawImage(tmpImage, tmpX + x, tmpY + y);

		}
		public abstract Image getImage(Object element);
	}
}
