package es.upv.dsic.issi.dplfw.wfm.documenteditor.editor;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.IESingleEditorPlugin;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEDisplayViewer;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.IIEEditViewer;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.common.impl.InfoElementPropertyModifier;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.om.Actor;
import es.upv.dsic.issi.dplfw.om.User;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.CredentialsManagerPlugin;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ICredentialsManager;
import es.upv.dsic.issi.dplfw.wfm.Activity;
import es.upv.dsic.issi.dplfw.wfm.FlowNode;
import es.upv.dsic.issi.dplfw.wfm.Process;
import es.upv.dsic.issi.dplfw.wfm.documenteditor.WfmDocumentEditorPlugin;

public class FullDocumentPage extends FormPage {

	private static final int MARGIN_WIDTH = 10;
	private static final String TITLE_BACKGROUND_COLOR = "TITLE_BACKGROUND_COLOR";
	private User user;
	private Section topSection;

	private boolean needsRefresh;
	
	private List<Section> sections = new ArrayList<Section>();
	
	public FullDocumentPage(DocumentFormEditor documentFormEditor, User user) {
		super(documentFormEditor,
				"es.upv.dsic.issi.dplfw.wfm.documenteditor.editor.FullDocumentPage",
				"Document");
		this.user = user;
	}
	
	@Override
	public void init(IEditorSite site, IEditorInput input) {
		super.init(site, input);
	}

	protected static ICredentialsManager getCredentialsManager() {
		return CredentialsManagerPlugin.getDefault().getManagersRegistry().getActiveManager();
	}

	@Override
	protected void createFormContent(IManagedForm managedForm) {

		FormToolkit toolkit = managedForm.getToolkit();
		Color bgColor = toolkit.getColors().getBackground();
				
		JFaceResources.getColorRegistry().put(TITLE_BACKGROUND_COLOR, 
				new RGB(bgColor.getRGB().getHSB()[0],
						bgColor.getRGB().getHSB()[1],
						(float) (bgColor.getRGB().getHSB()[2] * 0.9)));
		
		ScrolledForm form = managedForm.getForm();
		form.setText("Document");
		TableWrapLayout layout = new TableWrapLayout();
		layout.leftMargin = MARGIN_WIDTH;
		layout.rightMargin = MARGIN_WIDTH;
		layout.makeColumnsEqualWidth = true;
		form.getBody().setLayout(layout);
		form.setDelayedReflow(true);
		
		toolkit.decorateFormHeading(form.getForm());
		
		ProgressMonitorDialog dialog = new ProgressMonitorDialog(managedForm.getForm().getShell());
		try {
			dialog.run(false, false, new IRunnableWithProgress() {
				
				@Override
				public void run(IProgressMonitor monitor) throws InvocationTargetException,
						InterruptedException {
					monitor.setTaskName("Creating custom editor...");
					sections.clear();
					topSection = createSectionForActivity(getProcess(), getManagedForm().getToolkit(), getManagedForm().getForm().getBody());
					getManagedForm().getForm().reflow(true);
				}
			});
		} catch (InvocationTargetException e) {
		} catch (InterruptedException e) {
		}
		
		createToolBarActions(managedForm);
	}
	
	
	/**
	 * Creates the actions of the form 
	 * @param managedForm
	 */
	protected void createToolBarActions(IManagedForm managedForm) {
		final ScrolledForm form = managedForm.getForm();

		Action collapseAction = new Action("Expand", Action.AS_PUSH_BUTTON) { //$NON-NLS-1$
			public void run() {
				ProgressMonitorDialog dialog = new ProgressMonitorDialog(getManagedForm().getForm().getShell());
				try {
					dialog.run(true, true, new IRunnableWithProgress() {
						@Override
						public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
							monitor.setTaskName("Expanding document contents...");
							for (final Section section : sections) {
								if (!monitor.isCanceled()) {
									getSite().getShell().getDisplay().syncExec(new Runnable() {
										public void run() {
											if (!section.isDisposed())
												section.setExpanded(true);
										}
									});
								} else {
									break;
								}
							}
							getSite().getShell().getDisplay().syncExec(new Runnable() {
								public void run() {
									if (!getManagedForm().getForm().isDisposed()) {
										getManagedForm().getForm().reflow(true);
									}
								}
							});
						}
					});
				} catch (InvocationTargetException e) {
				} catch (InterruptedException e) {
				}
			}
		};
		
		collapseAction.setToolTipText("Expand All"); //$NON-NLS-1$
		collapseAction.setImageDescriptor(WfmDocumentEditorPlugin.getPlugin().getImageRegistry().getDescriptor(WfmDocumentEditorPlugin.IMG_ETOOL16_EXPAND));
		
		Action expandAction = new Action("Collapse", Action.AS_PUSH_BUTTON) { //$NON-NLS-1$
			public void run() {
				ProgressMonitorDialog dialog = new ProgressMonitorDialog(getManagedForm().getForm().getShell());
				try {
					dialog.run(true, true, new IRunnableWithProgress() {
						@Override
						public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
							monitor.setTaskName("Collapsing document contents...");
							for (final Section section : sections) {
								if (!monitor.isCanceled()) {
									getSite().getShell().getDisplay().syncExec(new Runnable() {
										public void run() {
											if (!section.isDisposed())
												section.setExpanded(false);
										}
									});
								} else {
									break;
								}
							}
							getSite().getShell().getDisplay().syncExec(new Runnable() {
								public void run() {
									if (!getManagedForm().getForm().isDisposed()) {
										getManagedForm().getForm().reflow(true);
									}
								}
							});						}
					});
				} catch (InvocationTargetException e) {
				} catch (InterruptedException e) {
				}
			}
		};
		
		expandAction.setToolTipText("Collapse All"); //$NON-NLS-1$
		expandAction.setImageDescriptor(WfmDocumentEditorPlugin.getPlugin().getImageRegistry().getDescriptor(WfmDocumentEditorPlugin.IMG_ETOOL16_COLLAPSE));
		form.getToolBarManager().add(collapseAction);
		form.getToolBarManager().add(expandAction);
		form.getToolBarManager().update(true);
	}


	
	protected Section createSectionForActivity(Activity activity, FormToolkit toolkit, Composite parent) {
		Section section = toolkit.createSection(parent, 
//				Section.CLIENT_INDENT |
				Section.TREE_NODE /* | Section.EXPANDED */);
		section.setBackground(JFaceResources.getColorRegistry().get(TITLE_BACKGROUND_COLOR));
		
		section.setText(activity.getName() != null ? activity.getName() : "");
		sections.add(section);
		
		
		Composite composite = toolkit.createComposite(section, SWT.NONE);
		composite.setBackground(toolkit.getColors().getBackground());

		TableWrapLayout layout = new TableWrapLayout();
//		layout.leftMargin = 0;
		layout.rightMargin = 0;
//		layout.topMargin = 0;
//		layout.bottomMargin = 0;
//		layout.verticalSpacing = 0;
		composite.setLayout(layout);
		TableWrapData layoutData = new TableWrapData(TableWrapData.FILL_GRAB);
		composite.setLayoutData(layoutData);
		
		if (activity.getInfoElement() != null
				&& (canRead(activity, user) || canEdit(activity, user))) {
			try {
				IIEDisplayViewer viewer = createDisseminatorForInfoElement(activity, toolkit, composite);
				viewer.getControl().setLayoutData(layoutData);
				
				// This listener forces the form to reflow when the child viewer is resized
				viewer.getControl().addListener(SWT.Resize, new Listener() {
					Runnable reflowRunnable = new Runnable() {
						@Override
						public void run() {
							if (!getManagedForm().getForm().isDisposed()) {
								getManagedForm().getForm().reflow(true);	
							}
						}
					};
					
					@Override
					public void handleEvent(Event event) {
						Display.getDefault().timerExec(50, reflowRunnable);
					}
				});
			} catch (ClassNotFoundException e) {
				e.printStackTrace();
			}
		}
		
		if (activity instanceof Process) {
			for (FlowNode node : ((Process) activity).getNodes()) {
				if (node instanceof Activity) {
					createSectionForActivity((Activity) node, toolkit, composite);
				}
			}
		}
		
		section.setLayoutData(new TableWrapData(TableWrapData.FILL_GRAB, TableWrapData.FILL_GRAB));
		section.setClient(composite);

		return section;
	}

		
	protected IIEDisplayViewer createDisseminatorForInfoElement(Activity activity, FormToolkit toolkit, Composite parent) throws ClassNotFoundException {
		IIEDisplayViewer ieViewer = null;
		try {
			if (activity.getInfoElement() != null) {
				InfoElement infoElement = activity.getInfoElement();
				IConfigurationElement configElement = getConfigurationElementForIE(infoElement);
				
				// Hack to allow arguments in the IEDisplayViewer constructor
				// (createExecutableExtension does not allow arguments) 
				String viewerClassName;
				
				if (canEdit(activity, user) && !activity.isAproved()) {
					viewerClassName = configElement.getAttribute(IESingleEditorPlugin.IEEDIT_EXT_POINT_EDIT_VIEWER);
				} else {
					viewerClassName = configElement.getAttribute(IESingleEditorPlugin.IEEDIT_EXT_POINT_DISPLAY_VIEWER);
				}
				
				if (viewerClassName == null) {
					throw new ClassNotFoundException();
				}
				Class<?> viewerClass = Class.forName(viewerClassName);
				Constructor<?> viewerConstructor = viewerClass.getConstructor(Composite.class);
				ieViewer = (IIEDisplayViewer) viewerConstructor.newInstance(parent);
				// EOH (End Of Hack)
				ieViewer.getControl().setBackground(toolkit.getColors().getBackground());
				
				IContentProvider contentProvider = (IContentProvider) configElement
						.createExecutableExtension(IESingleEditorPlugin.IEEDIT_EXT_POINT_CONTENT_PROVIDER);
				IBaseLabelProvider labelProvider = (IBaseLabelProvider) configElement
						.createExecutableExtension(IESingleEditorPlugin.IEEDIT_EXT_POINT_LABEL_PROVIDER);
				
				ieViewer.setContentProvider(contentProvider);
				ieViewer.setLabelProvider(labelProvider);
				
				cascadeAdapt(parent, toolkit);
				
				if (ieViewer instanceof IIEEditViewer) {
					((IIEEditViewer) ieViewer).setPropertyModifier(new InfoElementPropertyModifier(getEditingDomain()));
				}
				
				ieViewer.setInput(infoElement);
			}
		} catch (CoreException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		} catch (NoSuchMethodException e) {
			e.printStackTrace();
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
		} catch (InstantiationException e) {
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		}
		return ieViewer;
	}

	protected static IConfigurationElement getConfigurationElementForIE(InfoElement infoElement) {
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		IConfigurationElement[] extensions = registry.getConfigurationElementsFor(
				IESingleEditorPlugin.IEEDIT_EXT_POINT_ID);
		
		for (IConfigurationElement configElement : extensions) {
				String infoElementType = configElement.getAttribute(IESingleEditorPlugin.IEEDIT_EXT_POINT_IE);
				try {
					Class<?> elementClass = Class.forName(infoElementType);
					if (elementClass.isInstance(infoElement))
						return configElement;
				} catch (ClassNotFoundException e) {
				}
		}
		return null;
	}
	
	private Process getProcess() {
		return (Process) getResource().getContents().get(0);
	}

	private Resource getResource() {
		URI resourceURI = EditUIUtil.getURI(getEditorInput());
		return getEditingDomain().getResourceSet().getResource(resourceURI, true);
	}
	
	protected EditingDomain getEditingDomain() {
		return ((IEditingDomainProvider) getEditor()).getEditingDomain();
	}
	
	@Override
	public boolean isDirty() {
		return ((BasicCommandStack) getEditingDomain().getCommandStack()).isSaveNeeded();
	}
	
	private static boolean canRead(Activity activity, User user) {
		for (es.upv.dsic.issi.dplfw.wfm.Actor wfmActor : activity.getReaders()) {
			Actor omActor = getCredentialsManager().resolveActor(wfmActor.getUuid());
			if (getCredentialsManager().isIncluded(user, omActor))
				return true;
		}
		return false;
	}

	private static boolean canEdit(Activity activity, User user) {
		for (es.upv.dsic.issi.dplfw.wfm.Actor wfmActor : activity.getEditors()) {
			Actor omActor = getCredentialsManager().resolveActor(wfmActor.getUuid());
			if (getCredentialsManager().isIncluded(user, omActor))
				return true;
		}
		return false;
	}
	protected static void cascadeAdapt(Composite composite, FormToolkit toolkit) {
		for (Control control : composite.getChildren()) {
			toolkit.adapt(control, true, true);
			if (control instanceof Composite) {
				Composite childComposite = (Composite) control;
				cascadeAdapt(childComposite, toolkit);
			}
		}
	}
	
	/** 
	 * Marks the page as needed to be refreshed
	 * To actually perform the refresh the handleActivate method should be called 
	 */
	public void refresh() {
		this.needsRefresh = true;
	}
	
	/**
	 * This method should be externally called by the parent editor, which controls
	 * when it is activated in the pageChange(int index) method 
	 */
	protected void handleActivate() {
		if (needsRefresh) {
			ProgressMonitorDialog dialog = new ProgressMonitorDialog(getManagedForm().getForm().getShell());
			try {
				dialog.run(false, false, new IRunnableWithProgress() {
					
					@Override
					public void run(IProgressMonitor monitor) throws InvocationTargetException,
							InterruptedException {
						monitor.setTaskName("Contents have been modified! Updating custom editor...");
						topSection.dispose();
						sections.clear();
						topSection = createSectionForActivity(getProcess(), getManagedForm().getToolkit(), getManagedForm().getForm().getBody());
						getManagedForm().getForm().reflow(true);
					}
				});
			} catch (InvocationTargetException e) {
			} catch (InterruptedException e) {
			}
			needsRefresh = false;
		}
	}
}
