package es.upv.dsic.issi.dplfw.wfm.documenteditor.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.part.FileEditorInput;

import es.upv.dsic.issi.dplfw.om.User;

public class FileEditorInputWithUser extends FileEditorInput {
	
	private User user;
	
	public FileEditorInputWithUser(IFile file, User user) {
		super(file);
		this.user = user;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (!(obj instanceof FileEditorInputWithUser)) {
			return false;
		}
		FileEditorInputWithUser other = (FileEditorInputWithUser) obj;
		return getFile().equals(other.getFile()) && getUser() == other.getUser();
	}
	
	@Override
	public int hashCode() {
		int hash = super.hashCode();
		hash = hash * 31 + getUser().hashCode();
		return hash;
	}
	
	public User getUser() {
		return user;
	}
	
	@Override
	public IPersistableElement getPersistable() {
		return null;
	}
	
};