package es.upv.dsic.issi.dplfw.wfm.documenteditor.editor;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

import es.upv.dsic.issi.dplfw.om.User;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.CredentialsManagerPlugin;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.exceptions.CancelledLoginException;
import es.upv.dsic.issi.dplfw.om.credentialsmanager.ui.dialogs.LoginDialog;

public class EditorLauncher implements IEditorLauncher {

	@Override
	public void open(IPath file) {
		IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		IWorkbenchPage page = window.getActivePage();
		try {
			
			User user = CredentialsManagerPlugin.getDefault().requestLoggedUser(new LoginDialog(window.getShell()));
			FileEditorInputWithUser input = new FileEditorInputWithUser(
					ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(file), user);
			page.openEditor(input, "es.upv.dsic.issi.dplfw.wfm.documenteditor.editor.internal");
		} catch (PartInitException e) {
			e.printStackTrace();
		} catch (CancelledLoginException e) {
		}
	}
	
}
