/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.wfm.diagram.part;

import es.upv.dsic.issi.dplfw.wfm.Process;
import es.upv.dsic.issi.dplfw.wfm.WfmPackage;
import es.upv.dsic.issi.dplfw.wfm.diagram.part.WfmDiagramEditorPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class WfmVisualIDRegistry {
    private static final String DEBUG_KEY = "es.upv.dsic.issi.dplfw.wfm.diagram/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Wfm".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return WfmVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                WfmDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (WfmPackage.eINSTANCE.getProcess().isSuperTypeOf(domainElement.eClass()) && WfmVisualIDRegistry.isDiagram((Process)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = WfmVisualIDRegistry.getModelID(containerView);
        if (!"Wfm".equals(containerModelID)) {
            return -1;
        }
        if ("Wfm".equals(containerModelID)) {
            containerVisualID = WfmVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (WfmPackage.eINSTANCE.getSubprocess().isSuperTypeOf(domainElement.eClass())) {
                    return 2007;
                }
                if (WfmPackage.eINSTANCE.getTask().isSuperTypeOf(domainElement.eClass())) {
                    return 2008;
                }
                if (WfmPackage.eINSTANCE.getStart().isSuperTypeOf(domainElement.eClass())) {
                    return 2005;
                }
                if (WfmPackage.eINSTANCE.getEnd().isSuperTypeOf(domainElement.eClass())) {
                    return 2006;
                }
                if (!WfmPackage.eINSTANCE.getGateway().isSuperTypeOf(domainElement.eClass())) break;
                return 2003;
            }
            case 7003: {
                if (WfmPackage.eINSTANCE.getSubprocess().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (WfmPackage.eINSTANCE.getStart().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (WfmPackage.eINSTANCE.getEnd().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (WfmPackage.eINSTANCE.getGateway().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (!WfmPackage.eINSTANCE.getTask().isSuperTypeOf(domainElement.eClass())) break;
                return 3008;
            }
            case 7005: {
                if (!WfmPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) break;
                return 3010;
            }
            case 7007: {
                if (!WfmPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) break;
                return 3009;
            }
            case 7008: {
                if (!WfmPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) break;
                return 3011;
            }
            case 7004: {
                if (WfmPackage.eINSTANCE.getSubprocess().isSuperTypeOf(domainElement.eClass())) {
                    return 3007;
                }
                if (WfmPackage.eINSTANCE.getStart().isSuperTypeOf(domainElement.eClass())) {
                    return 3005;
                }
                if (WfmPackage.eINSTANCE.getEnd().isSuperTypeOf(domainElement.eClass())) {
                    return 3006;
                }
                if (WfmPackage.eINSTANCE.getGateway().isSuperTypeOf(domainElement.eClass())) {
                    return 3004;
                }
                if (!WfmPackage.eINSTANCE.getTask().isSuperTypeOf(domainElement.eClass())) break;
                return 3008;
            }
            case 7006: {
                if (!WfmPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) break;
                return 3010;
            }
            case 7009: {
                if (!WfmPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) break;
                return 3009;
            }
            case 7010: {
                if (!WfmPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) break;
                return 3011;
            }
            case 7011: {
                if (!WfmPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) break;
                return 3010;
            }
            case 7012: {
                if (!WfmPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) break;
                return 3009;
            }
            case 7013: {
                if (!WfmPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) break;
                return 3011;
            }
            case 7014: {
                if (!WfmPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) break;
                return 3010;
            }
            case 7015: {
                if (!WfmPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) break;
                return 3009;
            }
            case 7016: {
                if (!WfmPackage.eINSTANCE.getActor().isSuperTypeOf(domainElement.eClass())) break;
                return 3011;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = WfmVisualIDRegistry.getModelID(containerView);
        if (!"Wfm".equals(containerModelID)) {
            return false;
        }
        if ("Wfm".equals(containerModelID)) {
            containerVisualID = WfmVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2007 == nodeVisualID) {
                    return true;
                }
                if (2008 == nodeVisualID) {
                    return true;
                }
                if (2005 == nodeVisualID) {
                    return true;
                }
                if (2006 == nodeVisualID) {
                    return true;
                }
                if (2003 != nodeVisualID) break;
                return true;
            }
            case 2007: {
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (7003 == nodeVisualID) {
                    return true;
                }
                if (7005 == nodeVisualID) {
                    return true;
                }
                if (7007 == nodeVisualID) {
                    return true;
                }
                if (7008 != nodeVisualID) break;
                return true;
            }
            case 2008: {
                if (5005 == nodeVisualID) {
                    return true;
                }
                if (7014 == nodeVisualID) {
                    return true;
                }
                if (7015 == nodeVisualID) {
                    return true;
                }
                if (7016 != nodeVisualID) break;
                return true;
            }
            case 3007: {
                if (5003 == nodeVisualID) {
                    return true;
                }
                if (7004 == nodeVisualID) {
                    return true;
                }
                if (7006 == nodeVisualID) {
                    return true;
                }
                if (7009 == nodeVisualID) {
                    return true;
                }
                if (7010 != nodeVisualID) break;
                return true;
            }
            case 3008: {
                if (5006 == nodeVisualID) {
                    return true;
                }
                if (7011 == nodeVisualID) {
                    return true;
                }
                if (7012 == nodeVisualID) {
                    return true;
                }
                if (7013 != nodeVisualID) break;
                return true;
            }
            case 3010: {
                if (5009 != nodeVisualID) break;
                return true;
            }
            case 3009: {
                if (5008 != nodeVisualID) break;
                return true;
            }
            case 3011: {
                if (5010 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3008 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3010 != nodeVisualID) break;
                return true;
            }
            case 7007: {
                if (3009 != nodeVisualID) break;
                return true;
            }
            case 7008: {
                if (3011 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3007 == nodeVisualID) {
                    return true;
                }
                if (3005 == nodeVisualID) {
                    return true;
                }
                if (3006 == nodeVisualID) {
                    return true;
                }
                if (3004 == nodeVisualID) {
                    return true;
                }
                if (3008 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3010 != nodeVisualID) break;
                return true;
            }
            case 7009: {
                if (3009 != nodeVisualID) break;
                return true;
            }
            case 7010: {
                if (3011 != nodeVisualID) break;
                return true;
            }
            case 7011: {
                if (3010 != nodeVisualID) break;
                return true;
            }
            case 7012: {
                if (3009 != nodeVisualID) break;
                return true;
            }
            case 7013: {
                if (3011 != nodeVisualID) break;
                return true;
            }
            case 7014: {
                if (3010 != nodeVisualID) break;
                return true;
            }
            case 7015: {
                if (3009 != nodeVisualID) break;
                return true;
            }
            case 7016: {
                if (3011 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        return -1;
    }

    private static boolean isDiagram(Process element) {
        return true;
    }
}

