/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.wfm.diagram.part;

import es.upv.dsic.issi.dplfw.wfm.diagram.part.Messages;
import es.upv.dsic.issi.dplfw.wfm.diagram.part.WfmCreationWizardPage;
import es.upv.dsic.issi.dplfw.wfm.diagram.part.WfmDiagramEditorPlugin;
import es.upv.dsic.issi.dplfw.wfm.diagram.part.WfmDiagramEditorUtil;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class WfmCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected WfmCreationWizardPage diagramModelFilePage;
    protected WfmCreationWizardPage domainModelFilePage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Messages.WfmCreationWizardTitle);
        this.setDefaultPageImageDescriptor(WfmDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewWfmWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.diagramModelFilePage = new WfmCreationWizardPage("DiagramModelFile", this.getSelection(), "wfm_diagram");
        this.diagramModelFilePage.setTitle(Messages.WfmCreationWizard_DiagramModelFilePageTitle);
        this.diagramModelFilePage.setDescription(Messages.WfmCreationWizard_DiagramModelFilePageDescription);
        this.addPage((IWizardPage)this.diagramModelFilePage);
        this.domainModelFilePage = new WfmCreationWizardPage("DomainModelFile", this.getSelection(), "wfm"){

            public void setVisible(boolean visible) {
                if (visible) {
                    String fileName = WfmCreationWizard.this.diagramModelFilePage.getFileName();
                    fileName = fileName.substring(0, fileName.length() - ".wfm_diagram".length());
                    this.setFileName(WfmDiagramEditorUtil.getUniqueFileName(this.getContainerFullPath(), fileName, "wfm"));
                }
                super.setVisible(visible);
            }
        };
        this.domainModelFilePage.setTitle(Messages.WfmCreationWizard_DomainModelFilePageTitle);
        this.domainModelFilePage.setDescription(Messages.WfmCreationWizard_DomainModelFilePageDescription);
        this.addPage((IWizardPage)this.domainModelFilePage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                WfmCreationWizard.this.diagram = WfmDiagramEditorUtil.createDiagram(WfmCreationWizard.this.diagramModelFilePage.getURI(), WfmCreationWizard.this.domainModelFilePage.getURI(), monitor);
                if (WfmCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && WfmCreationWizard.this.diagram != null) {
                    try {
                        WfmDiagramEditorUtil.openDiagram(WfmCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)WfmCreationWizard.this.getContainer().getShell(), (String)Messages.WfmCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.WfmCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                WfmDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }
}

