/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.wfm.diagram.navigator;

import es.upv.dsic.issi.dplfw.wfm.diagram.navigator.WfmAbstractNavigatorItem;
import es.upv.dsic.issi.dplfw.wfm.diagram.navigator.WfmNavigatorGroup;
import es.upv.dsic.issi.dplfw.wfm.diagram.navigator.WfmNavigatorItem;
import es.upv.dsic.issi.dplfw.wfm.diagram.part.Messages;
import es.upv.dsic.issi.dplfw.wfm.diagram.part.WfmVisualIDRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class WfmNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public WfmNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            @Override
            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            @Override
            public void run() {
                if (WfmNavigatorContentProvider.this.myViewer != null) {
                    WfmNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                WfmNavigatorContentProvider.this.unloadAllResources();
                WfmNavigatorContentProvider.this.asyncRefresh();
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                WfmNavigatorContentProvider.this.unloadAllResources();
                WfmNavigatorContentProvider.this.asyncRefresh();
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                WfmNavigatorContentProvider.this.unloadAllResources();
                WfmNavigatorContentProvider.this.asyncRefresh();
                return true;
            }
        });
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        this.myViewer = null;
        this.unloadAllResources();
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    void unloadAllResources() {
        for (Resource nextResource : this.myEditingDomain.getResourceSet().getResources()) {
            nextResource.unload();
        }
    }

    void asyncRefresh() {
        if (this.myViewer != null && !this.myViewer.getControl().isDisposed()) {
            this.myViewer.getControl().getDisplay().asyncExec(this.myViewerRefreshRunnable);
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
            ArrayList result = new ArrayList();
            ArrayList<View> topViews = new ArrayList<View>(resource.getContents().size());
            for (EObject o : resource.getContents()) {
                if (!(o instanceof View)) continue;
                topViews.add((View)o);
            }
            return result.toArray();
        }
        if (parentElement instanceof WfmNavigatorGroup) {
            WfmNavigatorGroup group = (WfmNavigatorGroup)((Object)parentElement);
            return group.getChildren();
        }
        if (parentElement instanceof WfmNavigatorItem) {
            WfmNavigatorItem navigatorItem = (WfmNavigatorItem)((Object)parentElement);
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        switch (WfmVisualIDRegistry.getVisualID(view)) {
            case 2006: {
                LinkedList<WfmNavigatorGroup> result = new LinkedList<WfmNavigatorGroup>();
                Node sv = (Node)view;
                WfmNavigatorGroup incominglinks = new WfmNavigatorGroup(Messages.NavigatorGroupName_End_2006_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(4003));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 2005: {
                LinkedList<WfmNavigatorGroup> result = new LinkedList<WfmNavigatorGroup>();
                Node sv = (Node)view;
                WfmNavigatorGroup outgoinglinks = new WfmNavigatorGroup(Messages.NavigatorGroupName_Start_2005_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(4003));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3006: {
                LinkedList<WfmNavigatorGroup> result = new LinkedList<WfmNavigatorGroup>();
                Node sv = (Node)view;
                WfmNavigatorGroup incominglinks = new WfmNavigatorGroup(Messages.NavigatorGroupName_End_3006_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(4003));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 3005: {
                LinkedList<WfmNavigatorGroup> result = new LinkedList<WfmNavigatorGroup>();
                Node sv = (Node)view;
                WfmNavigatorGroup outgoinglinks = new WfmNavigatorGroup(Messages.NavigatorGroupName_Start_3005_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(4003));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 4003: {
                LinkedList<WfmNavigatorGroup> result = new LinkedList<WfmNavigatorGroup>();
                Edge sv = (Edge)view;
                WfmNavigatorGroup target = new WfmNavigatorGroup(Messages.NavigatorGroupName_SourceTo_4003_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                WfmNavigatorGroup source = new WfmNavigatorGroup(Messages.NavigatorGroupName_SourceTo_4003_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getLinksTargetByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(2007));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(2008));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(2006));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(2003));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(3007));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(3006));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(3004));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(3008));
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(2007));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(2008));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(2005));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(2003));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(3007));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(3005));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(3004));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(3008));
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 3008: {
                LinkedList<WfmAbstractNavigatorItem> result = new LinkedList<WfmAbstractNavigatorItem>();
                Node sv = (Node)view;
                WfmNavigatorGroup incominglinks = new WfmNavigatorGroup(Messages.NavigatorGroupName_Task_3008_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                WfmNavigatorGroup outgoinglinks = new WfmNavigatorGroup(Messages.NavigatorGroupName_Task_3008_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7011));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3010));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7012));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3009));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7013));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3011));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(4003));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(4003));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3007: {
                LinkedList<WfmAbstractNavigatorItem> result = new LinkedList<WfmAbstractNavigatorItem>();
                Node sv = (Node)view;
                WfmNavigatorGroup incominglinks = new WfmNavigatorGroup(Messages.NavigatorGroupName_Subprocess_3007_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                WfmNavigatorGroup outgoinglinks = new WfmNavigatorGroup(Messages.NavigatorGroupName_Subprocess_3007_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7004));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3007));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7004));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3005));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7004));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3006));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7004));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3004));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7004));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3008));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7006));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3010));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7009));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3009));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7010));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3011));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(4003));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(4003));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3004: {
                LinkedList<WfmNavigatorGroup> result = new LinkedList<WfmNavigatorGroup>();
                Node sv = (Node)view;
                WfmNavigatorGroup incominglinks = new WfmNavigatorGroup(Messages.NavigatorGroupName_Gateway_3004_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                WfmNavigatorGroup outgoinglinks = new WfmNavigatorGroup(Messages.NavigatorGroupName_Gateway_3004_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(4003));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(4003));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2003: {
                LinkedList<WfmNavigatorGroup> result = new LinkedList<WfmNavigatorGroup>();
                Node sv = (Node)view;
                WfmNavigatorGroup incominglinks = new WfmNavigatorGroup(Messages.NavigatorGroupName_Gateway_2003_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                WfmNavigatorGroup outgoinglinks = new WfmNavigatorGroup(Messages.NavigatorGroupName_Gateway_2003_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(4003));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(4003));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2007: {
                LinkedList<WfmAbstractNavigatorItem> result = new LinkedList<WfmAbstractNavigatorItem>();
                Node sv = (Node)view;
                WfmNavigatorGroup incominglinks = new WfmNavigatorGroup(Messages.NavigatorGroupName_Subprocess_2007_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                WfmNavigatorGroup outgoinglinks = new WfmNavigatorGroup(Messages.NavigatorGroupName_Subprocess_2007_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7003));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3007));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7003));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3005));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7003));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3006));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7003));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3004));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7003));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3008));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7005));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3010));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7007));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3009));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7008));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3011));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(4003));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(4003));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2008: {
                LinkedList<WfmAbstractNavigatorItem> result = new LinkedList<WfmAbstractNavigatorItem>();
                Node sv = (Node)view;
                WfmNavigatorGroup incominglinks = new WfmNavigatorGroup(Messages.NavigatorGroupName_Task_2008_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                WfmNavigatorGroup outgoinglinks = new WfmNavigatorGroup(Messages.NavigatorGroupName_Task_2008_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7014));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3010));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7015));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3009));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(7016));
                connectedViews = this.getChildrenByType(connectedViews, WfmVisualIDRegistry.getType(3011));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(4003));
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(4003));
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 1000: {
                LinkedList<WfmAbstractNavigatorItem> result = new LinkedList<WfmAbstractNavigatorItem>();
                Diagram sv = (Diagram)view;
                WfmNavigatorGroup links = new WfmNavigatorGroup(Messages.NavigatorGroupName_Process_1000_links, "icons/linksNavigatorGroup.gif", parentElement);
                Collection<View> connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(2007));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(2008));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(2005));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(2006));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(2003));
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(sv), WfmVisualIDRegistry.getType(4003));
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                if (!links.isEmpty()) {
                    result.add(links);
                }
                return result.toArray();
            }
        }
        return EMPTY_ARRAY;
    }

    private Collection<View> getLinksSourceByType(Collection<Edge> edges, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeSource = nextEdge.getSource();
            if (!type.equals(nextEdgeSource.getType()) || !this.isOwnView(nextEdgeSource)) continue;
            result.add(nextEdgeSource);
        }
        return result;
    }

    private Collection<View> getLinksTargetByType(Collection<Edge> edges, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeTarget = nextEdge.getTarget();
            if (!type.equals(nextEdgeTarget.getType()) || !this.isOwnView(nextEdgeTarget)) continue;
            result.add(nextEdgeTarget);
        }
        return result;
    }

    private Collection<View> getOutgoingLinksByType(Collection<? extends View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View view : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)view.getSourceEdges(), type));
        }
        return result;
    }

    private Collection<View> getIncomingLinksByType(Collection<? extends View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View view : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)view.getTargetEdges(), type));
        }
        return result;
    }

    private Collection<View> getChildrenByType(Collection<? extends View> nodes, String type) {
        LinkedList<View> result = new LinkedList<View>();
        for (View view : nodes) {
            result.addAll(this.selectViewsByType((Collection<View>)view.getChildren(), type));
        }
        return result;
    }

    private Collection<View> getDiagramLinksByType(Collection<Diagram> diagrams, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Diagram nextDiagram : diagrams) {
            result.addAll(this.selectViewsByType((Collection<View>)nextDiagram.getEdges(), type));
        }
        return result;
    }

    private Collection<View> selectViewsByType(Collection<View> views, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : views) {
            if (!type.equals(nextView.getType()) || !this.isOwnView(nextView)) continue;
            result.add(nextView);
        }
        return result;
    }

    private boolean isOwnView(View view) {
        return "Wfm".equals(WfmVisualIDRegistry.getModelID(view));
    }

    private Collection<WfmNavigatorItem> createNavigatorItems(Collection<View> views, Object parent, boolean isLeafs) {
        ArrayList<WfmNavigatorItem> result = new ArrayList<WfmNavigatorItem>(views.size());
        for (View nextView : views) {
            result.add(new WfmNavigatorItem(nextView, parent, isLeafs));
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element instanceof WfmAbstractNavigatorItem) {
            WfmAbstractNavigatorItem abstractNavigatorItem = (WfmAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }
}

