/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.wfm.diagram.edit.commands;

import es.upv.dsic.issi.dplfw.wfm.Source;
import es.upv.dsic.issi.dplfw.wfm.Target;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.policies.WfmBaseItemSemanticEditPolicy;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;

public class SourceToReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject referenceOwner;
    private final EObject oldEnd;
    private final EObject newEnd;

    public SourceToReorientCommand(ReorientReferenceRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.referenceOwner = request.getReferenceOwner();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.referenceOwner instanceof Source)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Target) || !(this.newEnd instanceof Source)) {
            return false;
        }
        return WfmBaseItemSemanticEditPolicy.getLinkConstraints().canExistSourceTo_4003(this.getNewSource(), this.getOldTarget());
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Target) || !(this.newEnd instanceof Target)) {
            return false;
        }
        return WfmBaseItemSemanticEditPolicy.getLinkConstraints().canExistSourceTo_4003(this.getOldSource(), this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().getTo().remove((Object)this.getOldTarget());
        this.getNewSource().getTo().add((Object)this.getOldTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getOldSource().getTo().remove((Object)this.getOldTarget());
        this.getOldSource().getTo().add((Object)this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected Source getOldSource() {
        return (Source)this.referenceOwner;
    }

    protected Source getNewSource() {
        return (Source)this.newEnd;
    }

    protected Target getOldTarget() {
        return (Target)this.oldEnd;
    }

    protected Target getNewTarget() {
        return (Target)this.newEnd;
    }
}

