package es.upv.dsic.issi.dplfw.wfm.diagram.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.Actor2EditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.Actor3EditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.ActorEditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.End2EditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.EndEditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.Gateway2EditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.GatewayEditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.ProcessEditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.SourceToEditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.Start2EditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.StartEditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.Subprocess2EditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.SubprocessEditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.SubprocessEditors2EditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.SubprocessEditorsEditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.SubprocessReaders2EditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.SubprocessReadersEditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.SubprocessResponsible2EditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.SubprocessResponsibleEditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.SubprocessSubprocess2EditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.SubprocessSubprocessEditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.Task2EditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.TaskEditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.TaskEditors2EditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.TaskEditorsEditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.TaskReaders2EditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.TaskReadersEditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.TaskResponsible2EditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.TaskResponsibleEditPart;
import es.upv.dsic.issi.dplfw.wfm.diagram.part.Messages;
import es.upv.dsic.issi.dplfw.wfm.diagram.part.WfmVisualIDRegistry;

/**
 * @generated
 */
public class WfmNavigatorContentProvider implements ICommonContentProvider {

	/**
	 * @generated
	 */
	private static final Object[] EMPTY_ARRAY = new Object[0];

	/**
	 * @generated
	 */
	private Viewer myViewer;

	/**
	 * @generated
	 */
	private AdapterFactoryEditingDomain myEditingDomain;

	/**
	 * @generated
	 */
	private WorkspaceSynchronizer myWorkspaceSynchronizer;

	/**
	 * @generated
	 */
	private Runnable myViewerRefreshRunnable;

	/**
	 * @generated
	 */
	@SuppressWarnings({ "unchecked", "serial", "rawtypes" })
	public WfmNavigatorContentProvider() {
		TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE
				.createEditingDomain();
		myEditingDomain = (AdapterFactoryEditingDomain) editingDomain;
		myEditingDomain.setResourceToReadOnlyMap(new HashMap() {
			public Object get(Object key) {
				if (!containsKey(key)) {
					put(key, Boolean.TRUE);
				}
				return super.get(key);
			}
		});
		myViewerRefreshRunnable = new Runnable() {
			public void run() {
				if (myViewer != null) {
					myViewer.refresh();
				}
			}
		};
		myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain,
				new WorkspaceSynchronizer.Delegate() {
					public void dispose() {
					}

					public boolean handleResourceChanged(final Resource resource) {
						unloadAllResources();
						asyncRefresh();
						return true;
					}

					public boolean handleResourceDeleted(Resource resource) {
						unloadAllResources();
						asyncRefresh();
						return true;
					}

					public boolean handleResourceMoved(Resource resource,
							final URI newURI) {
						unloadAllResources();
						asyncRefresh();
						return true;
					}
				});
	}

	/**
	 * @generated
	 */
	public void dispose() {
		myWorkspaceSynchronizer.dispose();
		myWorkspaceSynchronizer = null;
		myViewerRefreshRunnable = null;
		myViewer = null;
		unloadAllResources();
		((TransactionalEditingDomain) myEditingDomain).dispose();
		myEditingDomain = null;
	}

	/**
	 * @generated
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		myViewer = viewer;
	}

	/**
	 * @generated
	 */
	void unloadAllResources() {
		for (Resource nextResource : myEditingDomain.getResourceSet()
				.getResources()) {
			nextResource.unload();
		}
	}

	/**
	 * @generated
	 */
	void asyncRefresh() {
		if (myViewer != null && !myViewer.getControl().isDisposed()) {
			myViewer.getControl().getDisplay()
					.asyncExec(myViewerRefreshRunnable);
		}
	}

	/**
	 * @generated
	 */
	public Object[] getElements(Object inputElement) {
		return getChildren(inputElement);
	}

	/**
	 * @generated
	 */
	public void restoreState(IMemento aMemento) {
	}

	/**
	 * @generated
	 */
	public void saveState(IMemento aMemento) {
	}

	/**
	 * @generated
	 */
	public void init(ICommonContentExtensionSite aConfig) {
	}

	/**
	 * @generated
	 */
	public Object[] getChildren(Object parentElement) {
		if (parentElement instanceof IFile) {
			IFile file = (IFile) parentElement;
			URI fileURI = URI.createPlatformResourceURI(file.getFullPath()
					.toString(), true);
			Resource resource = myEditingDomain.getResourceSet().getResource(
					fileURI, true);
			ArrayList<WfmNavigatorItem> result = new ArrayList<WfmNavigatorItem>();
			ArrayList<View> topViews = new ArrayList<View>(resource
					.getContents().size());
			for (EObject o : resource.getContents()) {
				if (o instanceof View) {
					topViews.add((View) o);
				}
			}
			return result.toArray();
		}

		if (parentElement instanceof WfmNavigatorGroup) {
			WfmNavigatorGroup group = (WfmNavigatorGroup) parentElement;
			return group.getChildren();
		}

		if (parentElement instanceof WfmNavigatorItem) {
			WfmNavigatorItem navigatorItem = (WfmNavigatorItem) parentElement;
			if (navigatorItem.isLeaf() || !isOwnView(navigatorItem.getView())) {
				return EMPTY_ARRAY;
			}
			return getViewChildren(navigatorItem.getView(), parentElement);
		}

		return EMPTY_ARRAY;
	}

	/**
	 * @generated
	 */
	private Object[] getViewChildren(View view, Object parentElement) {
		switch (WfmVisualIDRegistry.getVisualID(view)) {

		case EndEditPart.VISUAL_ID: {
			LinkedList<WfmAbstractNavigatorItem> result = new LinkedList<WfmAbstractNavigatorItem>();
			Node sv = (Node) view;
			WfmNavigatorGroup incominglinks = new WfmNavigatorGroup(
					Messages.NavigatorGroupName_End_2006_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection<View> connectedViews;
			connectedViews = getIncomingLinksByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(SourceToEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews,
					incominglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			return result.toArray();
		}

		case StartEditPart.VISUAL_ID: {
			LinkedList<WfmAbstractNavigatorItem> result = new LinkedList<WfmAbstractNavigatorItem>();
			Node sv = (Node) view;
			WfmNavigatorGroup outgoinglinks = new WfmNavigatorGroup(
					Messages.NavigatorGroupName_Start_2005_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection<View> connectedViews;
			connectedViews = getOutgoingLinksByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(SourceToEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews,
					outgoinglinks, true));
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case End2EditPart.VISUAL_ID: {
			LinkedList<WfmAbstractNavigatorItem> result = new LinkedList<WfmAbstractNavigatorItem>();
			Node sv = (Node) view;
			WfmNavigatorGroup incominglinks = new WfmNavigatorGroup(
					Messages.NavigatorGroupName_End_3006_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection<View> connectedViews;
			connectedViews = getIncomingLinksByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(SourceToEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews,
					incominglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			return result.toArray();
		}

		case Start2EditPart.VISUAL_ID: {
			LinkedList<WfmAbstractNavigatorItem> result = new LinkedList<WfmAbstractNavigatorItem>();
			Node sv = (Node) view;
			WfmNavigatorGroup outgoinglinks = new WfmNavigatorGroup(
					Messages.NavigatorGroupName_Start_3005_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection<View> connectedViews;
			connectedViews = getOutgoingLinksByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(SourceToEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews,
					outgoinglinks, true));
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case SourceToEditPart.VISUAL_ID: {
			LinkedList<WfmAbstractNavigatorItem> result = new LinkedList<WfmAbstractNavigatorItem>();
			Edge sv = (Edge) view;
			WfmNavigatorGroup target = new WfmNavigatorGroup(
					Messages.NavigatorGroupName_SourceTo_4003_target,
					"icons/linkTargetNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			WfmNavigatorGroup source = new WfmNavigatorGroup(
					Messages.NavigatorGroupName_SourceTo_4003_source,
					"icons/linkSourceNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection<View> connectedViews;
			connectedViews = getLinksTargetByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(SubprocessEditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target,
					true));
			connectedViews = getLinksTargetByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(TaskEditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target,
					true));
			connectedViews = getLinksTargetByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(EndEditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target,
					true));
			connectedViews = getLinksTargetByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(GatewayEditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target,
					true));
			connectedViews = getLinksTargetByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(Subprocess2EditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target,
					true));
			connectedViews = getLinksTargetByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(End2EditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target,
					true));
			connectedViews = getLinksTargetByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(Gateway2EditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target,
					true));
			connectedViews = getLinksTargetByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(Task2EditPart.VISUAL_ID));
			target.addChildren(createNavigatorItems(connectedViews, target,
					true));
			connectedViews = getLinksSourceByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(SubprocessEditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source,
					true));
			connectedViews = getLinksSourceByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(TaskEditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source,
					true));
			connectedViews = getLinksSourceByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(StartEditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source,
					true));
			connectedViews = getLinksSourceByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(GatewayEditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source,
					true));
			connectedViews = getLinksSourceByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(Subprocess2EditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source,
					true));
			connectedViews = getLinksSourceByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(Start2EditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source,
					true));
			connectedViews = getLinksSourceByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(Gateway2EditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source,
					true));
			connectedViews = getLinksSourceByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(Task2EditPart.VISUAL_ID));
			source.addChildren(createNavigatorItems(connectedViews, source,
					true));
			if (!target.isEmpty()) {
				result.add(target);
			}
			if (!source.isEmpty()) {
				result.add(source);
			}
			return result.toArray();
		}

		case Task2EditPart.VISUAL_ID: {
			LinkedList<WfmAbstractNavigatorItem> result = new LinkedList<WfmAbstractNavigatorItem>();
			Node sv = (Node) view;
			WfmNavigatorGroup incominglinks = new WfmNavigatorGroup(
					Messages.NavigatorGroupName_Task_3008_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			WfmNavigatorGroup outgoinglinks = new WfmNavigatorGroup(
					Messages.NavigatorGroupName_Task_3008_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection<View> connectedViews;
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry
							.getType(TaskResponsibleEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(ActorEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(TaskEditorsEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(Actor2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(TaskReadersEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(Actor3EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getIncomingLinksByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(SourceToEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews,
					incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(SourceToEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews,
					outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case Subprocess2EditPart.VISUAL_ID: {
			LinkedList<WfmAbstractNavigatorItem> result = new LinkedList<WfmAbstractNavigatorItem>();
			Node sv = (Node) view;
			WfmNavigatorGroup incominglinks = new WfmNavigatorGroup(
					Messages.NavigatorGroupName_Subprocess_3007_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			WfmNavigatorGroup outgoinglinks = new WfmNavigatorGroup(
					Messages.NavigatorGroupName_Subprocess_3007_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection<View> connectedViews;
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry
							.getType(SubprocessSubprocess2EditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(Subprocess2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry
							.getType(SubprocessSubprocess2EditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(Start2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry
							.getType(SubprocessSubprocess2EditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(End2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry
							.getType(SubprocessSubprocess2EditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(Gateway2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry
							.getType(SubprocessSubprocess2EditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(Task2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry
							.getType(SubprocessResponsible2EditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(ActorEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry
							.getType(SubprocessEditors2EditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(Actor2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry
							.getType(SubprocessReaders2EditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(Actor3EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getIncomingLinksByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(SourceToEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews,
					incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(SourceToEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews,
					outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case Gateway2EditPart.VISUAL_ID: {
			LinkedList<WfmAbstractNavigatorItem> result = new LinkedList<WfmAbstractNavigatorItem>();
			Node sv = (Node) view;
			WfmNavigatorGroup incominglinks = new WfmNavigatorGroup(
					Messages.NavigatorGroupName_Gateway_3004_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			WfmNavigatorGroup outgoinglinks = new WfmNavigatorGroup(
					Messages.NavigatorGroupName_Gateway_3004_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection<View> connectedViews;
			connectedViews = getIncomingLinksByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(SourceToEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews,
					incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(SourceToEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews,
					outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case GatewayEditPart.VISUAL_ID: {
			LinkedList<WfmAbstractNavigatorItem> result = new LinkedList<WfmAbstractNavigatorItem>();
			Node sv = (Node) view;
			WfmNavigatorGroup incominglinks = new WfmNavigatorGroup(
					Messages.NavigatorGroupName_Gateway_2003_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			WfmNavigatorGroup outgoinglinks = new WfmNavigatorGroup(
					Messages.NavigatorGroupName_Gateway_2003_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection<View> connectedViews;
			connectedViews = getIncomingLinksByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(SourceToEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews,
					incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(SourceToEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews,
					outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case SubprocessEditPart.VISUAL_ID: {
			LinkedList<WfmAbstractNavigatorItem> result = new LinkedList<WfmAbstractNavigatorItem>();
			Node sv = (Node) view;
			WfmNavigatorGroup incominglinks = new WfmNavigatorGroup(
					Messages.NavigatorGroupName_Subprocess_2007_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			WfmNavigatorGroup outgoinglinks = new WfmNavigatorGroup(
					Messages.NavigatorGroupName_Subprocess_2007_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection<View> connectedViews;
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry
							.getType(SubprocessSubprocessEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(Subprocess2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry
							.getType(SubprocessSubprocessEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(Start2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry
							.getType(SubprocessSubprocessEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(End2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry
							.getType(SubprocessSubprocessEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(Gateway2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry
							.getType(SubprocessSubprocessEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(Task2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry
							.getType(SubprocessResponsibleEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(ActorEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry
							.getType(SubprocessEditorsEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(Actor2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry
							.getType(SubprocessReadersEditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(Actor3EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getIncomingLinksByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(SourceToEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews,
					incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(SourceToEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews,
					outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case TaskEditPart.VISUAL_ID: {
			LinkedList<WfmAbstractNavigatorItem> result = new LinkedList<WfmAbstractNavigatorItem>();
			Node sv = (Node) view;
			WfmNavigatorGroup incominglinks = new WfmNavigatorGroup(
					Messages.NavigatorGroupName_Task_2008_incominglinks,
					"icons/incomingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			WfmNavigatorGroup outgoinglinks = new WfmNavigatorGroup(
					Messages.NavigatorGroupName_Task_2008_outgoinglinks,
					"icons/outgoingLinksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection<View> connectedViews;
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry
							.getType(TaskResponsible2EditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(ActorEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(TaskEditors2EditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(Actor2EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(TaskReaders2EditPart.VISUAL_ID));
			connectedViews = getChildrenByType(connectedViews,
					WfmVisualIDRegistry.getType(Actor3EditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getIncomingLinksByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(SourceToEditPart.VISUAL_ID));
			incominglinks.addChildren(createNavigatorItems(connectedViews,
					incominglinks, true));
			connectedViews = getOutgoingLinksByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(SourceToEditPart.VISUAL_ID));
			outgoinglinks.addChildren(createNavigatorItems(connectedViews,
					outgoinglinks, true));
			if (!incominglinks.isEmpty()) {
				result.add(incominglinks);
			}
			if (!outgoinglinks.isEmpty()) {
				result.add(outgoinglinks);
			}
			return result.toArray();
		}

		case ProcessEditPart.VISUAL_ID: {
			LinkedList<WfmAbstractNavigatorItem> result = new LinkedList<WfmAbstractNavigatorItem>();
			Diagram sv = (Diagram) view;
			WfmNavigatorGroup links = new WfmNavigatorGroup(
					Messages.NavigatorGroupName_Process_1000_links,
					"icons/linksNavigatorGroup.gif", parentElement); //$NON-NLS-1$
			Collection<View> connectedViews;
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(SubprocessEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(TaskEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(StartEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(EndEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getChildrenByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(GatewayEditPart.VISUAL_ID));
			result.addAll(createNavigatorItems(connectedViews, parentElement,
					false));
			connectedViews = getDiagramLinksByType(Collections.singleton(sv),
					WfmVisualIDRegistry.getType(SourceToEditPart.VISUAL_ID));
			links.addChildren(createNavigatorItems(connectedViews, links, false));
			if (!links.isEmpty()) {
				result.add(links);
			}
			return result.toArray();
		}
		}
		return EMPTY_ARRAY;
	}

	/**
	 * @generated
	 */
	private Collection<View> getLinksSourceByType(Collection<Edge> edges,
			String type) {
		LinkedList<View> result = new LinkedList<View>();
		for (Edge nextEdge : edges) {
			View nextEdgeSource = nextEdge.getSource();
			if (type.equals(nextEdgeSource.getType())
					&& isOwnView(nextEdgeSource)) {
				result.add(nextEdgeSource);
			}
		}
		return result;
	}

	/**
	 * @generated
	 */
	private Collection<View> getLinksTargetByType(Collection<Edge> edges,
			String type) {
		LinkedList<View> result = new LinkedList<View>();
		for (Edge nextEdge : edges) {
			View nextEdgeTarget = nextEdge.getTarget();
			if (type.equals(nextEdgeTarget.getType())
					&& isOwnView(nextEdgeTarget)) {
				result.add(nextEdgeTarget);
			}
		}
		return result;
	}

	/**
	 * @generated
	 */
	private Collection<View> getOutgoingLinksByType(
			Collection<? extends View> nodes, String type) {
		LinkedList<View> result = new LinkedList<View>();
		for (View nextNode : nodes) {
			result.addAll(selectViewsByType(nextNode.getSourceEdges(), type));
		}
		return result;
	}

	/**
	 * @generated
	 */
	private Collection<View> getIncomingLinksByType(
			Collection<? extends View> nodes, String type) {
		LinkedList<View> result = new LinkedList<View>();
		for (View nextNode : nodes) {
			result.addAll(selectViewsByType(nextNode.getTargetEdges(), type));
		}
		return result;
	}

	/**
	 * @generated
	 */
	private Collection<View> getChildrenByType(
			Collection<? extends View> nodes, String type) {
		LinkedList<View> result = new LinkedList<View>();
		for (View nextNode : nodes) {
			result.addAll(selectViewsByType(nextNode.getChildren(), type));
		}
		return result;
	}

	/**
	 * @generated
	 */
	private Collection<View> getDiagramLinksByType(
			Collection<Diagram> diagrams, String type) {
		ArrayList<View> result = new ArrayList<View>();
		for (Diagram nextDiagram : diagrams) {
			result.addAll(selectViewsByType(nextDiagram.getEdges(), type));
		}
		return result;
	}

	// TODO refactor as static method
	/**
	 * @generated
	 */
	private Collection<View> selectViewsByType(Collection<View> views,
			String type) {
		ArrayList<View> result = new ArrayList<View>();
		for (View nextView : views) {
			if (type.equals(nextView.getType()) && isOwnView(nextView)) {
				result.add(nextView);
			}
		}
		return result;
	}

	/**
	 * @generated
	 */
	private boolean isOwnView(View view) {
		return ProcessEditPart.MODEL_ID.equals(WfmVisualIDRegistry
				.getModelID(view));
	}

	/**
	 * @generated
	 */
	private Collection<WfmNavigatorItem> createNavigatorItems(
			Collection<View> views, Object parent, boolean isLeafs) {
		ArrayList<WfmNavigatorItem> result = new ArrayList<WfmNavigatorItem>(
				views.size());
		for (View nextView : views) {
			result.add(new WfmNavigatorItem(nextView, parent, isLeafs));
		}
		return result;
	}

	/**
	 * @generated
	 */
	public Object getParent(Object element) {
		if (element instanceof WfmAbstractNavigatorItem) {
			WfmAbstractNavigatorItem abstractNavigatorItem = (WfmAbstractNavigatorItem) element;
			return abstractNavigatorItem.getParent();
		}
		return null;
	}

	/**
	 * @generated
	 */
	public boolean hasChildren(Object element) {
		return element instanceof IFile || getChildren(element).length > 0;
	}

}
