package es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Text;

import es.upv.dsic.issi.dplfw.wfm.diagram.part.WfmVisualIDRegistry;

/**
 * @generated
 */
public class WfmEditPartFactory implements EditPartFactory {

	/**
	 * @generated
	 */
	public EditPart createEditPart(EditPart context, Object model) {
		if (model instanceof View) {
			View view = (View) model;
			switch (WfmVisualIDRegistry.getVisualID(view)) {

			case ProcessEditPart.VISUAL_ID:
				return new ProcessEditPart(view);

			case SubprocessEditPart.VISUAL_ID:
				return new SubprocessEditPart(view);

			case SubprocessNameEditPart.VISUAL_ID:
				return new SubprocessNameEditPart(view);

			case TaskEditPart.VISUAL_ID:
				return new TaskEditPart(view);

			case TaskNameEditPart.VISUAL_ID:
				return new TaskNameEditPart(view);

			case StartEditPart.VISUAL_ID:
				return new StartEditPart(view);

			case EndEditPart.VISUAL_ID:
				return new EndEditPart(view);

			case GatewayEditPart.VISUAL_ID:
				return new GatewayEditPart(view);

			case Subprocess2EditPart.VISUAL_ID:
				return new Subprocess2EditPart(view);

			case SubprocessName2EditPart.VISUAL_ID:
				return new SubprocessName2EditPart(view);

			case Start2EditPart.VISUAL_ID:
				return new Start2EditPart(view);

			case End2EditPart.VISUAL_ID:
				return new End2EditPart(view);

			case Gateway2EditPart.VISUAL_ID:
				return new Gateway2EditPart(view);

			case Task2EditPart.VISUAL_ID:
				return new Task2EditPart(view);

			case TaskName2EditPart.VISUAL_ID:
				return new TaskName2EditPart(view);

			case ActorEditPart.VISUAL_ID:
				return new ActorEditPart(view);

			case ActorNameEditPart.VISUAL_ID:
				return new ActorNameEditPart(view);

			case Actor2EditPart.VISUAL_ID:
				return new Actor2EditPart(view);

			case ActorName2EditPart.VISUAL_ID:
				return new ActorName2EditPart(view);

			case Actor3EditPart.VISUAL_ID:
				return new Actor3EditPart(view);

			case ActorName3EditPart.VISUAL_ID:
				return new ActorName3EditPart(view);

			case SubprocessSubprocessEditPart.VISUAL_ID:
				return new SubprocessSubprocessEditPart(view);

			case SubprocessResponsibleEditPart.VISUAL_ID:
				return new SubprocessResponsibleEditPart(view);

			case SubprocessEditorsEditPart.VISUAL_ID:
				return new SubprocessEditorsEditPart(view);

			case SubprocessReadersEditPart.VISUAL_ID:
				return new SubprocessReadersEditPart(view);

			case SubprocessSubprocess2EditPart.VISUAL_ID:
				return new SubprocessSubprocess2EditPart(view);

			case SubprocessResponsible2EditPart.VISUAL_ID:
				return new SubprocessResponsible2EditPart(view);

			case SubprocessEditors2EditPart.VISUAL_ID:
				return new SubprocessEditors2EditPart(view);

			case SubprocessReaders2EditPart.VISUAL_ID:
				return new SubprocessReaders2EditPart(view);

			case TaskResponsibleEditPart.VISUAL_ID:
				return new TaskResponsibleEditPart(view);

			case TaskEditorsEditPart.VISUAL_ID:
				return new TaskEditorsEditPart(view);

			case TaskReadersEditPart.VISUAL_ID:
				return new TaskReadersEditPart(view);

			case TaskResponsible2EditPart.VISUAL_ID:
				return new TaskResponsible2EditPart(view);

			case TaskEditors2EditPart.VISUAL_ID:
				return new TaskEditors2EditPart(view);

			case TaskReaders2EditPart.VISUAL_ID:
				return new TaskReaders2EditPart(view);

			case SourceToEditPart.VISUAL_ID:
				return new SourceToEditPart(view);

			}
		}
		return createUnrecognizedEditPart(context, model);
	}

	/**
	 * @generated
	 */
	private EditPart createUnrecognizedEditPart(EditPart context, Object model) {
		// Handle creation of unrecognized child node EditParts here
		return null;
	}

	/**
	 * @generated
	 */
	public static CellEditorLocator getTextCellEditorLocator(
			ITextAwareEditPart source) {
		if (source.getFigure() instanceof WrappingLabel)
			return new TextCellEditorLocator((WrappingLabel) source.getFigure());
		else {
			return new LabelCellEditorLocator((Label) source.getFigure());
		}
	}

	/**
	 * @generated
	 */
	static private class TextCellEditorLocator implements CellEditorLocator {

		/**
		 * @generated
		 */
		private WrappingLabel wrapLabel;

		/**
		 * @generated
		 */
		public TextCellEditorLocator(WrappingLabel wrapLabel) {
			this.wrapLabel = wrapLabel;
		}

		/**
		 * @generated
		 */
		public WrappingLabel getWrapLabel() {
			return wrapLabel;
		}

		/**
		 * @generated
		 */
		public void relocate(CellEditor celleditor) {
			Text text = (Text) celleditor.getControl();
			Rectangle rect = getWrapLabel().getTextBounds().getCopy();
			getWrapLabel().translateToAbsolute(rect);
			if (!text.getFont().isDisposed()) {
				if (getWrapLabel().isTextWrapOn()
						&& getWrapLabel().getText().length() > 0) {
					rect.setSize(new Dimension(text.computeSize(rect.width,
							SWT.DEFAULT)));
				} else {
					int avr = FigureUtilities.getFontMetrics(text.getFont())
							.getAverageCharWidth();
					rect.setSize(new Dimension(text.computeSize(SWT.DEFAULT,
							SWT.DEFAULT)).expand(avr * 2, 0));
				}
			}
			if (!rect.equals(new Rectangle(text.getBounds()))) {
				text.setBounds(rect.x, rect.y, rect.width, rect.height);
			}
		}
	}

	/**
	 * @generated
	 */
	private static class LabelCellEditorLocator implements CellEditorLocator {

		/**
		 * @generated
		 */
		private Label label;

		/**
		 * @generated
		 */
		public LabelCellEditorLocator(Label label) {
			this.label = label;
		}

		/**
		 * @generated
		 */
		public Label getLabel() {
			return label;
		}

		/**
		 * @generated
		 */
		public void relocate(CellEditor celleditor) {
			Text text = (Text) celleditor.getControl();
			Rectangle rect = getLabel().getTextBounds().getCopy();
			getLabel().translateToAbsolute(rect);
			if (!text.getFont().isDisposed()) {
				int avr = FigureUtilities.getFontMetrics(text.getFont())
						.getAverageCharWidth();
				rect.setSize(new Dimension(text.computeSize(SWT.DEFAULT,
						SWT.DEFAULT)).expand(avr * 2, 0));
			}
			if (!rect.equals(new Rectangle(text.getBounds()))) {
				text.setBounds(rect.x, rect.y, rect.width, rect.height);
			}
		}
	}
}
