package es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

import es.upv.dsic.issi.dplfw.wfm.diagram.edit.policies.OpenDiagramEditPolicy;
import es.upv.dsic.issi.dplfw.wfm.diagram.edit.policies.Subprocess2ItemSemanticEditPolicy;
import es.upv.dsic.issi.dplfw.wfm.diagram.part.WfmVisualIDRegistry;
import es.upv.dsic.issi.dplfw.wfm.diagram.providers.WfmElementTypes;

/**
 * @generated
 */
public class Subprocess2EditPart extends ShapeNodeEditPart {

	/**
	 * @generated
	 */
	public static final int VISUAL_ID = 3007;

	/**
	 * @generated
	 */
	protected IFigure contentPane;

	/**
	 * @generated
	 */
	protected IFigure primaryShape;

	/**
	 * @generated
	 */
	public Subprocess2EditPart(View view) {
		super(view);
	}

	/**
	 * @generated
	 */
	protected void createDefaultEditPolicies() {
		installEditPolicy(EditPolicyRoles.CREATION_ROLE,
				new CreationEditPolicy());
		super.createDefaultEditPolicies();
		installEditPolicy(EditPolicyRoles.SEMANTIC_ROLE,
				new Subprocess2ItemSemanticEditPolicy());
		installEditPolicy(EditPolicy.LAYOUT_ROLE, createLayoutEditPolicy());
		installEditPolicy(EditPolicyRoles.OPEN_ROLE,
				new OpenDiagramEditPolicy());
		// XXX need an SCR to runtime to have another abstract superclass that would let children add reasonable editpolicies
		// removeEditPolicy(org.eclipse.gmf.runtime.diagram.ui.editpolicies.EditPolicyRoles.CONNECTION_HANDLES_ROLE);
	}

	/**
	 * @generated
	 */
	protected LayoutEditPolicy createLayoutEditPolicy() {
		org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy() {

			protected EditPolicy createChildEditPolicy(EditPart child) {
				EditPolicy result = child
						.getEditPolicy(EditPolicy.PRIMARY_DRAG_ROLE);
				if (result == null) {
					result = new NonResizableEditPolicy();
				}
				return result;
			}

			protected Command getMoveChildrenCommand(Request request) {
				return null;
			}

			protected Command getCreateCommand(CreateRequest request) {
				return null;
			}
		};
		return lep;
	}

	/**
	 * @generated
	 */
	protected IFigure createNodeShape() {
		return primaryShape = new ActivityFigure();
	}

	/**
	 * @generated
	 */
	public ActivityFigure getPrimaryShape() {
		return (ActivityFigure) primaryShape;
	}

	/**
	 * @generated
	 */
	protected boolean addFixedChild(EditPart childEditPart) {
		if (childEditPart instanceof SubprocessName2EditPart) {
			((SubprocessName2EditPart) childEditPart)
					.setLabel(getPrimaryShape().getActivityNameFigure());
			return true;
		}
		if (childEditPart instanceof SubprocessSubprocess2EditPart) {
			IFigure pane = getPrimaryShape().getProcessFigure();
			setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way 
			pane.add(((SubprocessSubprocess2EditPart) childEditPart)
					.getFigure());
			return true;
		}
		if (childEditPart instanceof SubprocessResponsible2EditPart) {
			IFigure pane = getPrimaryShape().getResponsibleFigure();
			setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way 
			pane.add(((SubprocessResponsible2EditPart) childEditPart)
					.getFigure());
			return true;
		}
		if (childEditPart instanceof SubprocessEditors2EditPart) {
			IFigure pane = getPrimaryShape().getEditorsFigure();
			setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way 
			pane.add(((SubprocessEditors2EditPart) childEditPart).getFigure());
			return true;
		}
		if (childEditPart instanceof SubprocessReaders2EditPart) {
			IFigure pane = getPrimaryShape().getReadersFigure();
			setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way 
			pane.add(((SubprocessReaders2EditPart) childEditPart).getFigure());
			return true;
		}
		return false;
	}

	/**
	 * @generated
	 */
	protected boolean removeFixedChild(EditPart childEditPart) {
		if (childEditPart instanceof SubprocessName2EditPart) {
			return true;
		}
		if (childEditPart instanceof SubprocessSubprocess2EditPart) {
			IFigure pane = getPrimaryShape().getProcessFigure();
			setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way 
			pane.remove(((SubprocessSubprocess2EditPart) childEditPart)
					.getFigure());
			return true;
		}
		if (childEditPart instanceof SubprocessResponsible2EditPart) {
			IFigure pane = getPrimaryShape().getResponsibleFigure();
			setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way 
			pane.remove(((SubprocessResponsible2EditPart) childEditPart)
					.getFigure());
			return true;
		}
		if (childEditPart instanceof SubprocessEditors2EditPart) {
			IFigure pane = getPrimaryShape().getEditorsFigure();
			setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way 
			pane.remove(((SubprocessEditors2EditPart) childEditPart)
					.getFigure());
			return true;
		}
		if (childEditPart instanceof SubprocessReaders2EditPart) {
			IFigure pane = getPrimaryShape().getReadersFigure();
			setupContentPane(pane); // FIXME each comparment should handle his content pane in his own way 
			pane.remove(((SubprocessReaders2EditPart) childEditPart)
					.getFigure());
			return true;
		}
		return false;
	}

	/**
	 * @generated
	 */
	protected void addChildVisual(EditPart childEditPart, int index) {
		if (addFixedChild(childEditPart)) {
			return;
		}
		super.addChildVisual(childEditPart, -1);
	}

	/**
	 * @generated
	 */
	protected void removeChildVisual(EditPart childEditPart) {
		if (removeFixedChild(childEditPart)) {
			return;
		}
		super.removeChildVisual(childEditPart);
	}

	/**
	 * @generated
	 */
	protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
		if (editPart instanceof SubprocessSubprocess2EditPart) {
			return getPrimaryShape().getProcessFigure();
		}
		if (editPart instanceof SubprocessResponsible2EditPart) {
			return getPrimaryShape().getResponsibleFigure();
		}
		if (editPart instanceof SubprocessEditors2EditPart) {
			return getPrimaryShape().getEditorsFigure();
		}
		if (editPart instanceof SubprocessReaders2EditPart) {
			return getPrimaryShape().getReadersFigure();
		}
		return getContentPane();
	}

	/**
	 * @generated
	 */
	protected NodeFigure createNodePlate() {
		DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(40, 40);
		return result;
	}

	/**
	 * Creates figure for this edit part.
	 * 
	 * Body of this method does not depend on settings in generation model
	 * so you may safely remove <i>generated</i> tag and modify it.
	 * 
	 * @generated
	 */
	protected NodeFigure createNodeFigure() {
		NodeFigure figure = createNodePlate();
		figure.setLayoutManager(new StackLayout());
		IFigure shape = createNodeShape();
		figure.add(shape);
		contentPane = setupContentPane(shape);
		return figure;
	}

	/**
	 * Default implementation treats passed figure as content pane.
	 * Respects layout one may have set for generated figure.
	 * @param nodeShape instance of generated figure class
	 * @generated
	 */
	protected IFigure setupContentPane(IFigure nodeShape) {
		if (nodeShape.getLayoutManager() == null) {
			ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
			layout.setSpacing(5);
			nodeShape.setLayoutManager(layout);
		}
		return nodeShape; // use nodeShape itself as contentPane
	}

	/**
	 * @generated
	 */
	public IFigure getContentPane() {
		if (contentPane != null) {
			return contentPane;
		}
		return super.getContentPane();
	}

	/**
	 * @generated
	 */
	protected void setForegroundColor(Color color) {
		if (primaryShape != null) {
			primaryShape.setForegroundColor(color);
		}
	}

	/**
	 * @generated
	 */
	protected void setBackgroundColor(Color color) {
		if (primaryShape != null) {
			primaryShape.setBackgroundColor(color);
		}
	}

	/**
	 * @generated
	 */
	protected void setLineWidth(int width) {
		if (primaryShape instanceof Shape) {
			((Shape) primaryShape).setLineWidth(width);
		}
	}

	/**
	 * @generated
	 */
	protected void setLineType(int style) {
		if (primaryShape instanceof Shape) {
			((Shape) primaryShape).setLineStyle(style);
		}
	}

	/**
	 * @generated
	 */
	public EditPart getPrimaryChildEditPart() {
		return getChildBySemanticHint(WfmVisualIDRegistry
				.getType(SubprocessName2EditPart.VISUAL_ID));
	}

	/**
	 * @generated
	 */
	public List<IElementType> getMARelTypesOnSource() {
		ArrayList<IElementType> types = new ArrayList<IElementType>(1);
		types.add(WfmElementTypes.SourceTo_4003);
		return types;
	}

	/**
	 * @generated
	 */
	public List<IElementType> getMARelTypesOnSourceAndTarget(
			IGraphicalEditPart targetEditPart) {
		LinkedList<IElementType> types = new LinkedList<IElementType>();
		if (targetEditPart instanceof SubprocessEditPart) {
			types.add(WfmElementTypes.SourceTo_4003);
		}
		if (targetEditPart instanceof TaskEditPart) {
			types.add(WfmElementTypes.SourceTo_4003);
		}
		if (targetEditPart instanceof EndEditPart) {
			types.add(WfmElementTypes.SourceTo_4003);
		}
		if (targetEditPart instanceof GatewayEditPart) {
			types.add(WfmElementTypes.SourceTo_4003);
		}
		if (targetEditPart instanceof es.upv.dsic.issi.dplfw.wfm.diagram.edit.parts.Subprocess2EditPart) {
			types.add(WfmElementTypes.SourceTo_4003);
		}
		if (targetEditPart instanceof End2EditPart) {
			types.add(WfmElementTypes.SourceTo_4003);
		}
		if (targetEditPart instanceof Gateway2EditPart) {
			types.add(WfmElementTypes.SourceTo_4003);
		}
		if (targetEditPart instanceof Task2EditPart) {
			types.add(WfmElementTypes.SourceTo_4003);
		}
		return types;
	}

	/**
	 * @generated
	 */
	public List<IElementType> getMATypesForTarget(IElementType relationshipType) {
		LinkedList<IElementType> types = new LinkedList<IElementType>();
		if (relationshipType == WfmElementTypes.SourceTo_4003) {
			types.add(WfmElementTypes.Subprocess_2007);
			types.add(WfmElementTypes.Task_2008);
			types.add(WfmElementTypes.End_2006);
			types.add(WfmElementTypes.Gateway_2003);
			types.add(WfmElementTypes.Subprocess_3007);
			types.add(WfmElementTypes.End_3006);
			types.add(WfmElementTypes.Gateway_3004);
			types.add(WfmElementTypes.Task_3008);
		}
		return types;
	}

	/**
	 * @generated
	 */
	public List<IElementType> getMARelTypesOnTarget() {
		ArrayList<IElementType> types = new ArrayList<IElementType>(1);
		types.add(WfmElementTypes.SourceTo_4003);
		return types;
	}

	/**
	 * @generated
	 */
	public List<IElementType> getMATypesForSource(IElementType relationshipType) {
		LinkedList<IElementType> types = new LinkedList<IElementType>();
		if (relationshipType == WfmElementTypes.SourceTo_4003) {
			types.add(WfmElementTypes.Subprocess_2007);
			types.add(WfmElementTypes.Task_2008);
			types.add(WfmElementTypes.Start_2005);
			types.add(WfmElementTypes.Gateway_2003);
			types.add(WfmElementTypes.Subprocess_3007);
			types.add(WfmElementTypes.Start_3005);
			types.add(WfmElementTypes.Gateway_3004);
			types.add(WfmElementTypes.Task_3008);
		}
		return types;
	}

	/**
	 * @generated
	 */
	public EditPart getTargetEditPart(Request request) {
		if (request instanceof CreateViewAndElementRequest) {
			CreateElementRequestAdapter adapter = ((CreateViewAndElementRequest) request)
					.getViewAndElementDescriptor()
					.getCreateElementRequestAdapter();
			IElementType type = (IElementType) adapter
					.getAdapter(IElementType.class);
			if (type == WfmElementTypes.Actor_3010) {
				return getChildBySemanticHint(WfmVisualIDRegistry
						.getType(SubprocessResponsible2EditPart.VISUAL_ID));
			}
			if (type == WfmElementTypes.Actor_3009) {
				return getChildBySemanticHint(WfmVisualIDRegistry
						.getType(SubprocessEditors2EditPart.VISUAL_ID));
			}
			if (type == WfmElementTypes.Actor_3011) {
				return getChildBySemanticHint(WfmVisualIDRegistry
						.getType(SubprocessReaders2EditPart.VISUAL_ID));
			}
		}
		return super.getTargetEditPart(request);
	}

	/**
	 * @generated
	 */
	public class ActivityFigure extends RoundedRectangle {

		/**
		 * @generated
		 */
		private WrappingLabel fActivityNameFigure;
		/**
		 * @generated
		 */
		private RectangleFigure fResponsibleFigure;
		/**
		 * @generated
		 */
		private RectangleFigure fEditorsFigure;
		/**
		 * @generated
		 */
		private RectangleFigure fReadersFigure;
		/**
		 * @generated
		 */
		private RectangleFigure fProcessFigure;

		/**
		 * @generated
		 */
		public ActivityFigure() {

			GridLayout layoutThis = new GridLayout();
			layoutThis.numColumns = 1;
			layoutThis.makeColumnsEqualWidth = true;
			layoutThis.horizontalSpacing = 0;
			layoutThis.verticalSpacing = 2;
			layoutThis.marginWidth = 4;
			layoutThis.marginHeight = 4;
			this.setLayoutManager(layoutThis);

			this.setCornerDimensions(new Dimension(getMapMode().DPtoLP(8),
					getMapMode().DPtoLP(8)));
			this.setLineWidth(2);
			this.setForegroundColor(THIS_FORE);
			this.setBackgroundColor(THIS_BACK);
			this.setMinimumSize(new Dimension(getMapMode().DPtoLP(100),
					getMapMode().DPtoLP(41)));
			createContents();
		}

		/**
		 * @generated
		 */
		private void createContents() {

			RectangleFigure rect0 = new RectangleFigure();
			rect0.setFill(false);
			rect0.setOutline(false);
			rect0.setLineWidth(0);

			GridData constraintRect0 = new GridData();
			constraintRect0.verticalAlignment = GridData.FILL;
			constraintRect0.horizontalAlignment = GridData.FILL;
			constraintRect0.horizontalIndent = 0;
			constraintRect0.horizontalSpan = 1;
			constraintRect0.verticalSpan = 1;
			constraintRect0.grabExcessHorizontalSpace = true;
			constraintRect0.grabExcessVerticalSpace = false;
			this.add(rect0, constraintRect0);

			GridLayout layoutRect0 = new GridLayout();
			layoutRect0.numColumns = 1;
			layoutRect0.makeColumnsEqualWidth = true;
			layoutRect0.horizontalSpacing = 0;
			layoutRect0.verticalSpacing = 0;
			layoutRect0.marginWidth = 5;
			layoutRect0.marginHeight = 1;
			rect0.setLayoutManager(layoutRect0);

			fActivityNameFigure = new WrappingLabel();
			fActivityNameFigure.setText("Activity");

			GridData constraintFActivityNameFigure = new GridData();
			constraintFActivityNameFigure.verticalAlignment = GridData.CENTER;
			constraintFActivityNameFigure.horizontalAlignment = GridData.CENTER;
			constraintFActivityNameFigure.horizontalIndent = 0;
			constraintFActivityNameFigure.horizontalSpan = 1;
			constraintFActivityNameFigure.verticalSpan = 1;
			constraintFActivityNameFigure.grabExcessHorizontalSpace = true;
			constraintFActivityNameFigure.grabExcessVerticalSpace = true;
			rect0.add(fActivityNameFigure, constraintFActivityNameFigure);

			fResponsibleFigure = new RectangleFigure();
			fResponsibleFigure.setFill(false);
			fResponsibleFigure.setOutline(false);
			fResponsibleFigure.setLineWidth(0);

			GridData constraintFResponsibleFigure = new GridData();
			constraintFResponsibleFigure.verticalAlignment = GridData.FILL;
			constraintFResponsibleFigure.horizontalAlignment = GridData.FILL;
			constraintFResponsibleFigure.horizontalIndent = 0;
			constraintFResponsibleFigure.horizontalSpan = 1;
			constraintFResponsibleFigure.verticalSpan = 1;
			constraintFResponsibleFigure.grabExcessHorizontalSpace = true;
			constraintFResponsibleFigure.grabExcessVerticalSpace = false;
			this.add(fResponsibleFigure, constraintFResponsibleFigure);

			fEditorsFigure = new RectangleFigure();
			fEditorsFigure.setFill(false);
			fEditorsFigure.setOutline(false);
			fEditorsFigure.setLineWidth(0);

			GridData constraintFEditorsFigure = new GridData();
			constraintFEditorsFigure.verticalAlignment = GridData.FILL;
			constraintFEditorsFigure.horizontalAlignment = GridData.FILL;
			constraintFEditorsFigure.horizontalIndent = 0;
			constraintFEditorsFigure.horizontalSpan = 1;
			constraintFEditorsFigure.verticalSpan = 1;
			constraintFEditorsFigure.grabExcessHorizontalSpace = true;
			constraintFEditorsFigure.grabExcessVerticalSpace = false;
			this.add(fEditorsFigure, constraintFEditorsFigure);

			fReadersFigure = new RectangleFigure();
			fReadersFigure.setFill(false);
			fReadersFigure.setOutline(false);
			fReadersFigure.setLineWidth(0);

			GridData constraintFReadersFigure = new GridData();
			constraintFReadersFigure.verticalAlignment = GridData.FILL;
			constraintFReadersFigure.horizontalAlignment = GridData.FILL;
			constraintFReadersFigure.horizontalIndent = 0;
			constraintFReadersFigure.horizontalSpan = 1;
			constraintFReadersFigure.verticalSpan = 1;
			constraintFReadersFigure.grabExcessHorizontalSpace = true;
			constraintFReadersFigure.grabExcessVerticalSpace = false;
			this.add(fReadersFigure, constraintFReadersFigure);

			fProcessFigure = new RectangleFigure();
			fProcessFigure.setFill(false);
			fProcessFigure.setOutline(false);
			fProcessFigure.setLineWidth(0);

			GridData constraintFProcessFigure = new GridData();
			constraintFProcessFigure.verticalAlignment = GridData.FILL;
			constraintFProcessFigure.horizontalAlignment = GridData.FILL;
			constraintFProcessFigure.horizontalIndent = 0;
			constraintFProcessFigure.horizontalSpan = 1;
			constraintFProcessFigure.verticalSpan = 1;
			constraintFProcessFigure.grabExcessHorizontalSpace = true;
			constraintFProcessFigure.grabExcessVerticalSpace = true;
			this.add(fProcessFigure, constraintFProcessFigure);

		}

		/**
		 * @generated
		 */
		public WrappingLabel getActivityNameFigure() {
			return fActivityNameFigure;
		}

		/**
		 * @generated
		 */
		public RectangleFigure getResponsibleFigure() {
			return fResponsibleFigure;
		}

		/**
		 * @generated
		 */
		public RectangleFigure getEditorsFigure() {
			return fEditorsFigure;
		}

		/**
		 * @generated
		 */
		public RectangleFigure getReadersFigure() {
			return fReadersFigure;
		}

		/**
		 * @generated
		 */
		public RectangleFigure getProcessFigure() {
			return fProcessFigure;
		}

	}

	/**
	 * @generated
	 */
	static final Color THIS_FORE = new Color(null, 0, 118, 168);

	/**
	 * @generated
	 */
	static final Color THIS_BACK = new Color(null, 225, 247, 255);

}
