/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.tests;

import es.upv.dsic.issi.dplfw.core.util.IIEQueryBuilder;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsFactory;
import es.upv.dsic.issi.dplfw.infoelements.TextIE;
import es.upv.dsic.issi.dplfw.repomanager.CDOSessionUtil;
import es.upv.dsic.issi.dplfw.repomanager.IRepositoryManager;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryLocation;
import es.upv.dsic.issi.dplfw.repomanager.UnknownRepositoryException;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.util.ConcurrentAccessException;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.Assert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DplfwRepositoryTest {
    private static final String REPO_NAME = "REPO_NAME";
    private static final String RESOURCE_NAME = "ROOT";
    private static final String TITLE = "TEST";
    private static final String TEMP_DIR = "temp" + EcoreUtil.generateUUID();

    DplfwRepositoryTest() {
    }

    @AfterAll
    public static void cleanupTemp() {
        FileUtils.deleteQuietly((File)new File(TEMP_DIR));
    }

    @Test
    void testCreateSessionUsingRepoManager() throws UnknownRepositoryException, CommitException, IOException {
        String uuid = UUID.randomUUID().toString();
        File file = DplfwRepositoryTest.createRandomTempFile();
        IRepositoryManager.INSTANCE.addRepository(new RepositoryLocation(uuid, file.toURI()));
        CDOSession session = null;
        try {
            session = IRepositoryManager.INSTANCE.openSession(uuid);
            Assert.assertTrue((!session.isClosed() ? 1 : 0) != 0);
        }
        finally {
            DplfwRepositoryTest.close(session);
        }
        IRepositoryManager.INSTANCE.deleteRepository(uuid);
    }

    @Test
    void testCreateSessionRaw() throws UnknownRepositoryException, CommitException, IOException {
        File file = DplfwRepositoryTest.createRandomTempFile();
        CDOSession session = null;
        try {
            session = CDOSessionUtil.createLocalCDOSession((File)file, (String)REPO_NAME);
            Assert.assertTrue((!session.isClosed() ? 1 : 0) != 0);
        }
        finally {
            DplfwRepositoryTest.close(session);
        }
    }

    @Test
    void testAddInfoElement() throws UnknownRepositoryException, CommitException, IOException {
        File file = DplfwRepositoryTest.createRandomTempFile();
        DplfwRepositoryTest.addInfoElement(file);
    }

    @Test
    void testInfoElementSaved() throws UnknownRepositoryException, CommitException, IOException {
        File file = DplfwRepositoryTest.createRandomTempFile();
        DplfwRepositoryTest.addInfoElement(file);
        CDOSession session = null;
        try {
            session = CDOSessionUtil.createLocalCDOSession((File)file, (String)REPO_NAME);
            CDOTransaction transaction = null;
            try {
                transaction = session.openTransaction();
                CDOResource resource = transaction.getResource(RESOURCE_NAME);
                Assertions.assertEquals((int)resource.getContents().size(), (int)1);
                Assert.assertTrue((boolean)(resource.getContents().get(0) instanceof InfoElement));
                Assertions.assertEquals((Object)((InfoElement)resource.getContents().get(0)).getTitle(), (Object)TITLE);
            }
            finally {
                DplfwRepositoryTest.close(transaction);
            }
        }
        finally {
            DplfwRepositoryTest.close(session);
        }
    }

    @Test
    void testOclQuery() throws UnknownRepositoryException, CommitException, IOException {
        File file = DplfwRepositoryTest.createRandomTempFile();
        DplfwRepositoryTest.addInfoElement(file);
        CDOSession session = null;
        try {
            session = CDOSessionUtil.createLocalCDOSession((File)file, (String)REPO_NAME);
            CDOTransaction transaction = null;
            try {
                transaction = session.openTransaction();
                CDOQuery query = transaction.createQuery("ocl", "infoelements::InfoElement.allInstances()->select(ie | ie.title = title)->asOrderedSet()->first()");
                query.setParameter("title", (Object)TITLE);
                InfoElement ie = (InfoElement)query.getResultValue(InfoElement.class);
                Assertions.assertEquals((Object)TITLE, (Object)ie.getTitle());
            }
            finally {
                DplfwRepositoryTest.close(transaction);
            }
        }
        finally {
            DplfwRepositoryTest.close(session);
        }
    }

    @Test
    void testHibernateQuery() throws UnknownRepositoryException, CommitException, IOException {
        File file = DplfwRepositoryTest.createRandomTempFile();
        DplfwRepositoryTest.addInfoElement(file);
        CDOSession session = null;
        try {
            session = CDOSessionUtil.createLocalCDOSession((File)file, (String)REPO_NAME);
            CDOTransaction transaction = null;
            try {
                transaction = session.openTransaction();
                String storeType = transaction.getSession().getRepositoryInfo().getStoreType();
                IIEQueryBuilder ieQueryBuilder = IIEQueryBuilder.FACTORY.createQueryFor((String)storeType).where().is("title", TITLE);
                CDOQuery query = transaction.createQuery(ieQueryBuilder.language(), ieQueryBuilder.build());
                InfoElement ie = (InfoElement)query.getResultValue(InfoElement.class);
                Assertions.assertEquals((Object)TITLE, (Object)ie.getTitle());
            }
            finally {
                DplfwRepositoryTest.close(transaction);
            }
        }
        finally {
            DplfwRepositoryTest.close(session);
        }
    }

    @Test
    void testHibernateQueryBuilder() throws UnknownRepositoryException, CommitException, IOException {
        File file = DplfwRepositoryTest.createRandomTempFile();
        DplfwRepositoryTest.addInfoElement(file);
        CDOSession session = null;
        try {
            session = CDOSessionUtil.createLocalCDOSession((File)file, (String)REPO_NAME);
            CDOTransaction transaction = null;
            try {
                transaction = session.openTransaction();
                CDOQuery query = transaction.createQuery("hql", "from InfoElement ie where ie.title like :title");
                query.setParameter("title", (Object)TITLE);
                InfoElement ie = (InfoElement)query.getResultValue(InfoElement.class);
                Assertions.assertEquals((Object)TITLE, (Object)ie.getTitle());
            }
            finally {
                DplfwRepositoryTest.close(transaction);
            }
        }
        finally {
            DplfwRepositoryTest.close(session);
        }
    }

    private static File createRandomTempFile() {
        return new File(String.valueOf(TEMP_DIR) + "/cdo_repo" + EcoreUtil.generateUUID());
    }

    private static void addInfoElement(File file) throws ConcurrentAccessException, CommitException {
        CDOSession session = null;
        try {
            session = CDOSessionUtil.createLocalCDOSession((File)file, (String)REPO_NAME);
            CDOTransaction transaction = null;
            try {
                transaction = session.openTransaction();
                TextIE textIE = InfoelementsFactory.eINSTANCE.createTextIE();
                textIE.createUUID();
                textIE.setTitle(TITLE);
                transaction.getOrCreateResource(RESOURCE_NAME).getContents().add((Object)textIE);
                transaction.commit();
            }
            finally {
                DplfwRepositoryTest.close(transaction);
            }
        }
        finally {
            DplfwRepositoryTest.close(session);
        }
    }

    private static void close(CDOSession session) {
        if (session != null) {
            session.close();
        }
    }

    private static void close(CDOTransaction transaction) {
        if (transaction != null) {
            transaction.close();
        }
    }
}

