/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.repomanager;

import es.upv.dsic.issi.dplfw.repomanager.CDOSessionUtil;
import es.upv.dsic.issi.dplfw.repomanager.IRepositoryManager;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryLocation;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryManagerPlugin;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryRegistryEvent;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryRegistryListener;
import es.upv.dsic.issi.dplfw.repomanager.UnknownRepositoryException;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.net4j.connector.ConnectorException;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

class RepositoryManager
implements IEclipsePreferences.IPreferenceChangeListener,
IRepositoryManager {
    private Map<String, RepositoryLocation> repositories;
    private List<CDOSession> activeSessions = Collections.synchronizedList(new ArrayList());
    private Set<RepositoryRegistryListener> repositoryListeners = Collections.synchronizedSet(new HashSet());

    RepositoryManager() {
        this.repositories = Collections.synchronizedMap(new LinkedHashMap());
        if (RepositoryManagerPlugin.getDefault() != null) {
            IEclipsePreferences prefs = (IEclipsePreferences)RepositoryManagerPlugin.getDefault().getPreferences();
            prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            try {
                String[] stringArray = prefs.keys();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    String location = prefs.get(key, null);
                    this.repositories.put(key, new RepositoryLocation(key, location));
                    ++n2;
                }
            }
            catch (URISyntaxException | BackingStoreException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void addRepository(RepositoryLocation repository) {
        this.repositories.put(repository.getUuid(), repository);
        if (RepositoryManagerPlugin.getDefault() != null) {
            Preferences prefs = RepositoryManagerPlugin.getDefault().getPreferences();
            try {
                prefs.put(repository.getUuid(), repository.toStringURI());
                prefs.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void deleteRepository(String uuid) {
        this.repositories.remove(uuid);
        if (RepositoryManagerPlugin.getDefault() != null) {
            Preferences prefs = RepositoryManagerPlugin.getDefault().getPreferences();
            try {
                prefs.remove(uuid);
                prefs.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isKnownRepository(String uuid) {
        return this.getRepositoriesMap().get(uuid) != null;
    }

    @Override
    public RepositoryLocation getRepository(String uuid) throws UnknownRepositoryException {
        RepositoryLocation location = null;
        location = this.getRepositoriesMap().get(uuid);
        if (location != null) {
            return location;
        }
        throw new UnknownRepositoryException(uuid);
    }

    @Override
    public String getRepositoryUUID(String locationURI) throws URISyntaxException, ConnectorException, UnknownHostException {
        for (RepositoryLocation repositoryLocation : this.getRepositoriesMap().values()) {
            if (!repositoryLocation.toStringURI().equals(locationURI)) continue;
            return repositoryLocation.getUuid();
        }
        URI uri = new URI(locationURI);
        InetAddress.getByName(uri.getHost());
        String protocol = uri.getScheme();
        String host = uri.getHost();
        int port = uri.getPort();
        String repositoryName = !StringUtils.equals((CharSequence)protocol, (CharSequence)"file") && uri.getPath().startsWith("/") ? uri.getPath().substring(1) : uri.getPath();
        String username = "";
        String password = "";
        if (StringUtils.isNotBlank((CharSequence)uri.getUserInfo())) {
            String[] userinfo = uri.getUserInfo().split(":");
            username = userinfo.length > 0 ? userinfo[0] : "";
            password = userinfo.length > 1 ? userinfo[1] : "";
        }
        CDOSession session = this.openSessionInternal(protocol, host, port, repositoryName, username, password);
        String uuid = session.getRepositoryInfo().getUUID();
        session.close();
        return uuid;
    }

    @Override
    public Collection<RepositoryLocation> getRepositories() {
        return Collections.unmodifiableCollection(this.getRepositoriesMap().values());
    }

    @Override
    public Map<String, RepositoryLocation> getRepositoriesMap() {
        return Collections.unmodifiableMap(this.repositories);
    }

    @Override
    public CDOSession openSession(String uuid) throws UnknownRepositoryException {
        RepositoryLocation location = this.getRepository(uuid);
        return this.openSessionInternal(location.getProtocol(), location.getHost(), location.getPort(), location.getRepositoryName(), location.getUsername(), location.getPassword());
    }

    protected CDOSession openSessionInternal(String protocol, String host, int port, String repositoryName, String username, String password) {
        CDOSession session;
        CDOSession cDOSession = StringUtils.equals((CharSequence)"tcp", (CharSequence)protocol) ? CDOSessionUtil.createRemoteCDOSession(host, port, repositoryName, username, password) : (session = StringUtils.equals((CharSequence)"file", (CharSequence)protocol) ? CDOSessionUtil.createLocalCDOSession(new File(repositoryName), new File(repositoryName).getName()) : null);
        if (!session.isClosed()) {
            this.activeSessions.add(session);
        }
        session.addListener((IListener)new LifecycleEventAdapter(){

            protected void onDeactivated(ILifecycle lifecycle) {
                RepositoryManager.this.activeSessions.remove(session);
            }
        });
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        RepositoryLocation location = null;
        if (event.getNewValue() == null) {
            location = this.repositories.get(event.getKey());
            this.repositories.remove(event.getKey());
        } else {
            try {
                location = new RepositoryLocation(event.getKey(), (String)event.getNewValue());
                this.repositories.put(event.getKey(), location);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        Set<RepositoryRegistryListener> set = this.repositoryListeners;
        synchronized (set) {
            for (RepositoryRegistryListener listener : this.repositoryListeners) {
                RepositoryRegistryEvent.Type type = null;
                if (event.getNewValue() == null) {
                    type = RepositoryRegistryEvent.Type.DELETION;
                } else if (event.getOldValue() == null) {
                    type = RepositoryRegistryEvent.Type.ADDITION;
                } else if (event.getOldValue() != event.getNewValue()) {
                    type = RepositoryRegistryEvent.Type.MODIFICATION;
                }
                listener.repositoryRegistryChange(new RepositoryRegistryEvent(location, type));
            }
        }
    }

    @Override
    public List<CDOSession> getActiveSessions() {
        return Collections.unmodifiableList(this.activeSessions);
    }

    @Override
    public void addRepositoryRegistryListener(RepositoryRegistryListener listener) {
        this.repositoryListeners.add(listener);
    }

    @Override
    public void removeRepositoryRegistryListener(RepositoryRegistryListener listener) {
        this.repositoryListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        this.repositoryListeners = null;
        List<CDOSession> list = this.activeSessions;
        synchronized (list) {
            for (CDOSession session : this.activeSessions) {
                session.close();
            }
        }
        this.activeSessions = null;
        super.finalize();
    }
}

