/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.repomanager;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang3.StringUtils;

public class RepositoryLocation {
    private String uuid;
    private String protocol;
    private String host;
    private int port;
    private String repositoryName;
    private String username;
    private String password;

    public RepositoryLocation(String uuid, String locationUri) throws URISyntaxException {
        this(uuid, new URI(locationUri));
    }

    public RepositoryLocation(String uuid, URI location) {
        this(uuid, location.getScheme(), location.getHost(), location.getPort(), !StringUtils.equals((CharSequence)location.getScheme(), (CharSequence)"file") && location.getPath().startsWith("/") ? location.getPath().substring(1) : location.getPath(), location.getUserInfo() != null && location.getUserInfo().split(":").length > 0 ? location.getUserInfo().split(":")[0] : "", location.getUserInfo() != null && location.getUserInfo().split(":").length > 1 ? location.getUserInfo().split(":")[1] : "");
    }

    public RepositoryLocation(String uuid, String protocol, String host, int port, String repositoryName) {
        this.uuid = uuid;
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.repositoryName = repositoryName;
    }

    public RepositoryLocation(String uuid, String protocol, String host, int port, String repositoryName, String username, String password) {
        this(uuid, protocol, host, port, repositoryName);
        this.username = username;
        this.password = password;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getConnectorDescriptor() {
        return String.valueOf(this.getHost()) + ":" + this.getPort();
    }

    public String toStringURI() {
        if (StringUtils.equals((CharSequence)this.protocol, (CharSequence)"file")) {
            return String.valueOf(this.protocol) + ":" + this.repositoryName;
        }
        if (StringUtils.isNotBlank((CharSequence)this.username) || StringUtils.isNotBlank((CharSequence)this.password)) {
            return String.valueOf(this.protocol) + "://" + StringUtils.defaultString((String)this.username) + ":" + StringUtils.defaultString((String)this.password) + "@" + this.host + ":" + this.port + "/" + this.repositoryName;
        }
        return String.valueOf(this.protocol) + "://" + this.host + ":" + this.port + "/" + this.repositoryName;
    }
}

