/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.repomanager;

import java.io.File;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.hibernate.CDOHibernateUtil;
import org.eclipse.emf.cdo.server.hibernate.IHibernateMappingProvider;
import org.eclipse.emf.cdo.server.hibernate.IHibernateStore;
import org.eclipse.emf.cdo.server.hibernate.teneo.TeneoUtil;
import org.eclipse.emf.cdo.server.net4j.CDONet4jServerUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.jvm.IJVMAcceptor;
import org.eclipse.net4j.jvm.IJVMConnector;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.tcp.ITCPConnector;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.security.PasswordCredentialsProvider;

public class CDOSessionUtil {
    public static CDOSession createRemoteCDOSession(String host, int port, String repositoryName, String username, String password) {
        IManagedContainer container = ContainerUtil.createContainer();
        Net4jUtil.prepareContainer((IManagedContainer)container);
        TCPUtil.prepareContainer((IManagedContainer)container);
        CDONet4jUtil.prepareContainer((IManagedContainer)container);
        container.activate();
        CDONet4jSessionConfiguration configuration = CDONet4jUtil.createNet4jSessionConfiguration();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            PasswordCredentialsProvider credentialsProvider = new PasswordCredentialsProvider(username, password);
            configuration.setCredentialsProvider((IPasswordCredentialsProvider)credentialsProvider);
        }
        ITCPConnector connector = TCPUtil.getConnector((IManagedContainer)container, (String)(String.valueOf(host) + ":" + port));
        configuration.setConnector((IConnector)connector);
        configuration.setRepositoryName(repositoryName);
        CDONet4jSession session = null;
        try {
            session = configuration.openNet4jSession();
            session.addListener((IListener)new LifecycleEventAdapter((IConnector)connector, container){
                private final /* synthetic */ IConnector val$connector;
                private final /* synthetic */ IManagedContainer val$container;
                {
                    this.val$connector = iConnector;
                    this.val$container = iManagedContainer;
                }

                protected void onDeactivated(ILifecycle lifecycle) {
                    this.val$connector.close();
                    this.val$container.deactivate();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            connector.close();
            container.deactivate();
        }
        return session;
    }

    public static CDOSession createLocalCDOSession(File file, String repositoryName) {
        IHibernateStore store = CDOHibernateUtil.createStore((IHibernateMappingProvider)TeneoUtil.createMappingProvider());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("overrideUUID", "");
        props.put("supportingAudits", "false");
        props.put("hibernate.hbm2ddl.auto", "update");
        props.put("hibernate.dialect", "org.hibernate.dialect.H2Dialect");
        props.put("hibernate.connection.driver_class", "org.h2.Driver");
        props.put("hibernate.connection.url", "jdbc:h2:file:" + file.getAbsolutePath());
        IManagedContainer container = ContainerUtil.createContainer();
        Net4jUtil.prepareContainer((IManagedContainer)container);
        JVMUtil.prepareContainer((IManagedContainer)container);
        CDONet4jUtil.prepareContainer((IManagedContainer)container);
        CDONet4jServerUtil.prepareContainer((IManagedContainer)container);
        container.activate();
        IRepository repository = CDOServerUtil.createRepository((String)repositoryName, (IStore)store, props);
        CDOServerUtil.addRepository((IManagedContainer)container, (IRepository)repository);
        IJVMAcceptor acceptor = JVMUtil.getAcceptor((IManagedContainer)container, (String)"default");
        IJVMConnector connector = JVMUtil.getConnector((IManagedContainer)container, (String)"default");
        CDONet4jSessionConfiguration configuration = CDONet4jUtil.createNet4jSessionConfiguration();
        configuration.setConnector((IConnector)connector);
        configuration.setRepositoryName(repositoryName);
        CDONet4jSession session = null;
        try {
            session = configuration.openNet4jSession();
            session.addListener((IListener)new LifecycleEventAdapter((IConnector)connector, container){
                private final /* synthetic */ IConnector val$connector;
                private final /* synthetic */ IManagedContainer val$container;
                {
                    this.val$connector = iConnector;
                    this.val$container = iManagedContainer;
                }

                protected void onDeactivated(ILifecycle lifecycle) {
                    this.val$connector.close();
                    this.val$container.deactivate();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            connector.close();
            container.deactivate();
        }
        return session;
    }
}

