package es.upv.dsic.issi.dplfw.repomanager;

import java.net.URI;
import java.net.URISyntaxException;

import org.apache.commons.lang3.StringUtils;

public class RepositoryLocation {

	private String uuid;	
	private String protocol;
	private String host;
	private int port;
	private String repositoryName;
	private String username;
	private String password;

	
	public RepositoryLocation(String uuid, String locationUri) throws URISyntaxException {
		this(uuid, new URI(locationUri));
	}
	
	public RepositoryLocation(String uuid, URI location) {
		this(uuid, location.getScheme(), location.getHost(), location.getPort(),
				!StringUtils.equals(location.getScheme(), "file") && location.getPath().startsWith("/") ? location.getPath().substring(1) : location.getPath(),
				location.getUserInfo() != null && location.getUserInfo().split(":").length > 0 ? location.getUserInfo().split(":")[0] : "",
				location.getUserInfo() != null && location.getUserInfo().split(":").length > 1 ? location.getUserInfo().split(":")[1] : "");
	}

	public RepositoryLocation(String uuid, String protocol, String host, int port, String repositoryName) {
		this.uuid = uuid;
		this.protocol = protocol;
		this.host = host;
		this.port = port;
		this.repositoryName = repositoryName;
	}

	public RepositoryLocation(String uuid, String protocol, String host, int port, String repositoryName, String username, String password) {
		this(uuid, protocol, host, port, repositoryName);
		this.username = username;
		this.password = password;
	}

	
	/**
	 * @return the protocol
	 */
	public String getProtocol() {
		return protocol;
	}

	/**
	 * @return the host
	 */
	public String getHost() {
		return host;
	}

	/**
	 * @return the port
	 */
	public int getPort() {
		return port;
	}

	/**
	 * @return the repositoryName
	 */
	public String getRepositoryName() {
		return repositoryName;
	}

	/**
	 * @return the uuid
	 */
	public String getUuid() {
		return uuid;
	}
	
	/**
	 * @return the username
	 */
	public String getUsername() {
		return username;
	}

	/**
	 * @return the password
	 */
	public String getPassword() {
		return password;
	}

	/**
	 * Returns the connector descriptor (i.e., host + ":" +  port)
	 * @return the connector descriptor
	 */
	public String getConnectorDescriptor() {
		return getHost() + ":" + getPort();
	}

	/**
	 * @return the location {@link URI} as {@link String}
	 */
	public String toStringURI() {
		if (StringUtils.equals(protocol, "file")){
			return protocol + ":" + repositoryName; 
		} else if (StringUtils.isNotBlank(username) || StringUtils.isNotBlank(password)) {
			return protocol + "://" + StringUtils.defaultString(username) + ":" + StringUtils.defaultString(password) + "@" + host + ":" + port + "/" + repositoryName;
		} else {
			return protocol + "://" + host + ":" + port + "/" + repositoryName;
		}
	}
}