/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.repomanager.ui.wizards;

import es.upv.dsic.issi.dplfw.repomanager.IRepositoryManager;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryLocation;
import es.upv.dsic.issi.dplfw.repomanager.ui.views.providers.RepositoriesLabelProvider;
import es.upv.dsic.issi.dplfw.repomanager.ui.wizards.WizardValues;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SelectRepositoryWizardPage
extends WizardPage {
    private TableViewer viewer;
    private WizardValues values;

    public SelectRepositoryWizardPage(WizardValues values) {
        super("SelectRepositoryWizardPage");
        this.setTitle("Select Repository Location");
        this.setDescription("Select a repository location");
        this.setPageComplete(false);
        this.values = values;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.setControl((Control)composite);
        this.viewer = new TableViewer(composite, 2052);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput((Object)IRepositoryManager.INSTANCE.getRepositories());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RepositoriesLabelProvider());
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.addListeners();
    }

    private void addListeners() {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SelectRepositoryWizardPage.this.getSelectedLocation() != null) {
                    SelectRepositoryWizardPage.this.values.setRepositoryLocation(SelectRepositoryWizardPage.this.getSelectedLocation());
                    SelectRepositoryWizardPage.this.setPageComplete(true);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectRepositoryWizardPage.this.getContainer().showPage(SelectRepositoryWizardPage.this.getNextPage());
            }
        });
    }

    public RepositoryLocation getSelectedLocation() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return (RepositoryLocation)selection.getFirstElement();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.viewer.setInput((Object)IRepositoryManager.INSTANCE.getRepositories());
            this.viewer.refresh();
        }
    }
}

