/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.repomanager.ui.wizards;

import es.upv.dsic.issi.dplfw.dfm.Reference;
import es.upv.dsic.issi.dplfw.dfmconf.CriterionAttributeConfiguration;
import es.upv.dsic.issi.dplfw.repomanager.IRepositoryManager;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryLocation;
import es.upv.dsic.issi.dplfw.repomanager.ui.wizards.NoRepositoriesWizardPage;
import es.upv.dsic.issi.dplfw.repomanager.ui.wizards.ReferenceMatchingWizardPage;
import es.upv.dsic.issi.dplfw.repomanager.ui.wizards.SearchInfoElementWizardPage;
import es.upv.dsic.issi.dplfw.repomanager.ui.wizards.SelectRepositoryWizardPage;
import es.upv.dsic.issi.dplfw.repomanager.ui.wizards.WizardValues;
import java.util.Collection;
import org.apache.commons.collections.map.MultiValueMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class SelectInfoElementWizard
extends Wizard {
    private WizardValues values = new WizardValues();
    SelectRepositoryWizardPage reposPage;
    SearchInfoElementWizardPage searchPage;
    ReferenceMatchingWizardPage referencePage;

    public SelectInfoElementWizard(Object obj) {
        this(null, obj);
    }

    public SelectInfoElementWizard(RepositoryLocation location, Object obj) {
        this.setWindowTitle("Select Info Element");
        if (location != null) {
            this.values.setRepositoryLocation(location);
        }
        if (obj instanceof Reference) {
            this.values.setReference((Reference)obj);
        } else if (obj instanceof CriterionAttributeConfiguration) {
            this.values.setCriterionAttributeConfiguration((CriterionAttributeConfiguration)obj);
        }
    }

    public boolean performFinish() {
        return true;
    }

    public void addPages() {
        if (this.getRepositoriesFromRegistry().size() == 0) {
            this.addPage((IWizardPage)new NoRepositoriesWizardPage(this.values));
        }
        this.reposPage = new SelectRepositoryWizardPage(this.values);
        this.searchPage = new SearchInfoElementWizardPage(this.values);
        this.referencePage = new ReferenceMatchingWizardPage(this.values);
        if (this.getRepositoriesFromRegistry().size() > 1) {
            this.addPage((IWizardPage)this.reposPage);
        } else if (this.getRepositoriesFromRegistry().size() == 1) {
            this.values.setRepositoryLocation((RepositoryLocation)this.getRepositoriesFromRegistry().toArray()[0]);
        }
        this.addPage((IWizardPage)this.searchPage);
        this.addPage((IWizardPage)this.referencePage);
    }

    private Collection<RepositoryLocation> getRepositoriesFromRegistry() {
        return IRepositoryManager.INSTANCE.getRepositories();
    }

    public URI getInfoElementUri() {
        return this.values.getInfoElementUri();
    }

    public Object getReference() {
        return this.values.getReference();
    }

    public MultiValueMap getVarAttrRefMap() {
        return this.values.getMapVariableAttributeReference();
    }

    public boolean canFinish() {
        return this.values.getInfoElementUri() != null;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page.equals((Object)this.reposPage)) {
            return this.searchPage;
        }
        if (page.equals((Object)this.searchPage)) {
            if (!this.values.getVariableIEContentsList().isEmpty() && this.values.getCriterionAttributeConfiguration() != null) {
                this.referencePage.onEnterPage();
                return this.referencePage;
            }
            return null;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getStartingPage() {
        if (this.values.getRepositoryLocation() == null) {
            return this.reposPage;
        }
        return this.searchPage;
    }
}

