/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.repomanager.ui.wizards;

import es.upv.dsic.issi.dplfw.core.util.IIEQueryBuilder;
import es.upv.dsic.issi.dplfw.dfmconf.Criterion;
import es.upv.dsic.issi.dplfw.dfmconf.CriterionAttributeConfiguration;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsPackage;
import es.upv.dsic.issi.dplfw.infoelements.VariableIEContents;
import es.upv.dsic.issi.dplfw.repomanager.IRepositoryManager;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryLocation;
import es.upv.dsic.issi.dplfw.repomanager.UnknownRepositoryException;
import es.upv.dsic.issi.dplfw.repomanager.ui.RepositoryManagerUIPlugin;
import es.upv.dsic.issi.dplfw.repomanager.ui.actions.EditIEViewerAction;
import es.upv.dsic.issi.dplfw.repomanager.ui.views.providers.RepositoriesLabelProvider;
import es.upv.dsic.issi.dplfw.repomanager.ui.wizards.WizardValues;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;

public class SearchInfoElementWizardPage
extends WizardPage {
    private WizardValues values;
    private CDOSession session;
    private CDOView view;
    private TableViewer viewer;
    private List<InfoElement> searchResults = new ArrayList<InfoElement>();
    private Text searchText;
    private Action editIEAction;
    private Button searchButton;
    private Text descriptionText;

    public SearchInfoElementWizardPage(WizardValues values) {
        super("SearchInfoElementWizardPage");
        this.setTitle("Search Info Element");
        this.setDescription("Search Info Element");
        this.values = values;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.createControlUI(parent);
        this.addListeners(this.searchButton);
        this.makeActions();
        this.hookContextMenu();
    }

    private void createControlUI(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)composite);
        Label searchLabel = new Label(composite, 0);
        searchLabel.setText("Insert search string:");
        searchLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.searchText = new Text(composite, 2048);
        this.searchText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.searchButton = new Button(composite, 8);
        this.searchButton.setText("&Search");
        Label hintLabel = new Label(composite, 0);
        hintLabel.setText("(% = any string)");
        hintLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.viewer = new TableViewer(composite, 2052);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setInput(this.searchResults);
        this.viewer.setLabelProvider((IBaseLabelProvider)new RepositoriesLabelProvider());
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.heightHint = 250;
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.viewer.getControl().setEnabled(false);
        this.descriptionText = new Text(composite, 2626);
        this.descriptionText.setEditable(false);
        gridData = new GridData(4, 1, true, false, 2, 1);
        gridData.heightHint = 45;
        this.descriptionText.setLayoutData((Object)gridData);
    }

    private void addListeners(Button searchButton) {
        searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchInfoElementWizardPage.this.performSearch(SearchInfoElementWizardPage.this.searchText.getText());
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                InfoElement infoElement = SearchInfoElementWizardPage.this.getSelectedInfoElement();
                if (infoElement != null) {
                    SearchInfoElementWizardPage.this.values.setInfoElementUri(EcoreUtil.getURI((EObject)infoElement));
                    SearchInfoElementWizardPage.this.values.addVariableIEContents((Collection<VariableIEContents>)infoElement.getVariables());
                    SearchInfoElementWizardPage.this.showIEDescription(infoElement.getDescription());
                    SearchInfoElementWizardPage.this.setPageComplete(true);
                }
            }
        });
        this.searchText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                SearchInfoElementWizardPage.this.performSearch(SearchInfoElementWizardPage.this.searchText.getText());
            }
        });
    }

    private void hookContextMenu() {
        MenuManager manager = new MenuManager();
        Menu menu = manager.createContextMenu(this.viewer.getControl());
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection;
                if (SearchInfoElementWizardPage.this.viewer.getSelection().isEmpty()) {
                    return;
                }
                if (SearchInfoElementWizardPage.this.viewer.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)SearchInfoElementWizardPage.this.viewer.getSelection()).getFirstElement() instanceof InfoElement) {
                    manager.add((IAction)SearchInfoElementWizardPage.this.editIEAction);
                }
            }
        });
        manager.setRemoveAllWhenShown(true);
        this.viewer.getControl().setMenu(menu);
    }

    private void makeActions() {
        this.editIEAction = new EditIEViewerAction((Viewer)this.viewer);
        this.editIEAction.setText("&Edit");
        this.editIEAction.setToolTipText("Opens the Info Element with the default editor");
        this.editIEAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)RepositoryManagerUIPlugin.getDefault().getImageRegistry().get("IMG_ELCL16_EDIT")));
    }

    protected void performSearch(final String text) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Searching...", 2);
                monitor.subTask("Connecting to repository");
                SearchInfoElementWizardPage.this.getView();
                monitor.worked(1);
                monitor.subTask("Retrieving results");
                SearchInfoElementWizardPage.this.searchResults.clear();
                if (SearchInfoElementWizardPage.this.values.getCriterionAttributeConfiguration() == null) {
                    SearchInfoElementWizardPage.this.searchResults.addAll((List)SearchInfoElementWizardPage.this.searchString(text));
                } else {
                    SearchInfoElementWizardPage.this.searchResults.addAll((List)SearchInfoElementWizardPage.this.searchStringByCriterion(text));
                }
                monitor.worked(1);
                monitor.subTask("Refreshing viewer");
                SearchInfoElementWizardPage.this.getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        SearchInfoElementWizardPage.this.viewer.getControl().setEnabled(true);
                        SearchInfoElementWizardPage.this.viewer.refresh();
                    }
                });
                monitor.worked(1);
                monitor.done();
            }
        };
        try {
            dialog.run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void showIEDescription(final String description) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!SearchInfoElementWizardPage.this.descriptionText.isDisposed()) {
                    SearchInfoElementWizardPage.this.descriptionText.setText(description != null ? description : "");
                }
            }
        });
    }

    protected Collection<InfoElement> searchString(String searchString) {
        IIEQueryBuilder ieQueryBuilder = IIEQueryBuilder.FACTORY.createQueryFor((String)this.view.getSession().getRepositoryInfo().getStoreType()).where().containsSubstring("description", searchString).or().containsSubstring("title", searchString);
        CDOQuery query = this.view.createQuery(ieQueryBuilder.language(), ieQueryBuilder.build());
        return query.getResult();
    }

    protected Collection<InfoElement> searchStringByCriterion(String searchString) {
        return this.handlerCriterionAttributeData(this.values.getCriterionAttributeConfiguration());
    }

    private Collection<InfoElement> handlerCriterionAttributeData(CriterionAttributeConfiguration cAttr) {
        IIEQueryBuilder ieQueryBuilder = IIEQueryBuilder.FACTORY.createQueryFor((String)this.view.getSession().getRepositoryInfo().getStoreType());
        int i = 0;
        while (i < cAttr.getCriteria().size()) {
            Criterion c = (Criterion)cAttr.getCriteria().get(i);
            ieQueryBuilder = i == 0 ? ieQueryBuilder.where() : ieQueryBuilder.and();
            EStructuralFeature esf = InfoelementsPackage.eINSTANCE.getInfoElement().getEStructuralFeature(c.getMetadataElement().getName());
            ieQueryBuilder = esf.getUpperBound() == 1 ? ieQueryBuilder.is(c.getMetadataElement().getName(), c.getValue()) : ieQueryBuilder.contains(c.getMetadataElement().getName(), c.getValue());
            ++i;
        }
        CDOQuery query = this.view.createQuery(ieQueryBuilder.language(), ieQueryBuilder.build());
        return query.getResult();
    }

    protected CDOView getView() {
        if (this.view == null) {
            try {
                this.session = IRepositoryManager.INSTANCE.openSession(this.getLocation().getUuid());
                this.view = this.session.openView();
            }
            catch (UnknownRepositoryException e) {
                e.printStackTrace();
            }
        }
        return this.view;
    }

    protected RepositoryLocation getLocation() {
        return this.values.getRepositoryLocation();
    }

    protected InfoElement getSelectedInfoElement() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return (InfoElement)selection.getFirstElement();
    }

    public void dispose() {
        if (this.view != null && !this.view.isClosed()) {
            this.view.close();
        }
        if (this.session != null && !this.session.isClosed()) {
            this.session.close();
        }
        super.dispose();
    }
}

