/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.repomanager.ui.wizards;

import es.upv.dsic.issi.dplfw.core.ui.DplfwUiPlugin;
import es.upv.dsic.issi.dplfw.core.util.IIEQueryBuilder;
import es.upv.dsic.issi.dplfw.dfm.Attribute;
import es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;
import es.upv.dsic.issi.dplfw.dfm.Reference;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.VariableIEContents;
import es.upv.dsic.issi.dplfw.repomanager.IRepositoryManager;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryLocation;
import es.upv.dsic.issi.dplfw.repomanager.UnknownRepositoryException;
import es.upv.dsic.issi.dplfw.repomanager.ui.RepositoryManagerUIPlugin;
import es.upv.dsic.issi.dplfw.repomanager.ui.actions.EditIEViewerAction;
import es.upv.dsic.issi.dplfw.repomanager.ui.views.providers.RepositoriesLabelProvider;
import es.upv.dsic.issi.dplfw.repomanager.ui.wizards.WizardValues;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;

public class SearchInfoElementVariablesWizardPage
extends WizardPage {
    private WizardValues values;
    private CDOSession session;
    private CDOView view;
    private TableViewer viewerIE;
    private TableViewer viewerIEVar;
    private List<InfoElement> searchResults = new ArrayList<InfoElement>();
    private List<InfoElement> infoElementList = new ArrayList<InfoElement>();
    private boolean isDocumentFeatureModel;
    private Text searchText;
    private Action editIEAction;
    private Button searchButton;
    private Text descriptionText;

    public SearchInfoElementVariablesWizardPage(WizardValues values) {
        super("SearchInfoElementVariablesWizardPage");
        this.setTitle("Search Info Element Variables");
        this.setDescription("Search Info Element Variables");
        this.values = values;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.isDocumentFeatureModel = this.isDocumentFeatureModel(this.values.getReference());
        if (!this.isDocumentFeatureModel) {
            this.initializeInfoElementList(this.getContentDocumentFeatureByReference(this.values.getReference()));
        }
        this.createControlUI(parent);
        this.addListeners(this.searchButton);
        this.makeActions();
        this.hookContextMenu();
    }

    private boolean isDocumentFeatureModel(Reference reference) {
        Attribute attr = (Attribute)reference.eContainer();
        return attr.eContainer() instanceof DocumentFeatureModel;
    }

    private void createControlUI(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)composite);
        Label searchLabel = new Label(composite, 0);
        searchLabel.setText("Insert search string:");
        searchLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.searchText = new Text(composite, 2048);
        this.searchText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.searchButton = new Button(composite, 8);
        this.searchButton.setText("&Search");
        Label hintLabel = new Label(composite, 0);
        hintLabel.setText("(% = any string)");
        hintLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.viewerIE = new TableViewer(composite, 2052);
        this.viewerIE.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewerIE.setInput(this.searchResults);
        this.viewerIE.setLabelProvider((IBaseLabelProvider)new RepositoriesLabelProvider());
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.heightHint = 150;
        this.viewerIE.getControl().setLayoutData((Object)gridData);
        this.viewerIE.getControl().setEnabled(false);
        Label variableLabel = new Label(composite, 0);
        variableLabel.setText("Variables:");
        variableLabel.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.viewerIEVar = new TableViewer(composite, 2052);
        this.viewerIEVar.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewerIEVar.setLabelProvider((IBaseLabelProvider)new RepositoriesLabelProvider());
        GridData gridDataVar = new GridData(4, 4, true, true, 2, 1);
        gridData.heightHint = 100;
        this.viewerIEVar.getControl().setLayoutData((Object)gridDataVar);
        this.viewerIEVar.getControl().setEnabled(false);
        this.descriptionText = new Text(composite, 2626);
        this.descriptionText.setEditable(false);
        gridData = new GridData(4, 1, true, false, 2, 1);
        gridData.heightHint = 45;
        this.descriptionText.setLayoutData((Object)gridData);
    }

    private ContentDocumentFeature getContentDocumentFeatureByReference(Reference reference) {
        Attribute attr = (Attribute)reference.eContainer();
        return (ContentDocumentFeature)attr.eContainer();
    }

    private void initializeInfoElementList(ContentDocumentFeature cdf) {
        try {
            if (cdf.getInfoElementURI() != null) {
                InfoElement ie = this.loadInfoElement(cdf.getInfoElementURI());
                this.infoElementList.add(ie);
                for (ContentDocumentFeature child : cdf.getChildren()) {
                    this.fillInfoElementList(child);
                }
            }
        }
        catch (UnknownRepositoryException e) {
            DplfwUiPlugin.log((Throwable)e);
        }
    }

    private InfoElement loadInfoElement(URI infoElementUri) throws UnknownRepositoryException {
        String uuid = infoElementUri.host();
        CDOSession session = IRepositoryManager.INSTANCE.openSession(uuid);
        CDOView view = session.openView();
        InfoElement infoElement = (InfoElement)view.getRootResource().getEObject(infoElementUri.fragment());
        InfoElement infoElementCopy = (InfoElement)EcoreUtil.copy((EObject)infoElement);
        view.close();
        session.close();
        return infoElementCopy;
    }

    private void fillInfoElementList(ContentDocumentFeature cdf) {
        try {
            if (cdf.getInfoElementURI() != null) {
                InfoElement ie = this.loadInfoElement(cdf.getInfoElementURI());
                this.infoElementList.add(ie);
            }
            for (ContentDocumentFeature child : cdf.getChildren()) {
                this.fillInfoElementList(child);
            }
        }
        catch (UnknownRepositoryException e) {
            DplfwUiPlugin.log((Throwable)e);
        }
    }

    private void addListeners(Button searchButton) {
        searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchInfoElementVariablesWizardPage.this.performSearch(SearchInfoElementVariablesWizardPage.this.searchText.getText());
            }
        });
        this.viewerIE.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                InfoElement infoElement = SearchInfoElementVariablesWizardPage.this.getSelectedInfoElement();
                if (infoElement != null) {
                    System.out.println(EcoreUtil.getURI((EObject)infoElement));
                    SearchInfoElementVariablesWizardPage.this.values.setInfoElementUri(EcoreUtil.getURI((EObject)infoElement));
                    SearchInfoElementVariablesWizardPage.this.viewerIEVar.setInput((Object)infoElement.getVariables());
                    SearchInfoElementVariablesWizardPage.this.viewerIEVar.getControl().setEnabled(true);
                    SearchInfoElementVariablesWizardPage.this.showIEDescription(infoElement.getDescription());
                }
            }
        });
        this.viewerIEVar.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VariableIEContents variableIEContents = SearchInfoElementVariablesWizardPage.this.getSelectedInfoElementVariable();
                if (variableIEContents != null) {
                    SearchInfoElementVariablesWizardPage.this.values.setVariableIEContents(variableIEContents);
                    SearchInfoElementVariablesWizardPage.this.showIEDescription(variableIEContents.getDescription());
                    SearchInfoElementVariablesWizardPage.this.setPageComplete(true);
                }
            }
        });
        this.searchText.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                SearchInfoElementVariablesWizardPage.this.performSearch(SearchInfoElementVariablesWizardPage.this.searchText.getText());
            }
        });
    }

    private void hookContextMenu() {
        MenuManager manager = new MenuManager();
        Menu menu = manager.createContextMenu(this.viewerIE.getControl());
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection;
                if (SearchInfoElementVariablesWizardPage.this.viewerIE.getSelection().isEmpty()) {
                    return;
                }
                if (SearchInfoElementVariablesWizardPage.this.viewerIE.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)SearchInfoElementVariablesWizardPage.this.viewerIE.getSelection()).getFirstElement() instanceof InfoElement) {
                    manager.add((IAction)SearchInfoElementVariablesWizardPage.this.editIEAction);
                }
            }
        });
        manager.setRemoveAllWhenShown(true);
        this.viewerIE.getControl().setMenu(menu);
    }

    private void makeActions() {
        this.editIEAction = new EditIEViewerAction((Viewer)this.viewerIE);
        this.editIEAction.setText("&Edit");
        this.editIEAction.setToolTipText("Opens the Info Element with the default editor");
        this.editIEAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)RepositoryManagerUIPlugin.getDefault().getImageRegistry().get("IMG_ELCL16_EDIT")));
    }

    protected void performSearch(final String text) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Searching...", 2);
                monitor.subTask("Connecting to repository");
                SearchInfoElementVariablesWizardPage.this.getView();
                monitor.worked(1);
                monitor.subTask("Retrieving results");
                SearchInfoElementVariablesWizardPage.this.searchResults.clear();
                if (SearchInfoElementVariablesWizardPage.this.isDocumentFeatureModel) {
                    SearchInfoElementVariablesWizardPage.this.searchResults.addAll((List)SearchInfoElementVariablesWizardPage.this.searchString(text));
                } else {
                    SearchInfoElementVariablesWizardPage.this.searchResults.addAll(SearchInfoElementVariablesWizardPage.this.filterSearchResults((List)SearchInfoElementVariablesWizardPage.this.searchString(text), text));
                }
                monitor.worked(1);
                monitor.subTask("Refreshing viewer");
                SearchInfoElementVariablesWizardPage.this.getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        SearchInfoElementVariablesWizardPage.this.viewerIE.getControl().setEnabled(true);
                        SearchInfoElementVariablesWizardPage.this.viewerIE.refresh();
                    }
                });
                monitor.worked(1);
                monitor.done();
            }
        };
        try {
            dialog.run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private List<InfoElement> filterSearchResults(List<InfoElement> ieSearchList, String searchString) {
        ArrayList<InfoElement> aux = new ArrayList<InfoElement>();
        for (InfoElement ie : this.infoElementList) {
            if ((ie.getDescription() == null || !ie.getDescription().contains(searchString)) && (ie.getTitle() == null || !ie.getTitle().contains(searchString))) continue;
            for (InfoElement ieQresult : ieSearchList) {
                if (!ieQresult.getUuid().equals(ie.getUuid())) continue;
                aux.add(ieQresult);
            }
        }
        return aux;
    }

    protected void showIEDescription(final String description) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!SearchInfoElementVariablesWizardPage.this.descriptionText.isDisposed()) {
                    SearchInfoElementVariablesWizardPage.this.descriptionText.setText(description != null ? description : "");
                }
            }
        });
    }

    protected Collection<InfoElement> searchString(String searchString) {
        IIEQueryBuilder ieQueryBuilder = IIEQueryBuilder.FACTORY.createQueryFor((String)this.view.getSession().getRepositoryInfo().getStoreType()).where().containsSubstring("description", searchString).or().containsSubstring("title", searchString);
        CDOQuery query = this.view.createQuery(ieQueryBuilder.language(), ieQueryBuilder.build());
        return query.getResult();
    }

    protected CDOView getView() {
        if (this.view == null) {
            try {
                this.session = IRepositoryManager.INSTANCE.openSession(this.getLocation().getUuid());
                this.view = this.session.openView();
            }
            catch (UnknownRepositoryException e) {
                e.printStackTrace();
            }
        }
        return this.view;
    }

    protected RepositoryLocation getLocation() {
        return this.values.getRepositoryLocation();
    }

    protected InfoElement getSelectedInfoElement() {
        IStructuredSelection selection = (IStructuredSelection)this.viewerIE.getSelection();
        return (InfoElement)selection.getFirstElement();
    }

    protected VariableIEContents getSelectedInfoElementVariable() {
        IStructuredSelection selection = (IStructuredSelection)this.viewerIEVar.getSelection();
        return (VariableIEContents)selection.getFirstElement();
    }

    public void dispose() {
        super.dispose();
    }
}

