/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.repomanager.ui.wizards;

import es.upv.dsic.issi.dplfw.core.util.IIEQueryBuilder;
import es.upv.dsic.issi.dplfw.dfmconf.Reference;
import es.upv.dsic.issi.dplfw.dfmconf.VariableAttributeConfiguration;
import es.upv.dsic.issi.dplfw.dfmconf.provider.DfmconfItemProviderAdapterFactory;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.VariableIEContents;
import es.upv.dsic.issi.dplfw.repomanager.IRepositoryManager;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryLocation;
import es.upv.dsic.issi.dplfw.repomanager.UnknownRepositoryException;
import es.upv.dsic.issi.dplfw.repomanager.ui.RepositoryManagerUIPlugin;
import es.upv.dsic.issi.dplfw.repomanager.ui.actions.EditIEViewerAction;
import es.upv.dsic.issi.dplfw.repomanager.ui.wizards.WizardValues;
import java.util.Collection;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class ReferenceMatchingWizardPage
extends WizardPage {
    private WizardValues values;
    private CDOSession session;
    private CDOView view;
    private TableViewer variableInfoElementsView;
    private TableViewer variableAttributesView;
    private TableViewer referenceView;
    private Table variableInfoElementsTable;
    private Action editIEAction;
    private Text VariableInfoElementsDescriptionText;
    private Text VariableAttributesDescriptionText;
    private Button btnCreateReference;

    public ReferenceMatchingWizardPage(WizardValues values) {
        super("SearchInfoElementVariablesWizardPage");
        this.setTitle("Search Info Element Variables");
        this.setDescription("Search Info Element Variables");
        this.values = values;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.createControlUI(parent);
        this.addListeners();
        this.makeActions();
        this.hookContextMenu();
    }

    private void createControlUI(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)composite);
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new DfmconfItemProviderAdapterFactory());
        GridData data = new GridData(4, 128, true, false, 2, 1);
        Label variableIEsLabel = new Label(composite, 0);
        variableIEsLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        variableIEsLabel.setText("Variable InfoElements:");
        data = new GridData(4, 128, true, false, 2, 1);
        data.heightHint = 60;
        Label variableAttributes = new Label(composite, 0);
        variableAttributes.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        variableAttributes.setText("Variable Attributes:");
        this.variableInfoElementsView = new TableViewer(composite, 2052);
        this.variableInfoElementsTable = this.variableInfoElementsView.getTable();
        GridData gd_table = new GridData(4, 4, true, false, 1, 1);
        gd_table.heightHint = 100;
        this.variableInfoElementsTable.setLayoutData((Object)gd_table);
        this.variableInfoElementsView.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.variableAttributesView = new TableViewer(composite, 2052);
        Table table_1 = this.variableAttributesView.getTable();
        data = new GridData(4, 4, true, false, 1, 1);
        data.heightHint = 100;
        table_1.setLayoutData((Object)data);
        this.variableAttributesView.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.variableAttributesView.setLabelProvider((IBaseLabelProvider)new LabelProvider(adapterFactory){
            AdapterFactoryLabelProvider aflp;
            {
                this.aflp = new AdapterFactoryLabelProvider((AdapterFactory)composedAdapterFactory);
            }

            public Image getImage(Object element) {
                return this.aflp.getImage(element);
            }

            public String getText(Object element) {
                return ((VariableAttributeConfiguration)element).getAttribute().getIdName();
            }
        });
        GridData gridData = new GridData(4, 4, true, false, 1, 1);
        gridData.heightHint = 70;
        this.VariableInfoElementsDescriptionText = new Text(composite, 2626);
        this.VariableInfoElementsDescriptionText.setLayoutData((Object)gridData);
        this.VariableInfoElementsDescriptionText.setEditable(false);
        gridData = new GridData(4, 4, true, false, 1, 1);
        gridData.heightHint = 70;
        this.VariableAttributesDescriptionText = new Text(composite, 2626);
        this.VariableAttributesDescriptionText.setLayoutData((Object)gridData);
        this.VariableAttributesDescriptionText.setEditable(false);
        Label referenceLabel = new Label(composite, 0);
        referenceLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        referenceLabel.setText("References:");
        this.referenceView = new TableViewer(composite, 2052);
        Table referenceTable = this.referenceView.getTable();
        referenceTable.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.referenceView.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.referenceView.setLabelProvider((IBaseLabelProvider)new LabelProvider(adapterFactory){
            AdapterFactoryLabelProvider aflp;
            {
                this.aflp = new AdapterFactoryLabelProvider((AdapterFactory)composedAdapterFactory);
            }

            public Image getImage(Object element) {
                return this.aflp.getImage(element);
            }

            public String getText(Object element) {
                return ((Reference)element).getReferenceName();
            }
        });
        new Label(composite, 0);
        this.btnCreateReference = new Button(composite, 8);
        this.btnCreateReference.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.btnCreateReference.setText("Create reference");
        this.btnCreateReference.setEnabled(false);
    }

    public void onEnterPage() {
        this.variableInfoElementsView.setInput(this.values.getVariableIEContentsList());
        this.variableAttributesView.setInput(this.values.getVariableAttributeConfigurationList());
    }

    private void hookContextMenu() {
        MenuManager manager = new MenuManager();
        Menu menu = manager.createContextMenu(this.variableInfoElementsView.getControl());
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IStructuredSelection selection;
                if (ReferenceMatchingWizardPage.this.variableInfoElementsView.getSelection().isEmpty()) {
                    return;
                }
                if (ReferenceMatchingWizardPage.this.variableInfoElementsView.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)ReferenceMatchingWizardPage.this.variableInfoElementsView.getSelection()).getFirstElement() instanceof InfoElement) {
                    manager.add((IAction)ReferenceMatchingWizardPage.this.editIEAction);
                }
            }
        });
        manager.setRemoveAllWhenShown(true);
        this.variableInfoElementsView.getControl().setMenu(menu);
    }

    private void addListeners() {
        this.variableInfoElementsView.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VariableIEContents varIE = ReferenceMatchingWizardPage.this.getSelectedVariableInfoElement();
                if (varIE != null) {
                    ReferenceMatchingWizardPage.this.showVarIEDescription(varIE.getDescription());
                    ReferenceMatchingWizardPage.this.values.setVariableIEContentsSelected(varIE);
                    ReferenceMatchingWizardPage.this.enableCreateReferenceButton();
                }
            }
        });
        this.variableAttributesView.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VariableAttributeConfiguration varAttr = ReferenceMatchingWizardPage.this.getSelectedVariableAttribute();
                if (varAttr != null) {
                    ReferenceMatchingWizardPage.this.showVarAttrDescription(varAttr.getAttribute().getDescription());
                    ReferenceMatchingWizardPage.this.values.setCriterionAttributeConfigurationSelected(varAttr);
                    ReferenceMatchingWizardPage.this.referenceView.setInput(ReferenceMatchingWizardPage.this.values.getMapVarRefValuesFromKey(varAttr));
                    ReferenceMatchingWizardPage.this.enableCreateReferenceButton();
                }
            }
        });
        this.btnCreateReference.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceMatchingWizardPage.this.values.createReference();
                ReferenceMatchingWizardPage.this.referenceView.setInput(ReferenceMatchingWizardPage.this.values.getMapVarRefValuesFromKey(ReferenceMatchingWizardPage.this.values.getVariableAttributeConfigurationSelected()));
                ReferenceMatchingWizardPage.this.referenceView.refresh();
                ReferenceMatchingWizardPage.this.variableInfoElementsTable.remove(ReferenceMatchingWizardPage.this.variableInfoElementsTable.getSelectionIndices());
                ReferenceMatchingWizardPage.this.variableInfoElementsTable.update();
                ReferenceMatchingWizardPage.this.variableInfoElementsTable.deselectAll();
                ReferenceMatchingWizardPage.this.showVarIEDescription("");
                ReferenceMatchingWizardPage.this.values.removeSelectedVariableIEContents();
                ReferenceMatchingWizardPage.this.enableCreateReferenceButton();
            }
        });
    }

    private void enableCreateReferenceButton() {
        if (this.values.getVariableAttributeConfigurationSelected() != null && this.values.getVariableIEContentsSelected() != null) {
            this.btnCreateReference.setEnabled(true);
        } else {
            this.btnCreateReference.setEnabled(false);
        }
    }

    private void makeActions() {
        this.editIEAction = new EditIEViewerAction((Viewer)this.variableInfoElementsView);
        this.editIEAction.setText("&Edit");
        this.editIEAction.setToolTipText("Opens the Info Element with the default editor");
        this.editIEAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)RepositoryManagerUIPlugin.getDefault().getImageRegistry().get("IMG_ELCL16_EDIT")));
    }

    protected void showVarIEDescription(final String description) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ReferenceMatchingWizardPage.this.VariableInfoElementsDescriptionText.isDisposed()) {
                    ReferenceMatchingWizardPage.this.VariableInfoElementsDescriptionText.setText(description != null ? description : "");
                }
            }
        });
    }

    protected void showVarAttrDescription(final String description) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ReferenceMatchingWizardPage.this.VariableAttributesDescriptionText.isDisposed()) {
                    ReferenceMatchingWizardPage.this.VariableAttributesDescriptionText.setText(description != null ? description : "");
                }
            }
        });
    }

    protected Collection<InfoElement> searchString(String searchString) {
        CDOView view = this.getView();
        IIEQueryBuilder ieQueryBuilder = IIEQueryBuilder.FACTORY.createQueryFor((String)view.getSession().getRepositoryInfo().getStoreType()).where().containsSubstring("description", searchString).or().containsSubstring("title", searchString);
        CDOQuery query = view.createQuery(ieQueryBuilder.language(), ieQueryBuilder.build());
        return query.getResult();
    }

    protected CDOView getView() {
        if (this.view == null) {
            try {
                this.session = IRepositoryManager.INSTANCE.openSession(this.getLocation().getUuid());
                this.view = this.session.openView();
            }
            catch (UnknownRepositoryException e) {
                e.printStackTrace();
            }
        }
        return this.view;
    }

    protected RepositoryLocation getLocation() {
        return this.values.getRepositoryLocation();
    }

    protected VariableIEContents getSelectedVariableInfoElement() {
        IStructuredSelection selection = (IStructuredSelection)this.variableInfoElementsView.getSelection();
        return (VariableIEContents)selection.getFirstElement();
    }

    protected VariableAttributeConfiguration getSelectedVariableAttribute() {
        IStructuredSelection selection = (IStructuredSelection)this.variableAttributesView.getSelection();
        return (VariableAttributeConfiguration)selection.getFirstElement();
    }

    public void dispose() {
        super.dispose();
    }
}

