/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.repomanager.ui.views.providers;

import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryLocation;
import es.upv.dsic.issi.dplfw.repomanager.ui.RepositoryManagerUIPlugin;
import es.upv.dsic.issi.dplfw.repomanager.ui.model.RepositoryNode;
import es.upv.dsic.issi.dplfw.repomanager.ui.views.providers.BoldStyler;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;

public class RepositoriesLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider {
    private AdapterFactoryLabelProvider labelProvider;

    public RepositoriesLabelProvider() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        StyledString text = new StyledString();
        if (element instanceof RepositoryNode) {
            if (((RepositoryNode)element).isConnected()) {
                text.append(((RepositoryNode)element).getName(), (StyledString.Styler)new BoldStyler());
                text.append(" (Connected)", StyledString.DECORATIONS_STYLER);
            } else {
                text.append(((RepositoryNode)element).getName());
                text.append(" (Disconnected)", StyledString.DECORATIONS_STYLER);
            }
        } else if (element instanceof RepositoryLocation) {
            text.append(((RepositoryLocation)element).toStringURI());
            text.append(" (UUID: ", StyledString.DECORATIONS_STYLER);
            text.append(((RepositoryLocation)element).getUuid(), StyledString.DECORATIONS_STYLER);
            text.append(")", StyledString.DECORATIONS_STYLER);
        } else if (element instanceof CDOResourceNode) {
            text.append(((CDOResourceNode)element).getName());
            text.append(" (", StyledString.DECORATIONS_STYLER);
            if (element instanceof CDOResource) {
                text.append(String.valueOf(((CDOResource)element).getContents().size()), StyledString.DECORATIONS_STYLER);
            } else if (element instanceof CDOResourceFolder) {
                text.append(String.valueOf(((CDOResourceFolder)element).getNodes().size()), StyledString.DECORATIONS_STYLER);
            }
            text.append(")", StyledString.DECORATIONS_STYLER);
        } else if (element instanceof InfoElement) {
            text.append(this.labelProvider.getText(element));
        } else {
            text.append(element.toString());
        }
        cell.setText(text.toString());
        cell.setStyleRanges(text.getStyleRanges());
        cell.setImage(this.getImage(element));
        super.update(cell);
    }

    public Image getImage(Object element) {
        if (element instanceof RepositoryNode || element instanceof RepositoryLocation) {
            return RepositoryManagerUIPlugin.getDefault().getImageRegistry().get("IMG_OBJ16_REPOSITORY");
        }
        if (element instanceof CDOResource) {
            return RepositoryManagerUIPlugin.getDefault().getImageRegistry().get("IMG_OBJ16_CDORESOURCE");
        }
        if (element instanceof CDOResourceFolder) {
            return RepositoryManagerUIPlugin.getDefault().getImageRegistry().get("IMG_OBJ16_CDORESOURCEFOLDER");
        }
        if (element instanceof InfoElement) {
            return this.labelProvider.getImage(element);
        }
        return null;
    }

    public String getText(Object element) {
        return element.toString();
    }
}

