/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.repomanager.ui.views;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.CDOObjectEditorInput;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.repomanager.IRepositoryManager;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryLocation;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryRegistryEvent;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryRegistryListener;
import es.upv.dsic.issi.dplfw.repomanager.UnknownRepositoryException;
import es.upv.dsic.issi.dplfw.repomanager.ui.RepositoryManagerUIPlugin;
import es.upv.dsic.issi.dplfw.repomanager.ui.actions.EditIEViewerAction;
import es.upv.dsic.issi.dplfw.repomanager.ui.model.BusyRepositoryException;
import es.upv.dsic.issi.dplfw.repomanager.ui.model.RepositoryNode;
import es.upv.dsic.issi.dplfw.repomanager.ui.views.RepositoriesViewerDropAdapter;
import es.upv.dsic.issi.dplfw.repomanager.ui.views.RepositoriesViewerSorter;
import es.upv.dsic.issi.dplfw.repomanager.ui.views.providers.RepositoriesLabelProvider;
import es.upv.dsic.issi.dplfw.repomanager.ui.views.providers.ViewContentProvider;
import es.upv.dsic.issi.dplfw.repomanager.ui.wizards.SelectInfoElementWizard;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.CDOAdapter;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.statushandlers.StatusManager;

public class RepositoriesView
extends ViewPart {
    public static final String ID = "es.upv.dsic.issi.dplfw.repomanager.ui.views.RepositoriesView";
    private ViewerRefreshAdapter adapter = new ViewerRefreshAdapter();
    private Action connectAction;
    private Action disconnectAction;
    private Action manageAction;
    private Action editIEAction;
    private Action createIEAction;
    private Action refreshAction;
    private Action searchAction;
    private DrillDownAdapter drillDownAdapter;
    private RepositoryRegistryListener listener = new ViewerRepositoryRegistryListener();
    private IRepositoryManager repositoryManager;
    private Map<String, RepositoryNode> repositoryNodes = new LinkedHashMap<String, RepositoryNode>();
    private TreeViewer viewer;

    public RepositoriesView() {
        this.repositoryManager = IRepositoryManager.INSTANCE;
        for (RepositoryLocation location : this.repositoryManager.getRepositories()) {
            this.repositoryNodes.put(location.getUuid(), new RepositoryNode(location));
        }
        this.repositoryManager.addRepositoryRegistryListener(this.listener);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 268436226);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RepositoriesLabelProvider());
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.setInput(this.repositoryNodes.values());
        this.viewer.setSorter((ViewerSorter)new RepositoriesViewerSorter());
        this.viewer.addDragSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new DragSourceAdapter());
        this.viewer.addDropSupport(3, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new RepositoriesViewerDropAdapter((Viewer)this.viewer));
        this.addDoubleClickListener();
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "es.upv.dsic.issi.dplfw.repomanager.ui.viewer");
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private void addDoubleClickListener() {
        this.viewer.addDoubleClickListener((IDoubleClickListener)new RepositoriesViewerDoubleClickListener());
    }

    private void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        boolean allSametype = true;
        Class<?> c = selection.getFirstElement().getClass();
        for (Object element : selection.toList()) {
            if (c.isInstance(element)) continue;
            allSametype = false;
            break;
        }
        if (allSametype) {
            if (selection.getFirstElement() instanceof RepositoryNode) {
                int connected = 0;
                int disconnected = 0;
                for (Object element : selection.toList()) {
                    if (((RepositoryNode)element).isConnected()) {
                        ++connected;
                        continue;
                    }
                    ++disconnected;
                }
                if (selection.size() == connected) {
                    manager.add((IAction)this.disconnectAction);
                } else if (selection.size() == disconnected) {
                    manager.add((IAction)this.connectAction);
                }
                if (selection.size() == 1 && ((RepositoryNode)selection.getFirstElement()).isConnected()) {
                    manager.add((IAction)this.searchAction);
                }
            } else if (selection.getFirstElement() instanceof InfoElement) {
                manager.add((IAction)this.editIEAction);
            }
        }
        if (selection.size() == 1 && Platform.getAdapterManager().getAdapter(selection.getFirstElement(), CDOResource.class) != null) {
            manager.add((IContributionItem)new Separator("es.upv.dsic.issi.dplfw.repomanager.ui.popup.new"));
            manager.add((IAction)this.createIEAction);
        }
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.searchAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.manageAction);
        manager.add((IContributionItem)new Separator());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.searchAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.manageAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IAction)this.refreshAction);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RepositoriesView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void makeActions() {
        this.makeConnectAction();
        this.makeDisconnectAction();
        this.makeManageAction();
        this.makeEditIEAction();
        this.makeCreateIEAction();
        this.makeRefreshAction();
        this.makeSearchAction();
    }

    private void makeConnectAction() {
        this.connectAction = new Action(){

            public void run() {
                final IStructuredSelection selection = (IStructuredSelection)RepositoriesView.this.viewer.getSelection();
                Job connectJob = new Job("Connecting to repositories"){

                    protected IStatus run(IProgressMonitor monitor) {
                        List elements = selection.toList();
                        monitor.beginTask("Connecting to repositories...", elements.size());
                        for (Object element : elements) {
                            final RepositoryNode node = (RepositoryNode)element;
                            monitor.subTask(String.format("Connecting to %s", node.getLocation().getUuid()));
                            try {
                                RepositoriesView.this.internalConnectRepository(node);
                                RepositoriesView.this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        RepositoriesView.this.viewer.refresh((Object)node);
                                    }
                                });
                            }
                            catch (UnknownRepositoryException e) {
                                RepositoriesView.this.logException((Exception)((Object)e));
                            }
                            monitor.worked(1);
                        }
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                };
                connectJob.setUser(true);
                connectJob.schedule();
            }
        };
        this.connectAction.setText("&Connect");
        this.connectAction.setToolTipText("Connect to Repository");
        this.connectAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)RepositoryManagerUIPlugin.getDefault().getImageRegistry().get("IMG_ELCL16_CONNECT")));
    }

    private void makeDisconnectAction() {
        this.disconnectAction = new Action(){

            public void run() {
                final IStructuredSelection selection = (IStructuredSelection)RepositoriesView.this.viewer.getSelection();
                Job connectJob = new Job("Disconnecting repositories"){

                    protected IStatus run(IProgressMonitor monitor) {
                        List elements = selection.toList();
                        monitor.beginTask("Disconnecting repositories...", elements.size());
                        for (Object element : elements) {
                            final RepositoryNode node = (RepositoryNode)element;
                            monitor.subTask(String.format("Disconnecting from %s", node.getLocation().getUuid()));
                            try {
                                node.disconnect();
                                RepositoriesView.this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        RepositoriesView.this.viewer.refresh((Object)node);
                                    }
                                });
                            }
                            catch (BusyRepositoryException e) {
                                RepositoriesView.this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        boolean forceDisconnect = MessageDialog.openQuestion((Shell)RepositoriesView.this.getSite().getShell(), (String)"Unable to close repository", (String)String.format("The repository \"%s\" has open connections.\nClose them anyway?", node.getName()));
                                        if (forceDisconnect) {
                                            node.forceDisconnect();
                                            RepositoriesView.this.viewer.refresh((Object)node);
                                        }
                                    }
                                });
                            }
                            monitor.worked(1);
                        }
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                };
                connectJob.setUser(true);
                connectJob.schedule();
            }
        };
        this.disconnectAction.setText("&Disconnect");
        this.disconnectAction.setToolTipText("Disconnect from Repository");
        this.disconnectAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)RepositoryManagerUIPlugin.getDefault().getImageRegistry().get("IMG_ELCL16_DISCONNECT")));
    }

    private void makeManageAction() {
        this.manageAction = new Action(){

            public void run() {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)RepositoriesView.this.getSite().getShell(), (String)"es.upv.dsic.issi.dplfw.repomanager.ui.preferences.RepositoriesPreferencePage", (String[])new String[]{"es.upv.dsic.issi.dplfw.core.ui.preferences.root", "es.upv.dsic.issi.dplfw.repomanager.ui.preferences.RepositoriesPreferencePage"}, null);
                dialog.open();
            }
        };
        this.manageAction.setText("&Manage Repositories");
        this.manageAction.setToolTipText("Add and Remove Repositories");
        this.manageAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)RepositoryManagerUIPlugin.getDefault().getImageRegistry().get("IMG_ELCL16_MANAGE")));
    }

    private void makeEditIEAction() {
        this.editIEAction = new EditIEViewerAction((Viewer)this.viewer);
        this.editIEAction.setText("&Edit");
        this.editIEAction.setToolTipText("Opens the Info Element with the default editor");
        this.editIEAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)RepositoryManagerUIPlugin.getDefault().getImageRegistry().get("IMG_ELCL16_EDIT")));
    }

    private void makeRefreshAction() {
        this.refreshAction = new Action(){

            public void run() {
                RepositoriesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        RepositoriesView.this.viewer.refresh(true);
                    }
                });
            }
        };
        this.refreshAction.setText("&Refresh");
        this.refreshAction.setToolTipText("Forces the viewer to be refreshed");
        this.refreshAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)RepositoryManagerUIPlugin.getDefault().getImageRegistry().get("IMG_ELCL16_REFRESH")));
    }

    private void makeSearchAction() {
        this.searchAction = new Action(){

            public void run() {
                RepositoryLocation location = null;
                StructuredSelection selection = (StructuredSelection)RepositoriesView.this.viewer.getSelection();
                if (!selection.isEmpty() && selection.getFirstElement() instanceof RepositoryNode) {
                    location = ((RepositoryNode)selection.getFirstElement()).getLocation();
                }
                SelectInfoElementWizard wizard = new SelectInfoElementWizard(location);
                WizardDialog wizardDialog = new WizardDialog(RepositoriesView.this.getSite().getShell(), (IWizard)wizard){
                    {
                        this.setShellStyle(1264);
                    }
                };
                wizardDialog.create();
                wizardDialog.setBlockOnOpen(true);
                if (wizardDialog.open() == 0) {
                    URI uri = wizard.getInfoElementUri();
                    try {
                        RepositoryNode node = (RepositoryNode)RepositoriesView.this.repositoryNodes.get(uri.host());
                        if (node == null) {
                            return;
                        }
                        if (!node.isConnected()) {
                            boolean connect = MessageDialog.openQuestion((Shell)RepositoriesView.this.getSite().getShell(), (String)"Connect to repository?", (String)String.format("Repository '%s' is disconnected. Do yo want to connect to it now?", node.getLocation().toStringURI()));
                            if (connect) {
                                RepositoriesView.this.internalConnectRepository(node);
                            }
                            RepositoriesView.this.viewer.update((Object)node, null);
                        }
                        EObject element = node.getRootResource().getEObject(uri.fragment());
                        LinkedList<Object> elements = new LinkedList<Object>();
                        Object parent = element;
                        while (parent != null) {
                            elements.addFirst(parent);
                            parent = parent.eContainer() != null ? parent.eContainer() : (parent.eResource() != null && parent.eResource() != parent && parent.eResource() != node.getRootResource() && parent.eResource() instanceof EObject ? (EObject)parent.eResource() : null);
                        }
                        elements.addFirst(node);
                        int i = 0;
                        while (i < elements.size()) {
                            RepositoriesView.this.viewer.expandToLevel(elements.get(i), 1);
                            ++i;
                        }
                        RepositoriesView.this.viewer.setSelection((ISelection)new StructuredSelection((Object)element));
                    }
                    catch (UnknownRepositoryException e) {
                        RepositoriesView.this.logException((Exception)((Object)e));
                    }
                }
            }
        };
        this.searchAction.setText("&Search...");
        this.searchAction.setToolTipText("Searches for a Specific Info Element in a repository");
        this.searchAction.setImageDescriptor(ImageDescriptor.createFromImage((Image)RepositoryManagerUIPlugin.getDefault().getImageRegistry().get("IMG_ELCL16_SEARCH")));
    }

    private void makeCreateIEAction() {
        this.createIEAction = new Action("New InfoElement", 4){

            public void run() {
            }
        };
        this.createIEAction.setText("New InfoElement");
        this.createIEAction.setToolTipText("Creates a new InfoElement in the selected repository location");
        this.createIEAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
        this.createIEAction.setMenuCreator(new IMenuCreator(){
            private Menu menuInControl;
            private Menu menuInMenu;

            public Menu getMenu(Menu parent) {
                if (this.menuInMenu == null || this.menuInMenu.isDisposed()) {
                    this.menuInMenu = new Menu(parent);
                    this.populateMenu(this.menuInMenu);
                }
                return this.menuInMenu;
            }

            public Menu getMenu(Control parent) {
                if (this.menuInControl == null || this.menuInControl.isDisposed()) {
                    this.menuInControl = new Menu(parent);
                    this.populateMenu(this.menuInControl);
                }
                return this.menuInControl;
            }

            private void populateMenu(Menu menu) {
                IExtensionRegistry registry = Platform.getExtensionRegistry();
                IConfigurationElement[] extensions = registry.getConfigurationElementsFor("es.upv.dsic.issi.dplfw.repomanager.ui.iecreation");
                MenuItem menuItem = null;
                IConfigurationElement[] iConfigurationElementArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    final IConfigurationElement configElement = iConfigurationElementArray[n2];
                    menuItem = new MenuItem(menu, 8);
                    menuItem.setText(configElement.getAttribute("label"));
                    try {
                        InfoElement dummyElement = (InfoElement)configElement.createExecutableExtension("InfoElementClass");
                        if (configElement.getAttribute("icon") == null) {
                            Image image = ((ILabelProvider)RepositoriesView.this.viewer.getLabelProvider()).getImage((Object)dummyElement);
                            if (image != null) {
                                menuItem.setImage(image);
                            }
                        } else {
                            menuItem.setImage(new Image((Device)RepositoriesView.this.getSite().getShell().getDisplay(), this.getClass().getResourceAsStream("/" + configElement.getAttribute("icon"))));
                        }
                        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                try {
                                    InfoElement element = (InfoElement)configElement.createExecutableExtension("InfoElementClass");
                                    element.createUUID();
                                    IStructuredSelection selection = (IStructuredSelection)RepositoriesView.this.viewer.getSelection();
                                    CDOResource resource = (CDOResource)Platform.getAdapterManager().getAdapter(selection.getFirstElement(), CDOResource.class);
                                    if (resource != null) {
                                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                        CDOSession session = CDOUtil.getSession((Object)resource);
                                        CDOTransaction transaction = session.openTransaction();
                                        resource = (CDOResource)transaction.getObject((EObject)resource);
                                        try {
                                            resource.getContents().add((Object)element);
                                            transaction.commit();
                                            CDOObjectEditorInput input = new CDOObjectEditorInput((CDOView)transaction, resource.getPath(), resource.getURIFragment((EObject)element), true);
                                            page.openEditor((IEditorInput)input, "es.upv.dsic.issi.dplfw.infoelement.singleeditor.SingleInfoElementEditor");
                                        }
                                        catch (CommitException ex) {
                                            transaction.rollback();
                                            RepositoriesView.this.logException((Exception)((Object)ex));
                                        }
                                        catch (CoreException ex) {
                                            RepositoriesView.this.logException((Exception)((Object)ex));
                                        }
                                    }
                                }
                                catch (CoreException e1) {
                                    RepositoriesView.this.logException((Exception)((Object)e1));
                                }
                            }
                        });
                    }
                    catch (CoreException e) {
                        RepositoriesView.this.logException((Exception)((Object)e));
                    }
                    ++n2;
                }
            }

            public void dispose() {
                if (this.menuInControl != null) {
                    this.menuInControl.dispose();
                    this.menuInControl = null;
                }
                if (this.menuInMenu != null) {
                    this.menuInMenu.dispose();
                    this.menuInMenu = null;
                }
            }
        });
    }

    private void internalConnectRepository(RepositoryNode node) throws UnknownRepositoryException {
        node.connect();
        node.setEObjectAdapter((Adapter)this.adapter);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    void logException(Exception e) {
        StatusManager.getManager().handle((IStatus)new Status(4, "es.upv.dsic.issi.dplfw.repomanager.ui", e.getLocalizedMessage(), (Throwable)e), 5);
    }

    public void dispose() {
        for (RepositoryNode node : this.repositoryNodes.values()) {
            if (!node.isConnected()) continue;
            node.forceDisconnect();
        }
        this.repositoryManager.removeRepositoryRegistryListener(this.listener);
        this.repositoryNodes.clear();
        super.dispose();
    }

    private final class RepositoriesViewerDoubleClickListener
    implements IDoubleClickListener {
        private RepositoriesViewerDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection) {
                Object element = ((IStructuredSelection)selection).getFirstElement();
                if (element instanceof InfoElement) {
                    RepositoriesView.this.editIEAction.run();
                } else {
                    RepositoryNode node;
                    if (element instanceof RepositoryNode && !(node = (RepositoryNode)element).isConnected()) {
                        RepositoriesView.this.connectAction.run();
                    }
                    if (!RepositoriesView.this.viewer.getExpandedState(element)) {
                        RepositoriesView.this.viewer.expandToLevel(element, 1);
                    } else {
                        RepositoriesView.this.viewer.collapseToLevel(element, 1);
                    }
                }
            }
        }
    }

    private final class ViewerRefreshAdapter
    extends AdapterImpl
    implements CDOAdapter {
        private ViewerRefreshAdapter() {
        }

        public void notifyChanged(final Notification msg) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!RepositoriesView.this.viewer.getTree().isDisposed()) {
                        if (msg.getNotifier() instanceof InfoElement && msg.getFeature() != null) {
                            RepositoriesView.this.viewer.update(msg.getNotifier(), new String[]{((EStructuralFeature)msg.getFeature()).getName()});
                        } else {
                            RepositoriesView.this.viewer.refresh();
                        }
                    }
                }
            });
        }
    }

    private final class ViewerRepositoryRegistryListener
    implements RepositoryRegistryListener {
        private ViewerRepositoryRegistryListener() {
        }

        public void repositoryRegistryChange(RepositoryRegistryEvent event) {
            RepositoryLocation location = event.getRepositoryLocation();
            if (event.getType() == RepositoryRegistryEvent.Type.ADDITION) {
                RepositoryNode node = new RepositoryNode(location);
                RepositoriesView.this.repositoryNodes.put(location.getUuid(), node);
                RepositoriesView.this.viewer.refresh((Object)node);
            } else if (event.getType() == RepositoryRegistryEvent.Type.DELETION) {
                RepositoryNode node = (RepositoryNode)RepositoriesView.this.repositoryNodes.get(location.getUuid());
                RepositoriesView.this.repositoryNodes.remove(location.getUuid());
                RepositoriesView.this.viewer.refresh((Object)node);
            } else if (event.getType() == RepositoryRegistryEvent.Type.MODIFICATION) {
                RepositoryNode node = (RepositoryNode)RepositoriesView.this.repositoryNodes.get(location.getUuid());
                RepositoriesView.this.viewer.update((Object)node, null);
            }
            RepositoriesView.this.viewer.refresh();
        }
    }
}

