/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.repomanager.ui.preferences;

import es.upv.dsic.issi.dplfw.repomanager.IRepositoryManager;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryLocation;
import es.upv.dsic.issi.dplfw.repomanager.ui.RepositoryManagerUIPlugin;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.connector.ConnectorException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class RepositoriesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private HashMap<String, RepositoryLocation> repositories = new LinkedHashMap<String, RepositoryLocation>();
    private TableViewer repositoriesViewer;
    private Button addRepoButton;
    private Button removeRepoButton;

    public RepositoriesPreferencePage() {
        this.setPreferenceStore(RepositoryManagerUIPlugin.getDefault().getPreferenceStore());
        this.setDescription("DPLfw available repositories");
    }

    public void init(IWorkbench workbench) {
        this.loadRepositories();
    }

    private void loadRepositories() {
        this.repositories.clear();
        this.repositories.putAll(IRepositoryManager.INSTANCE.getRepositoriesMap());
    }

    protected Control createContents(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout(2, false);
        topLayout.marginWidth = 0;
        topLayout.marginHeight = 0;
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        layoutData.minimumHeight = 200;
        layoutData.heightHint = 200;
        layoutData.minimumWidth = 400;
        topComposite.setLayout((Layout)topLayout);
        topComposite.setLayoutData((Object)layoutData);
        this.repositoriesViewer = new TableViewer(topComposite, 67588);
        this.createColumns(this.repositoriesViewer);
        this.repositoriesViewer.getTable().setHeaderVisible(true);
        this.repositoriesViewer.setContentProvider((IContentProvider)new RepositoriesMapContentProvider());
        this.repositoriesViewer.setInput(this.repositories);
        this.repositoriesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RepositoriesPreferencePage.this.removeRepoButton.setEnabled(!event.getSelection().isEmpty() && !StringUtils.equals((CharSequence)"default", (CharSequence)((RepositoryLocation)((IStructuredSelection)event.getSelection()).getFirstElement()).getUuid()));
            }
        });
        this.repositoriesViewer.getControl().setLayoutData((Object)layoutData);
        Composite buttonsComposite = new Composite(topComposite, 0);
        GridData gridData = new GridData(100, -1);
        gridData.grabExcessVerticalSpace = false;
        gridData.verticalAlignment = 1;
        buttonsComposite.setLayoutData((Object)gridData);
        FillLayout fillLayout = new FillLayout(512);
        fillLayout.spacing = 5;
        buttonsComposite.setLayout((Layout)fillLayout);
        this.addRepoButton = new Button(buttonsComposite, 8);
        this.addRepoButton.setText("&New...");
        this.addRepoButton.addSelectionListener((SelectionListener)new NewRepoSelectionListener());
        this.removeRepoButton = new Button(buttonsComposite, 8);
        this.removeRepoButton.setText("&Remove");
        this.removeRepoButton.addSelectionListener((SelectionListener)new RemoveRepoSelectionAdapter());
        this.removeRepoButton.setEnabled(false);
        return topComposite;
    }

    private void createColumns(TableViewer viewer) {
        String[] titles = new String[]{"UUID", "Schema", "User", "Host", "Port", "Repository Path"};
        int[] bounds = new int[]{140, 60, 50, 70, 50, 200};
        TableViewerColumn col = this.createTableViewerColumn(viewer, titles[0], bounds[0], 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                RepositoryLocation location = (RepositoryLocation)element;
                return location.getUuid();
            }

            public Image getImage(Object element) {
                return RepositoryManagerUIPlugin.getDefault().getImageRegistry().get("IMG_OBJ16_REPOSITORY");
            }
        });
        col = this.createTableViewerColumn(viewer, titles[1], bounds[1], 1);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                RepositoryLocation location = (RepositoryLocation)element;
                return location.getProtocol();
            }
        });
        col = this.createTableViewerColumn(viewer, titles[2], bounds[2], 2);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                RepositoryLocation location = (RepositoryLocation)element;
                return (String)StringUtils.defaultIfEmpty((CharSequence)location.getUsername(), (CharSequence)"-");
            }
        });
        col = this.createTableViewerColumn(viewer, titles[3], bounds[3], 3);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                RepositoryLocation location = (RepositoryLocation)element;
                return (String)StringUtils.defaultIfEmpty((CharSequence)location.getHost(), (CharSequence)"-");
            }
        });
        col = this.createTableViewerColumn(viewer, titles[4], bounds[4], 4);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                RepositoryLocation location = (RepositoryLocation)element;
                return location.getPort() >= 0 ? String.valueOf(location.getPort()) : "-";
            }
        });
        col = this.createTableViewerColumn(viewer, titles[5], bounds[5], 5);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                RepositoryLocation location = (RepositoryLocation)element;
                return String.valueOf(location.getRepositoryName());
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    public boolean performOk() {
        IRepositoryManager manager = IRepositoryManager.INSTANCE;
        ArrayList<String> deletedRepositoriesUuids = new ArrayList<String>();
        for (RepositoryLocation repositoryLocation : manager.getRepositories()) {
            if (this.repositories.containsKey(repositoryLocation.getUuid())) continue;
            deletedRepositoriesUuids.add(repositoryLocation.getUuid());
        }
        for (String uuid : deletedRepositoriesUuids) {
            manager.deleteRepository(uuid);
        }
        for (RepositoryLocation repositoryLocation : this.repositories.values()) {
            manager.addRepository(repositoryLocation);
        }
        return super.performOk();
    }

    protected void performDefaults() {
        this.loadRepositories();
        this.repositoriesViewer.refresh();
        super.performDefaults();
    }

    private final class NewRepoSelectionListener
    extends SelectionAdapter {
        private NewRepoSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            InputDialog inputDialog;
            String initialValue = "";
            IStructuredSelection selection = (IStructuredSelection)RepositoriesPreferencePage.this.repositoriesViewer.getSelection();
            if (!selection.isEmpty()) {
                RepositoryLocation repositoryLocation = (RepositoryLocation)selection.getFirstElement();
                initialValue = repositoryLocation.toStringURI();
            }
            if ((inputDialog = new InputDialog(RepositoriesPreferencePage.this.getShell(), "Add repository", "Location:", initialValue, new IInputValidator(){

                public String isValid(String newText) {
                    URI uri;
                    block10: {
                        block9: {
                            block8: {
                                block7: {
                                    try {
                                        if (!StringUtils.isBlank((CharSequence)newText)) break block7;
                                        return "Expected syntax: protocol://user:password@hostname:port/repository_name\rExample: tcp://user:user@localhost:12036/repo";
                                    }
                                    catch (URISyntaxException e) {
                                        return e.getLocalizedMessage();
                                    }
                                }
                                uri = new URI(newText);
                                if (uri.getScheme() != null) break block8;
                                return "Unknown protocol";
                            }
                            if (StringUtils.equals((CharSequence)uri.getScheme(), (CharSequence)"file") || uri.getHost() != null) break block9;
                            return "Expected a host location";
                        }
                        if (uri.getPath() != null) break block10;
                        return "Expected a repository location";
                    }
                    if (StringUtils.equals((CharSequence)uri.getScheme(), (CharSequence)"file") && !uri.getPath().startsWith("/")) {
                        return "Expected an absolute path";
                    }
                    return null;
                }
            })).open() == 0) {
                String newLocationURI = inputDialog.getValue();
                try {
                    String uuid = this.retrieveRepoUuid(newLocationURI);
                    RepositoryLocation existingLocation = (RepositoryLocation)RepositoriesPreferencePage.this.repositories.get(uuid);
                    boolean addRepository = true;
                    if (existingLocation != null) {
                        if (!existingLocation.toStringURI().equals(newLocationURI)) {
                            addRepository = MessageDialog.openQuestion((Shell)RepositoriesPreferencePage.this.getShell(), (String)"Overwrite?", (String)String.format("Repository with UUID {%s} already exists with URI \"%s\".\nReplace it with \"%s\"?", uuid, existingLocation.toStringURI(), newLocationURI));
                        } else {
                            addRepository = false;
                            MessageDialog.openInformation((Shell)RepositoriesPreferencePage.this.getShell(), (String)"Repository already exists", (String)String.format("Repository with UUID {%s} already exists", uuid));
                        }
                    }
                    if (addRepository) {
                        RepositoryLocation repositoryLocation = new RepositoryLocation(uuid, newLocationURI);
                        RepositoriesPreferencePage.this.repositories.put(uuid, repositoryLocation);
                        RepositoriesPreferencePage.this.repositoriesViewer.refresh();
                    }
                }
                catch (UnknownHostException e1) {
                    MessageDialog.openError((Shell)RepositoriesPreferencePage.this.getShell(), (String)"Error", (String)String.format("Unable to connect to \"%s\".\nUnknown host: %s", newLocationURI, e1.getLocalizedMessage()));
                }
                catch (ConnectorException e1) {
                    MessageDialog.openError((Shell)RepositoriesPreferencePage.this.getShell(), (String)"Error", (String)String.format("Unable to connect to \"%s\".\n%s", newLocationURI, e1.getLocalizedMessage()));
                }
                catch (Throwable e1) {
                    MessageDialog.openError((Shell)RepositoriesPreferencePage.this.getShell(), (String)"Error", (String)String.format("Unable to connect to \"%s\".\n%s", newLocationURI, e1.toString()));
                }
            }
        }

        private String retrieveRepoUuid(String newLocationURI) throws Throwable {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(RepositoriesPreferencePage.this.getShell());
            RetrieveUuidRunnable retrieveUuidRunnable = new RetrieveUuidRunnable(newLocationURI);
            dialog.run(true, false, (IRunnableWithProgress)retrieveUuidRunnable);
            if (retrieveUuidRunnable.success()) {
                return retrieveUuidRunnable.getUuid();
            }
            throw retrieveUuidRunnable.getThrowable();
        }

        private final class RetrieveUuidRunnable
        implements IRunnableWithProgress {
            private String uuid;
            private String newLocationURI;
            private Throwable throwable;
            private boolean success = false;

            private RetrieveUuidRunnable(String newLocationURI) {
                this.newLocationURI = newLocationURI;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("Retrieving repository UUID...", -1);
                try {
                    this.success = false;
                    this.uuid = IRepositoryManager.INSTANCE.getRepositoryUUID(this.newLocationURI);
                    this.success = true;
                }
                catch (Exception e) {
                    this.throwable = e;
                }
            }

            public String getUuid() {
                return this.uuid;
            }

            public Throwable getThrowable() {
                return this.throwable;
            }

            public boolean success() {
                return this.success;
            }
        }
    }

    private final class RemoveRepoSelectionAdapter
    extends SelectionAdapter {
        private RemoveRepoSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            IStructuredSelection selection = (IStructuredSelection)RepositoriesPreferencePage.this.repositoriesViewer.getSelection();
            if (!selection.isEmpty()) {
                RepositoryLocation repositoryLocation = (RepositoryLocation)selection.getFirstElement();
                RepositoriesPreferencePage.this.repositories.remove(repositoryLocation.getUuid());
                RepositoriesPreferencePage.this.repositoriesViewer.remove((Object)repositoryLocation);
                RepositoriesPreferencePage.this.repositoriesViewer.refresh((Object)repositoryLocation);
            }
        }
    }

    private final class RepositoriesMapContentProvider
    implements IStructuredContentProvider {
        private RepositoriesMapContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Map)inputElement).values().toArray();
        }
    }
}

