/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.repomanager.ui.model;

import es.upv.dsic.issi.dplfw.repomanager.IRepositoryManager;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryLocation;
import es.upv.dsic.issi.dplfw.repomanager.UnknownRepositoryException;
import es.upv.dsic.issi.dplfw.repomanager.ui.model.BusyRepositoryException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.net4j.CDOSession;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOObjectHandler;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.ui.IActionFilter;

public class RepositoryNode
implements IAdaptable,
IActionFilter {
    private static final int COMMIT_TIMEOUT = 200000;
    private RepositoryLocation location;
    private CDOSession session;
    private CDOView view;
    private Adapter eObjectAdapter;

    public RepositoryNode(RepositoryLocation location) {
        this.location = location;
    }

    public RepositoryLocation getLocation() {
        return this.location;
    }

    protected CDOSession getSession() {
        if (this.session == null) {
            try {
                this.connect();
            }
            catch (UnknownRepositoryException e) {
                e.printStackTrace();
            }
        }
        return this.session;
    }

    protected CDOSession createSession() throws UnknownRepositoryException {
        this.session = IRepositoryManager.INSTANCE.openSession(this.location.getUuid());
        ((CDOSession.Options)this.session.options()).setCommitTimeout(200000);
        this.session.options().setCollectionLoadingPolicy(CDOUtil.createCollectionLoadingPolicy((int)0, (int)300));
        this.session.addListener((IListener)new LifecycleEventAdapter(){

            protected void onDeactivated(ILifecycle lifecycle) {
                super.onDeactivated(lifecycle);
                RepositoryNode.this.session = null;
            }
        });
        return this.session;
    }

    protected CDOView getView() {
        if (this.view == null) {
            this.view = this.session.openView();
            this.view.addListener((IListener)new LifecycleEventAdapter(){

                protected void onDeactivated(ILifecycle lifecycle) {
                    super.onDeactivated(lifecycle);
                    RepositoryNode.this.view = null;
                }
            });
            this.view.addObjectHandler(new CDOObjectHandler(){

                public void objectStateChanged(CDOView view, CDOObject object, CDOState oldState, CDOState newState) {
                    if (!object.eAdapters().contains((Object)RepositoryNode.this.eObjectAdapter)) {
                        object.eAdapters().add((Object)RepositoryNode.this.eObjectAdapter);
                    }
                }
            });
        }
        return this.view;
    }

    protected void closeSession() {
        this.view.close();
        this.view = null;
        this.session.close();
        this.session = null;
    }

    public boolean hasChildren() {
        if (this.session == null) {
            return false;
        }
        return this.getChildren().length > 0;
    }

    public Object[] getChildren() {
        if (this.isConnected()) {
            return this.getView().getRootResource().getContents().toArray();
        }
        return new Object[0];
    }

    public CDOResource getRootResource() {
        if (this.isConnected()) {
            return this.getView().getRootResource();
        }
        return null;
    }

    protected void finalize() throws Throwable {
        if (this.session != null && !this.session.isClosed()) {
            this.view.close();
            this.session.close();
        }
        super.finalize();
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public String getName() {
        return this.location.toStringURI();
    }

    public void connect() throws UnknownRepositoryException {
        if (!this.isConnected()) {
            this.session = this.createSession();
        }
    }

    public void disconnect() throws BusyRepositoryException {
        if (this.session.getViews().length > 1) {
            throw new BusyRepositoryException("Repository + " + this.location.getHost() + " has open views!");
        }
        this.closeSession();
    }

    public void forceDisconnect() {
        this.closeSession();
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (target == this && name.equals("connected")) {
            return this.isConnected() == Boolean.parseBoolean(value);
        }
        return false;
    }

    public void setEObjectAdapter(Adapter eObjectAdapter) {
        this.eObjectAdapter = eObjectAdapter;
    }
}

