/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.repomanager.ui.jobs;

import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.util.InfoelementsEcoreUtil;
import es.upv.dsic.issi.dplfw.repomanager.ui.model.RepositoryNode;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.transaction.CDOSavepoint;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class MoveOrCopyElementsJob
extends Job {
    private final Object target;
    private final List<?> sourceElements;
    private final boolean move;

    public MoveOrCopyElementsJob(String name, Object target, List<?> sourceElements, boolean move) {
        super(name);
        this.target = target;
        this.sourceElements = sourceElements;
        this.move = move;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("", -1);
        CDOResource targetNode = null;
        if (this.target instanceof CDOResource) {
            targetNode = (CDOResource)this.target;
        } else if (this.target instanceof CDOResourceFolder) {
            targetNode = (CDOResourceNode)this.target;
        } else if (this.target instanceof RepositoryNode) {
            targetNode = ((RepositoryNode)this.target).getRootResource();
        } else {
            return Status.OK_STATUS;
        }
        CDOTransaction transaction = targetNode.cdoView().getSession().openTransaction();
        CDOSavepoint savepoint = transaction.setSavepoint();
        try {
            try {
                Collection copyElements = null;
                if (this.move) {
                    copyElements = InfoelementsEcoreUtil.fullCopyAll(this.sourceElements);
                    for (Object element : this.sourceElements) {
                        if (!(element instanceof EObject)) continue;
                        EObject eObject = transaction.getObject((EObject)element);
                        EcoreUtil.delete((EObject)eObject);
                    }
                    transaction.commit();
                } else {
                    copyElements = EcoreUtil.copyAll(this.sourceElements);
                    for (Object element : copyElements) {
                        if (!(element instanceof InfoElement)) continue;
                        InfoElement infoElement = (InfoElement)element;
                        infoElement.createUUID();
                    }
                }
                if (targetNode instanceof CDOResource) {
                    CDOResource targetResource = (CDOResource)transaction.getObject((EObject)targetNode);
                    targetResource.getContents().addAll(copyElements);
                } else if (targetNode instanceof CDOResourceFolder) {
                    CDOResourceFolder targetFolder = (CDOResourceFolder)transaction.getObject((EObject)targetNode);
                    targetFolder.getNodes().addAll(copyElements);
                }
                transaction.commit();
            }
            catch (CommitException e) {
                savepoint.rollback();
                Status status = new Status(4, "es.upv.dsic.issi.dplfw.repomanager.ui", e.getLocalizedMessage(), (Throwable)e);
                transaction.close();
                return status;
            }
            catch (Exception e) {
                Status status = new Status(4, "es.upv.dsic.issi.dplfw.repomanager.ui", e.getLocalizedMessage(), (Throwable)e);
                transaction.close();
                return status;
            }
        }
        finally {
            transaction.close();
        }
        monitor.done();
        return Status.OK_STATUS;
    }
}

