/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.repomanager.ui.actions;

import es.upv.dsic.issi.dplfw.repomanager.ui.messages.Messages;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.actions.LongRunningActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class TransactionalBackgroundActionDelegate
extends LongRunningActionDelegate
implements IObjectActionDelegate {
    private IWorkbenchPart targetPart;
    private String text;
    private CDOObject transactionalObject;

    public TransactionalBackgroundActionDelegate(String text) {
        this.text = text;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
        this.selectionChanged(action, this.getSelection());
    }

    public IWorkbenchPart getTargetPart() {
        return this.targetPart;
    }

    protected String getText() {
        return this.text;
    }

    protected int getCommitWorkPercent() {
        return 90;
    }

    protected final void preRun() throws Exception {
        Object element = UIUtil.getElement((ISelection)this.getSelection());
        CDOObject object = (CDOObject)AdapterUtil.adapt((Object)element, CDOObject.class);
        if (object != null) {
            this.transactionalObject = this.preRun(object);
            if (this.transactionalObject != null) {
                CDOView view = this.transactionalObject.cdoView();
                if (!(view instanceof CDOTransaction)) {
                    throw new IllegalStateException(MessageFormat.format(Messages.getString("TransactionalBackgroundAction_0"), this.transactionalObject));
                }
                return;
            }
        }
        this.cancel();
    }

    protected CDOObject preRun(CDOObject object) {
        CDOTransaction transaction = object.cdoView().getSession().openTransaction();
        CDOObject transactionalObject = (CDOObject)transaction.getObject((EObject)object);
        return transactionalObject;
    }

    protected final void doRun(IProgressMonitor progressMonitor) throws Exception {
        CDOTransaction transaction = (CDOTransaction)this.transactionalObject.cdoView();
        int commitWorkPercent = this.getCommitWorkPercent();
        progressMonitor.beginTask(Messages.getString("TransactionalBackgroundAction_1"), 100);
        try {
            this.doRun(transaction, this.transactionalObject, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)progressMonitor, (int)(100 - commitWorkPercent)));
            transaction.commit((IProgressMonitor)SubMonitor.convert((IProgressMonitor)progressMonitor, (int)commitWorkPercent));
        }
        finally {
            progressMonitor.done();
            transaction.close();
            this.transactionalObject = null;
        }
    }

    protected abstract void doRun(CDOTransaction var1, CDOObject var2, IProgressMonitor var3) throws Exception;
}

