/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.repomanager.ui.actions;

import es.upv.dsic.issi.dplfw.repomanager.ui.bundle.OM;
import es.upv.dsic.issi.dplfw.repomanager.ui.messages.Messages;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class RemoveResourceActionDelegate
implements IObjectActionDelegate {
    private List<CDOResourceNode> nodes;
    private Shell shell;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.nodes = UIUtil.getElements((ISelection)selection, CDOResourceNode.class);
    }

    public void run(IAction action) {
        if (MessageDialog.openConfirm((Shell)this.shell, (String)Messages.getString("RemoveResourceAction_1"), (String)MessageFormat.format(Messages.getString("RemoveResourceAction_2"), this.nodes.size()))) {
            Job job = new Job(Messages.getString("RemoveResourceAction_3")){

                protected IStatus run(IProgressMonitor monitor) {
                    HashMap<Integer, CDOTransaction> repositoryToTransaction = new HashMap<Integer, CDOTransaction>();
                    for (CDOResourceNode node : RemoveResourceActionDelegate.this.nodes) {
                        CDOObject writableNode;
                        EObject container;
                        int sessionID = node.cdoView().getSession().getSessionID();
                        CDOTransaction transaction = (CDOTransaction)repositoryToTransaction.get(sessionID);
                        if (transaction == null) {
                            transaction = node.cdoView().getSession().openTransaction();
                            repositoryToTransaction.put(sessionID, transaction);
                        }
                        if ((container = (writableNode = transaction.getObject(node.cdoID())).eContainer()) == null) {
                            container = (CDOResource)writableNode.eResource();
                        }
                        if (container instanceof CDOResource) {
                            ((CDOResource)container).getContents().remove((Object)writableNode);
                            continue;
                        }
                        if (!(container instanceof CDOResourceFolder)) continue;
                        ((CDOResourceFolder)container).getNodes().remove((Object)writableNode);
                    }
                    for (CDOTransaction transaction : repositoryToTransaction.values()) {
                        try {
                            try {
                                transaction.commit();
                            }
                            catch (Exception ex) {
                                OM.LOG.error(MessageFormat.format(Messages.getString("RemoveResourceAction_4"), ((Object)((Object)this)).getClass().getName().toString()), (Throwable)ex);
                                transaction.close();
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            transaction.close();
                            throw throwable;
                        }
                        transaction.close();
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }
}

