/*
 * Decompiled with CFR 0.152.
 */
package es.upv.dsic.issi.dplfw.repomanager.ui.actions;

import es.upv.dsic.issi.dplfw.repomanager.ui.actions.TransactionalBackgroundActionDelegate;
import es.upv.dsic.issi.dplfw.repomanager.ui.messages.Messages;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.swt.widgets.Shell;

public class ExportResourceActionDelegate
extends TransactionalBackgroundActionDelegate {
    private URI targetURI;

    public ExportResourceActionDelegate() {
        super(Messages.getString("ExportSelectedResourceAction_0"));
    }

    @Override
    protected final CDOObject preRun(CDOObject object) {
        ResourceDialog dialog = new ResourceDialog(new Shell(), Messages.getString("ExportSelectedResourceAction_1"), 8192);
        if (dialog.open() == 0) {
            List uris = dialog.getURIs();
            if (uris.size() == 1) {
                this.targetURI = (URI)uris.get(0);
                CDOTransaction transaction = object.cdoView().getSession().openTransaction();
                CDOObject transactionalObject = (CDOObject)transaction.getObject((EObject)object);
                return transactionalObject;
            }
            MessageDialog.openError((Shell)new Shell(), (String)Messages.getString("ExportResourceActionDelegate.0"), (String)Messages.getString("ExportSelectedResourceAction_2"));
            this.cancel();
        } else {
            this.cancel();
        }
        return null;
    }

    @Override
    protected void doRun(CDOTransaction transaction, CDOObject object, IProgressMonitor progressMonitor) throws Exception {
        CDOResource source = object instanceof CDOResource ? (CDOResource)object : object.cdoResource();
        ArrayList<EObject> sourceContents = new ArrayList<EObject>((Collection<EObject>)source.getContents());
        this.exportObjects(sourceContents);
    }

    private void exportObjects(List<EObject> sourceContents) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource resource = resourceSet.createResource(this.targetURI);
        Collection copiedRoots = EcoreUtil.copyAll(sourceContents);
        resource.getContents().addAll(copiedRoots);
        try {
            resource.save(null);
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }
}

