package es.upv.dsic.issi.dplfw.repomanager.ui.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.commons.collections.map.MultiValueMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.util.EcoreUtil;

import es.upv.dsic.issi.dplfw.dfmconf.CriterionAttributeConfiguration;
import es.upv.dsic.issi.dplfw.dfmconf.DfmconfFactory;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureModelConfiguration;
import es.upv.dsic.issi.dplfw.dfmconf.DocumentFeatureSelection;
import es.upv.dsic.issi.dplfw.dfmconf.Reference;
import es.upv.dsic.issi.dplfw.dfmconf.VariableAttributeConfiguration;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.VariableIEContents;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryLocation;

public class WizardValues {

	private RepositoryLocation location;
	private URI infoElementUri;	
	private List<VariableIEContents> variableIEContentsList = new ArrayList<VariableIEContents>();
	private List<VariableAttributeConfiguration> vAttrList = new ArrayList<VariableAttributeConfiguration>();
	private VariableIEContents variableIEContents;
	private es.upv.dsic.issi.dplfw.dfm.Reference reference;
	private CriterionAttributeConfiguration cAttrC;
	private VariableIEContents variableIEContentsSelected;
	private VariableAttributeConfiguration varAttrCSelected;
	private MultiValueMap mapVarRef = new MultiValueMap();
	
	public VariableAttributeConfiguration getVariableAttributeConfigurationSelected() {
		return varAttrCSelected;
	}

	public void setCriterionAttributeConfigurationSelected(VariableAttributeConfiguration varAttrCSelected) {
		this.varAttrCSelected = varAttrCSelected;
	}

	public VariableIEContents getVariableIEContentsSelected() {
		return variableIEContentsSelected;
	}

	public void setVariableIEContentsSelected(VariableIEContents variableIEContentsSelected) {
		this.variableIEContentsSelected = variableIEContentsSelected;
	}

	public CriterionAttributeConfiguration getCriterionAttributeConfiguration() {
		return cAttrC;
	}

	public void setCriterionAttributeConfiguration(CriterionAttributeConfiguration cAttrC) {
		this.cAttrC = cAttrC;
	}

	public RepositoryLocation getRepositoryLocation() {
		return location;
	}
	
	public void setRepositoryLocation(RepositoryLocation location) {
		this.location = location;
	}
	
	public void setInfoElementUri(URI infoElementUri) {
		this.infoElementUri = infoElementUri;
	}
	
	public URI getInfoElementUri() {
		return infoElementUri;
	}
		
	public List<VariableIEContents> getVariableIEContentsList() {
		return variableIEContentsList;
	}
		
	public void addVariableIEContents(Collection<VariableIEContents> varIECont) {
		this.variableIEContentsList = (List<VariableIEContents>) varIECont;
	}
	
	public es.upv.dsic.issi.dplfw.dfm.Reference getReference(){
		return reference;
	}
	
	public void setReference(es.upv.dsic.issi.dplfw.dfm.Reference reference){
		this.reference = reference;
	}
	
	public VariableIEContents getVariableIEContents(){
		return this.variableIEContents;		
	}
	
	public VariableIEContents removeSelectedVariableIEContents(){
		return this.variableIEContentsSelected = null;		
	}
	
	public void setVariableIEContents(VariableIEContents variableIEContents){
		this.variableIEContents = variableIEContents;		
	}
	
	public List<VariableAttributeConfiguration> getVariableAttributeConfigurationList(){
		vAttrList.clear();
		DocumentFeatureSelection dfs = getDfsFromCriterionAttr();
		while(dfs.getModelOwner() == null){
			DocumentFeatureSelection dfsAux = (DocumentFeatureSelection) dfs.eContainer();
			dfs = dfsAux;
		}
		
		vAttrList.addAll(dfs.getModelOwner().getGlobalVariableAttributes());
		return getVarAttrConfFromDfs(getDfsFromCriterionAttr());
	}
	
	private List<VariableAttributeConfiguration> getVarAttrConfFromDfs(DocumentFeatureSelection dfs){
		DocumentFeatureModelConfiguration dfmconf = dfs.getModelOwner();
		if(dfmconf != null){
			EList<VariableAttributeConfiguration> varAttr = dfmconf.getGlobalVariableAttributes();
			if(!varAttr.isEmpty()){
				vAttrList.addAll(varAttr);
			}
		}
		fillVarialeAttributesFromDfs(dfs);
		return vAttrList;
	}
	
	
	private void fillVarialeAttributesFromDfs(DocumentFeatureSelection dfs) {
		vAttrList.addAll(dfs.getVariableAttributesConfiguration());
		DocumentFeatureSelection parent = dfs.getParentSelection();
		if(parent != null)	fillVarialeAttributesFromDfs(parent);
	}
	
	private DocumentFeatureSelection getDfsFromCriterionAttr(){
		if(getCriterionAttributeConfiguration() != null){
			return (DocumentFeatureSelection) getCriterionAttributeConfiguration().eContainer();
		}
		return null;
	}

	public void createReference() {
		Reference ref = DfmconfFactory.eINSTANCE.createReference();
		InfoElement ie = (InfoElement) getVariableIEContentsSelected().eContainer();
		ref.setInfoElementURI(EcoreUtil.getURI(ie));
		ref.setReferenceName(getVariableIEContentsSelected().getIdName());
		mapVarRef.put(getVariableAttributeConfigurationSelected(), ref);
		System.out.println(mapVarRef.toString());
	}
	
	public MultiValueMap getMapVariableAttributeReference(){
		return mapVarRef;
	}
	
	public List<Reference> getMapVarRefValuesFromKey(VariableAttributeConfiguration vAttrC){
		return (List<Reference>) mapVarRef.get(vAttrC);
	}
	
}
