package es.upv.dsic.issi.dplfw.repomanager.ui.wizards;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import es.upv.dsic.issi.dplfw.repomanager.IRepositoryManager;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryLocation;
import es.upv.dsic.issi.dplfw.repomanager.ui.views.providers.RepositoriesLabelProvider;

public class SelectRepositoryWizardPage extends WizardPage {

	private TableViewer viewer;
	private WizardValues values;

	public SelectRepositoryWizardPage(WizardValues values) {
        super("SelectRepositoryWizardPage");
        setTitle("Select Repository Location");
        setDescription("Select a repository location");
        setPageComplete(false);

        this.values = values;
	}

	@Override
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout());
		setControl(composite);
		
		viewer = new TableViewer(composite, SWT.SINGLE | SWT.BORDER);
		viewer.setContentProvider(new ArrayContentProvider());
		viewer.setInput(IRepositoryManager.INSTANCE.getRepositories());
		viewer.setLabelProvider(new RepositoriesLabelProvider());
		viewer.getControl().setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		addListeners();
	}

	private void addListeners() {
		viewer.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				if (getSelectedLocation() != null) {
					values.setRepositoryLocation(getSelectedLocation());
					setPageComplete(true);
				}
			}
		});
		viewer.addDoubleClickListener(new IDoubleClickListener() {
			@Override
			public void doubleClick(DoubleClickEvent event) {
				getContainer().showPage(getNextPage());
			}
		});
	}
	
	public RepositoryLocation getSelectedLocation() {
		IStructuredSelection selection = (IStructuredSelection) viewer.getSelection();
		return (RepositoryLocation) selection.getFirstElement();
	}
	
	@Override
	public void setVisible(boolean visible) {
		super.setVisible(visible);
		if (visible) {
			viewer.setInput(IRepositoryManager.INSTANCE.getRepositories());
			viewer.refresh();
		}
	}
		
}
