package es.upv.dsic.issi.dplfw.repomanager.ui.wizards;

import java.util.Collection;

import org.apache.commons.collections.map.MultiValueMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

import es.upv.dsic.issi.dplfw.dfm.Reference;
import es.upv.dsic.issi.dplfw.dfmconf.CriterionAttributeConfiguration;
import es.upv.dsic.issi.dplfw.repomanager.IRepositoryManager;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryLocation;

public class SelectInfoElementWizard extends Wizard {

	private WizardValues values = new WizardValues();
	SelectRepositoryWizardPage reposPage;
	SearchInfoElementWizardPage searchPage;
	ReferenceMatchingWizardPage referencePage;
	
	public SelectInfoElementWizard(Object obj) {
		this(null,obj);
	}
	
	public SelectInfoElementWizard(RepositoryLocation location, Object obj) {
		setWindowTitle("Select Info Element");
		if (location != null) {
			values.setRepositoryLocation(location);
//		} else if (getRepositoriesFromRegistry().size() == 1) {
//			values.setRepositoryLocation((RepositoryLocation) getRepositoriesFromRegistry().toArray()[0]);
		}
		
		if(obj instanceof Reference){
			values.setReference((Reference) obj);
		}else if(obj instanceof CriterionAttributeConfiguration){
			values.setCriterionAttributeConfiguration((CriterionAttributeConfiguration) obj);
		}
	}

	@Override
	public boolean performFinish() {
		return true;
	}
	
	@Override
	public void addPages() {
		
		if (getRepositoriesFromRegistry().size() == 0) {
			addPage(new NoRepositoriesWizardPage(values));
		}
		
		reposPage = new SelectRepositoryWizardPage(values);
		searchPage = new SearchInfoElementWizardPage(values);
		referencePage = new ReferenceMatchingWizardPage(values);

		if (getRepositoriesFromRegistry().size() > 1) {
			addPage(reposPage);
		} else if (getRepositoriesFromRegistry().size() == 1) {
			values.setRepositoryLocation(
					((RepositoryLocation)getRepositoriesFromRegistry().toArray()[0]));
		}
		
		addPage(searchPage);
		addPage(referencePage);	
	}

	private Collection<RepositoryLocation> getRepositoriesFromRegistry() {
		return IRepositoryManager.INSTANCE.getRepositories();
	}
	
	public URI getInfoElementUri() {
		return values.getInfoElementUri();
	}
	
	public Object getReference(){
		return values.getReference(); 
	}
	
	public MultiValueMap getVarAttrRefMap(){
		return values.getMapVariableAttributeReference();
	}
	
	@Override
	public boolean canFinish() {
		return values.getInfoElementUri() != null;
	}

	@Override
	public IWizardPage getNextPage(IWizardPage page) {
		if(page.equals(reposPage)){
			return searchPage;
		}else if(page.equals(searchPage)){
			if(!values.getVariableIEContentsList().isEmpty() && values.getCriterionAttributeConfiguration() != null){
				referencePage.onEnterPage();
				return referencePage;
			}else{
				return null;
			}
		}
		return super.getNextPage(page);
	}
	
	@Override
	public IWizardPage getStartingPage() {
		if (values.getRepositoryLocation() == null) {
			return reposPage;
		} else {
			return searchPage;
		}
	}
	
}
