package es.upv.dsic.issi.dplfw.repomanager.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;

import es.upv.dsic.issi.dplfw.core.util.IIEQueryBuilder;
import es.upv.dsic.issi.dplfw.dfmconf.Criterion;
import es.upv.dsic.issi.dplfw.dfmconf.CriterionAttributeConfiguration;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.InfoelementsPackage;
import es.upv.dsic.issi.dplfw.repomanager.IRepositoryManager;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryLocation;
import es.upv.dsic.issi.dplfw.repomanager.UnknownRepositoryException;
import es.upv.dsic.issi.dplfw.repomanager.ui.RepositoryManagerUIPlugin;
import es.upv.dsic.issi.dplfw.repomanager.ui.actions.EditIEViewerAction;
import es.upv.dsic.issi.dplfw.repomanager.ui.views.providers.RepositoriesLabelProvider;

public class SearchInfoElementWizardPage extends WizardPage {

	private WizardValues values; 
	private CDOSession session;
	private CDOView view;
	private TableViewer viewer;
	private List<InfoElement> searchResults = new ArrayList<InfoElement>();
	private Text searchText;
	private Action editIEAction;
	private Button searchButton;
	private Text descriptionText;
	
	
	public SearchInfoElementWizardPage(WizardValues values) {
		super("SearchInfoElementWizardPage");
        setTitle("Search Info Element");
        setDescription("Search Info Element");
        this.values = values;
	}
	
	@Override
	public void createControl(Composite parent) {
		initializeDialogUnits(parent);
		createControlUI(parent);
		addListeners(searchButton);
		makeActions();
		hookContextMenu();
	}

	private void createControlUI(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout(2, false));
		setControl(composite);
		
		Label searchLabel = new Label(composite, SWT.NONE);
		searchLabel.setText("Insert search string:");
		searchLabel.setLayoutData(new GridData(SWT.FILL, SWT.BEGINNING, true, false, 2, 1));
		
		searchText = new Text(composite, SWT.BORDER);
		searchText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		
		searchButton = new Button(composite, SWT.PUSH);
		searchButton.setText("&Search");

		Label hintLabel = new Label(composite, SWT.NONE);
		hintLabel.setText("(% = any string)");
		hintLabel.setLayoutData(new GridData(SWT.FILL, SWT.BEGINNING, true, false, 2, 1));

		
		viewer = new TableViewer(composite, SWT.SINGLE | SWT.BORDER);
		viewer.setContentProvider(new ArrayContentProvider());
		viewer.setInput(searchResults);
		viewer.setLabelProvider(new RepositoriesLabelProvider());
		GridData gridData = new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1);
		gridData.heightHint = 250;
		viewer.getControl().setLayoutData(gridData);
		viewer.getControl().setEnabled(false);
		
		descriptionText = new Text(composite, SWT.MULTI | SWT.BORDER | SWT.WRAP | SWT.V_SCROLL);
		descriptionText.setEditable(false);
		gridData = new GridData(SWT.FILL, SWT.BEGINNING, true, false, 2, 1);
		gridData.heightHint = 45;
		descriptionText.setLayoutData(gridData);

	}

	private void addListeners(Button searchButton) {
		
		searchButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				performSearch(searchText.getText());
			}
		});
		
		viewer.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				InfoElement infoElement = getSelectedInfoElement();
				if (infoElement != null) {
					values.setInfoElementUri(EcoreUtil.getURI(infoElement));
					values.addVariableIEContents(infoElement.getVariables());
					showIEDescription(infoElement.getDescription());
					setPageComplete(true);
				}
			}
		});
		
		searchText.addListener(SWT.DefaultSelection, new Listener() {
			@Override
			public void handleEvent(Event event) {
				performSearch(searchText.getText());			}
		});
	}

	private void hookContextMenu() {
		MenuManager manager = new MenuManager();
		Menu menu = manager.createContextMenu(viewer.getControl());
		manager.addMenuListener(new IMenuListener() {
			@Override
			public void menuAboutToShow(IMenuManager manager) {
				if (viewer.getSelection().isEmpty())
					return;
				if(viewer.getSelection() instanceof IStructuredSelection) {
					IStructuredSelection selection = (IStructuredSelection) viewer.getSelection();
					if (selection.getFirstElement() instanceof InfoElement){
						manager.add(editIEAction);
					}
				}
			}
		});
		manager.setRemoveAllWhenShown(true);
		viewer.getControl().setMenu(menu);
	}
	
	private void makeActions() {
		editIEAction = new EditIEViewerAction(viewer);
		editIEAction.setText("&Edit");
		editIEAction.setToolTipText("Opens the Info Element with the default editor");
		editIEAction.setImageDescriptor(ImageDescriptor
				.createFromImage(RepositoryManagerUIPlugin.getDefault()
						.getImageRegistry()
						.get(RepositoryManagerUIPlugin.IMG_ELCL16_EDIT)));

	}
	
	protected void performSearch(final String text) {
		ProgressMonitorDialog dialog = new ProgressMonitorDialog(getShell());
		IRunnableWithProgress runnable = new IRunnableWithProgress() {
			
			@Override
			public void run(IProgressMonitor monitor) throws InvocationTargetException,
					InterruptedException {
				monitor.beginTask("Searching...", 2);
				monitor.subTask("Connecting to repository");
				// If connection has not been created yet, getView will create a new connection
				// this allows us to report this task to the user.
				getView();
				monitor.worked(1);
				
				monitor.subTask("Retrieving results");
				searchResults.clear();
				if(values.getCriterionAttributeConfiguration() == null){
					searchResults.addAll((List<InfoElement>) searchString(text));
				}else{
					searchResults.addAll((List<InfoElement>) searchStringByCriterion(text));
				}
				monitor.worked(1);
				
				
				monitor.subTask("Refreshing viewer");
				getShell().getDisplay().syncExec(new Runnable() {
					@Override
					public void run() {
						viewer.getControl().setEnabled(true);
						viewer.refresh();					}
				});
				monitor.worked(1);
				monitor.done();
			}
		};
		
		try {
			dialog.run(true, false, runnable);
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		
	}
	
	protected void showIEDescription(final String description) {
		getShell().getDisplay().asyncExec(new Runnable() {
			@Override
			public void run() {
				if (!descriptionText.isDisposed())
					descriptionText.setText(description != null ? description : "");
			}
		});
	}

	protected Collection<InfoElement> searchString(String searchString) {
		IIEQueryBuilder ieQueryBuilder = IIEQueryBuilder.FACTORY.createQueryFor(view.getSession().getRepositoryInfo().getStoreType())
				.where()
				.containsSubstring("description", searchString)
				.or()
				.containsSubstring("title", searchString);
		CDOQuery query = view.createQuery(ieQueryBuilder.language(), ieQueryBuilder.build());
		return query.getResult();
	}
	
	protected Collection<InfoElement> searchStringByCriterion(String searchString) {
		return handlerCriterionAttributeData(values.getCriterionAttributeConfiguration());
	}
	private Collection<InfoElement> handlerCriterionAttributeData(CriterionAttributeConfiguration cAttr) {
		/*
		 * The code commented below should be no longer needed.
		 * Remove once it is confirmed that the new code works as expected
		 */
		/*
		int cont = 0;
		String queryString = "from InfoElement ie where ";
		CDOView view = this.getView();
			
		for(Criterion c : cAttr.getCriteria()){
			if(c.getMetadataElement() == MetadataElement.TITLE){
				if(cont != 0) queryString += "and ie.title like '" + c.getValue() + "'";
				else queryString += "ie.title like '" + c.getValue() + "'";
				cont++;
			}else if(c.getMetadataElement() == MetadataElement.SUBJECT){
				if(cont != 0) queryString += "and ie.subject like '" + c.getValue() + "'";
				else queryString += "ie.subject like '" + c.getValue() + "'";
				cont++;
			}else if(c.getMetadataElement() == MetadataElement.PUBLISHER){
				if(cont != 0) queryString += "and ie.publisher like '" + c.getValue() + "'";
				else queryString += "ie.publisher like '" + c.getValue() + "'";
				cont++;
			}else if(c.getMetadataElement() == MetadataElement.KEYWORDS){
				if(cont != 0) queryString += "and '" + c.getValue() + "' in elements(ie.keywords)";
				else queryString += "'" + c.getValue() + "' in elements(ie.keywords)";
				cont++;
			}else if(c.getMetadataElement() == MetadataElement.AUTHORS){
				if(cont != 0) queryString += "and '" + c.getValue() + "' in elements(ie.authors)";
				else queryString += "'" + c.getValue() + "' in elements(ie.authors)";
				cont++;
			}else if(c.getMetadataElement() == MetadataElement.LANGUAGE){
				if(cont != 0) queryString += "and ie.language like '" + c.getValue() + "'";
				else queryString += "ie.language like '" + c.getValue() + "'";
				cont++;
			}else if(c.getMetadataElement() == MetadataElement.DESCRIPTION){
				if(cont != 0) queryString += "and ie.description like '" + c.getValue() + "'";
				else queryString += "ie.description like '" + c.getValue() + "'";
				cont++;
			}
		}
			
		CDOQuery query = view.createQuery("hql", queryString);
		 */
		
		IIEQueryBuilder ieQueryBuilder = IIEQueryBuilder.FACTORY.createQueryFor(view.getSession().getRepositoryInfo().getStoreType());
		
		for(int i = 0; i < cAttr.getCriteria().size(); i++) {
			Criterion c =cAttr.getCriteria().get(i);
			if (i == 0) {
				ieQueryBuilder = ieQueryBuilder.where();
			} else {
				ieQueryBuilder = ieQueryBuilder.and();
			}
			EStructuralFeature esf = InfoelementsPackage.eINSTANCE.getInfoElement().getEStructuralFeature(c.getMetadataElement().getName());
			if (esf.getUpperBound() == 1) {
				ieQueryBuilder = ieQueryBuilder.is(c.getMetadataElement().getName(), c.getValue());
			} else {
				ieQueryBuilder = ieQueryBuilder.contains(c.getMetadataElement().getName(), c.getValue());
			}
		}
		
		CDOQuery query = view.createQuery(ieQueryBuilder.language(), ieQueryBuilder.build());
		return query.getResult();

	}

	protected CDOView getView() {
		if (view == null) {
			try {
				session = IRepositoryManager.INSTANCE.openSession(getLocation().getUuid());
				view = session.openView();
			} catch (UnknownRepositoryException e) {
				e.printStackTrace();
			}
		}
		return view;
	}
	
	protected RepositoryLocation getLocation() {
		return values.getRepositoryLocation();
	}
	
	protected InfoElement getSelectedInfoElement() {
		IStructuredSelection selection = (IStructuredSelection) viewer.getSelection();
		return (InfoElement) selection.getFirstElement(); 
	}
	
	@Override
	public void dispose() {
		if (view != null && !view.isClosed())
			view.close();
		if (session != null && !session.isClosed())
			session.close();
		super.dispose();
	}
}

