package es.upv.dsic.issi.dplfw.repomanager.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;

import es.upv.dsic.issi.dplfw.core.ui.DplfwUiPlugin;
import es.upv.dsic.issi.dplfw.core.util.IIEQueryBuilder;
import es.upv.dsic.issi.dplfw.dfm.Attribute;
import es.upv.dsic.issi.dplfw.dfm.ContentDocumentFeature;
import es.upv.dsic.issi.dplfw.dfm.DocumentFeatureModel;
import es.upv.dsic.issi.dplfw.dfm.Reference;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.VariableIEContents;
import es.upv.dsic.issi.dplfw.repomanager.IRepositoryManager;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryLocation;
import es.upv.dsic.issi.dplfw.repomanager.UnknownRepositoryException;
import es.upv.dsic.issi.dplfw.repomanager.ui.RepositoryManagerUIPlugin;
import es.upv.dsic.issi.dplfw.repomanager.ui.actions.EditIEViewerAction;
import es.upv.dsic.issi.dplfw.repomanager.ui.views.providers.RepositoriesLabelProvider;

public class SearchInfoElementVariablesWizardPage extends WizardPage {

	private WizardValues values; 
	private CDOSession session;
	private CDOView view;
	private TableViewer viewerIE;
	private TableViewer viewerIEVar;
	private List<InfoElement> searchResults = new ArrayList<InfoElement>();
	private List<InfoElement> infoElementList = new ArrayList<InfoElement>();
	private boolean isDocumentFeatureModel;
	private Text searchText;
	private Action editIEAction;
	private Button searchButton;
	private Text descriptionText;
	
	public SearchInfoElementVariablesWizardPage(WizardValues values) {
		super("SearchInfoElementVariablesWizardPage");
        setTitle("Search Info Element Variables");
        setDescription("Search Info Element Variables");
        this.values = values;
	}
	
	@Override
	public void createControl(Composite parent) {
		initializeDialogUnits(parent);
		isDocumentFeatureModel = isDocumentFeatureModel(values.getReference());
		
		if(!isDocumentFeatureModel){
			initializeInfoElementList(getContentDocumentFeatureByReference(values.getReference()));	
		}
		
		createControlUI(parent);
		addListeners(searchButton);
		makeActions();
		hookContextMenu();
	}

	private boolean isDocumentFeatureModel(Reference reference) {
		Attribute attr = (Attribute)  reference.eContainer();
		if(attr.eContainer() instanceof DocumentFeatureModel){
			return true;
		}
		return false;
	}

	private void createControlUI(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout(2, false));
		setControl(composite);
		
		Label searchLabel = new Label(composite, SWT.NONE);
		searchLabel.setText("Insert search string:");
		searchLabel.setLayoutData(new GridData(SWT.FILL, SWT.BEGINNING, true, false, 2, 1));
		
		searchText = new Text(composite, SWT.BORDER);
		searchText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
		
		searchButton = new Button(composite, SWT.PUSH);
		searchButton.setText("&Search");

		Label hintLabel = new Label(composite, SWT.NONE);
		hintLabel.setText("(% = any string)");
		hintLabel.setLayoutData(new GridData(SWT.FILL, SWT.BEGINNING, true, false, 2, 1));

		viewerIE = new TableViewer(composite, SWT.SINGLE | SWT.BORDER);
		viewerIE.setContentProvider(new ArrayContentProvider());
		viewerIE.setInput(searchResults);
		viewerIE.setLabelProvider(new RepositoriesLabelProvider());
		GridData gridData = new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1);
		gridData.heightHint = 150;
		viewerIE.getControl().setLayoutData(gridData);
		viewerIE.getControl().setEnabled(false);
		
		Label variableLabel = new Label(composite, SWT.NONE);
		variableLabel.setText("Variables:");
		variableLabel.setLayoutData(new GridData(SWT.FILL, SWT.BEGINNING, true, false, 2, 1));
		
		viewerIEVar = new TableViewer(composite, SWT.SINGLE | SWT.BORDER);
		viewerIEVar.setContentProvider(new ArrayContentProvider());
		viewerIEVar.setLabelProvider(new RepositoriesLabelProvider());
		GridData gridDataVar = new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1);
		gridData.heightHint = 100;
		viewerIEVar.getControl().setLayoutData(gridDataVar);
		viewerIEVar.getControl().setEnabled(false);
				
		descriptionText = new Text(composite, SWT.MULTI | SWT.BORDER | SWT.WRAP | SWT.V_SCROLL);
		descriptionText.setEditable(false);
		gridData = new GridData(SWT.FILL, SWT.BEGINNING, true, false, 2, 1);
		gridData.heightHint = 45;
		descriptionText.setLayoutData(gridData);

	}

	private ContentDocumentFeature getContentDocumentFeatureByReference(Reference reference){
		Attribute attr = (Attribute)  reference.eContainer();
		return (ContentDocumentFeature) attr.eContainer();
	}
	
	private void initializeInfoElementList(ContentDocumentFeature cdf) {
		
			try {
				if(cdf.getInfoElementURI() != null ){
					InfoElement ie = loadInfoElement(cdf.getInfoElementURI());	
					infoElementList.add(ie);
				 	for(ContentDocumentFeature child : cdf.getChildren()){
					 	fillInfoElementList(child);
				 	}
				}
			} catch (UnknownRepositoryException e) {
				DplfwUiPlugin.log(e);
			}
	
	}
	
	private InfoElement loadInfoElement(URI infoElementUri) throws UnknownRepositoryException {
		String uuid = infoElementUri.host();
		CDOSession session = IRepositoryManager.INSTANCE.openSession(uuid);
		CDOView view = session.openView();
		InfoElement infoElement = (InfoElement) view.getRootResource().getEObject(infoElementUri.fragment());
		InfoElement infoElementCopy = EcoreUtil.copy(infoElement);
		view.close();
		session.close();
		return infoElementCopy;
	}
	
	private void fillInfoElementList(ContentDocumentFeature cdf){
		
		try {
			
			if(cdf.getInfoElementURI() != null ){
				InfoElement ie = loadInfoElement(cdf.getInfoElementURI());	
				infoElementList.add(ie);
			}
			
			for(ContentDocumentFeature child : cdf.getChildren()){
					 	fillInfoElementList(child);
			}
			
		} catch (UnknownRepositoryException e) {
			DplfwUiPlugin.log(e);
		};
	}
	private void addListeners(Button searchButton) {
		
		searchButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				performSearch(searchText.getText());
			}
		});
		
		viewerIE.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				InfoElement infoElement = getSelectedInfoElement();
				if (infoElement != null) {
					System.out.println(EcoreUtil.getURI(infoElement));
					values.setInfoElementUri(EcoreUtil.getURI(infoElement));
					viewerIEVar.setInput(infoElement.getVariables());
					viewerIEVar.getControl().setEnabled(true);
					showIEDescription(infoElement.getDescription());
					
				}
			}
		});
		

		viewerIEVar.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				VariableIEContents variableIEContents = getSelectedInfoElementVariable();
				if (variableIEContents != null) {
					values.setVariableIEContents(variableIEContents);
					showIEDescription(variableIEContents.getDescription());
					setPageComplete(true);
				}
			}
		});
		
		searchText.addListener(SWT.DefaultSelection, new Listener() {
			@Override
			public void handleEvent(Event event) {
				performSearch(searchText.getText());		
			}
		});
	}

	private void hookContextMenu() {
		MenuManager manager = new MenuManager();
		Menu menu = manager.createContextMenu(viewerIE.getControl());
		manager.addMenuListener(new IMenuListener() {
			@Override
			public void menuAboutToShow(IMenuManager manager) {
				if (viewerIE.getSelection().isEmpty())
					return;
				if(viewerIE.getSelection() instanceof IStructuredSelection) {
					IStructuredSelection selection = (IStructuredSelection) viewerIE.getSelection();
					if (selection.getFirstElement() instanceof InfoElement){
						manager.add(editIEAction);
					}
				}
			}
		});
		manager.setRemoveAllWhenShown(true);
		viewerIE.getControl().setMenu(menu);
	}
	
	private void makeActions() {
		editIEAction = new EditIEViewerAction(viewerIE);
		editIEAction.setText("&Edit");
		editIEAction.setToolTipText("Opens the Info Element with the default editor");
		editIEAction.setImageDescriptor(ImageDescriptor
				.createFromImage(RepositoryManagerUIPlugin.getDefault()
						.getImageRegistry()
						.get(RepositoryManagerUIPlugin.IMG_ELCL16_EDIT)));

	}
	
	protected void performSearch(final String text) {
		ProgressMonitorDialog dialog = new ProgressMonitorDialog(getShell());
		IRunnableWithProgress runnable = new IRunnableWithProgress() {
			
			@Override
			public void run(IProgressMonitor monitor) throws InvocationTargetException,
					InterruptedException {
				monitor.beginTask("Searching...", 2);
				monitor.subTask("Connecting to repository");
				// If connection has not been created yet, getView will create a new connection
				// this allows us to report this task to the user.
				getView();
				monitor.worked(1);
				
				monitor.subTask("Retrieving results");
				searchResults.clear();
				if(isDocumentFeatureModel){
					searchResults.addAll((List<InfoElement>) searchString(text));
				}else{
					searchResults.addAll(filterSearchResults((List<InfoElement>) searchString(text),text));
				}
				
				monitor.worked(1);
				
				monitor.subTask("Refreshing viewer");

				getShell().getDisplay().syncExec(new Runnable() {
					@Override
					public void run() {
						viewerIE.getControl().setEnabled(true);
						viewerIE.refresh();					
					}
				});
				monitor.worked(1);
				monitor.done();
			}
		};
		
		try {
			dialog.run(true, false, runnable);
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		
	}
	private List<InfoElement> filterSearchResults(List<InfoElement> ieSearchList,String searchString) {
		
		List<InfoElement> aux = new ArrayList<InfoElement>();
		
		for(InfoElement ie : infoElementList){
			if((ie.getDescription() != null && ie.getDescription().contains(searchString)) 
				|| (ie.getTitle() != null && ie.getTitle().contains(searchString))){
				for(Object ieQresult : ieSearchList){
					if(((InfoElement) ieQresult).getUuid().equals(ie.getUuid())){
						aux.add((InfoElement) ieQresult);	
					}				
				}	
			}
		}	
		
		return aux;
	}
	protected void showIEDescription(final String description) {
		getShell().getDisplay().asyncExec(new Runnable() {
			@Override
			public void run() {
				if (!descriptionText.isDisposed())
					descriptionText.setText(description != null ? description : "");
			}
		});
	}

	protected Collection<InfoElement> searchString(String searchString) {
		IIEQueryBuilder ieQueryBuilder = IIEQueryBuilder.FACTORY.createQueryFor(view.getSession().getRepositoryInfo().getStoreType())
				.where()
				.containsSubstring("description", searchString)
				.or()
				.containsSubstring("title", searchString);
		CDOQuery query = view.createQuery(ieQueryBuilder.language(), ieQueryBuilder.build());
		return query.getResult();
	}
		
	protected CDOView getView() {
		if (view == null) {
			try {
				session = IRepositoryManager.INSTANCE.openSession(getLocation().getUuid());
				view = session.openView();
			} catch (UnknownRepositoryException e) {
				e.printStackTrace();
			}
		}
		return view;
	}
	
	protected RepositoryLocation getLocation() {
		return values.getRepositoryLocation();
	}
	
	protected InfoElement getSelectedInfoElement() {
		IStructuredSelection selection = (IStructuredSelection) viewerIE.getSelection();
		return (InfoElement) selection.getFirstElement(); 
	}
	
	protected VariableIEContents getSelectedInfoElementVariable() {
		IStructuredSelection selection = (IStructuredSelection) viewerIEVar.getSelection();
		return (VariableIEContents) selection.getFirstElement(); 
	}
	
	@Override
	public void dispose() {
		
		// If uncomment the below lines you will get java.lang.IllegalStateException: Not active: View 1 eclipse
		// when value.getVariablesIEContents() is accesed from SelectInfoElementsVariablesCellEditor.java (line 33)
		
		/* 
		if (view != null && !view.isClosed())
			view.close();
		if (session != null && !session.isClosed())
			session.close();
		*/
		super.dispose();
	}
}

