package es.upv.dsic.issi.dplfw.repomanager.ui.wizards;

import java.util.Collection;

import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

import es.upv.dsic.issi.dplfw.core.util.IIEQueryBuilder;
import es.upv.dsic.issi.dplfw.dfmconf.Reference;
import es.upv.dsic.issi.dplfw.dfmconf.VariableAttributeConfiguration;
import es.upv.dsic.issi.dplfw.dfmconf.provider.DfmconfItemProviderAdapterFactory;
import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.VariableIEContents;
import es.upv.dsic.issi.dplfw.repomanager.IRepositoryManager;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryLocation;
import es.upv.dsic.issi.dplfw.repomanager.UnknownRepositoryException;
import es.upv.dsic.issi.dplfw.repomanager.ui.RepositoryManagerUIPlugin;
import es.upv.dsic.issi.dplfw.repomanager.ui.actions.EditIEViewerAction;

public class ReferenceMatchingWizardPage extends WizardPage {

	private WizardValues values; 
	private CDOSession session;
	private CDOView view;
	private TableViewer variableInfoElementsView;
	private TableViewer variableAttributesView;
	private TableViewer referenceView;
	private Table variableInfoElementsTable;
	private Action editIEAction;
	private Text VariableInfoElementsDescriptionText;
	private Text VariableAttributesDescriptionText;
	private Button btnCreateReference;
	
	public ReferenceMatchingWizardPage(WizardValues values) {
		super("SearchInfoElementVariablesWizardPage");
        setTitle("Search Info Element Variables");
        setDescription("Search Info Element Variables");
        this.values = values;
	}
	
	@Override
	public void createControl(Composite parent) {
		initializeDialogUnits(parent);
		createControlUI(parent);		
		addListeners();
		makeActions();
		hookContextMenu();
	}


	private void createControlUI(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout(2, false));
		setControl(composite);
		
		final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
		adapterFactory.addAdapterFactory(new DfmconfItemProviderAdapterFactory());

	    GridData data = new GridData(SWT.FILL, SWT.TOP, true, false, 2, 1);
		Label variableIEsLabel = new Label(composite, SWT.NONE);
		variableIEsLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		variableIEsLabel.setText("Variable InfoElements:");

		data = new GridData(SWT.FILL, SWT.TOP, true, false, 2, 1);
		data.heightHint = 60;
		Label variableAttributes = new Label(composite, SWT.NONE);
		variableAttributes.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1, 1));
		variableAttributes.setText("Variable Attributes:");

		variableInfoElementsView = new TableViewer(composite, SWT.SINGLE | SWT.BORDER);
		variableInfoElementsTable = variableInfoElementsView.getTable();
		GridData gd_table = new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1);
		gd_table.heightHint = 100;
		variableInfoElementsTable.setLayoutData(gd_table);
		variableInfoElementsView.setContentProvider(new ArrayContentProvider());
		//variableInfoElementsView.setLabelProvider(labelProvider);
		
		variableAttributesView = new TableViewer(composite, SWT.SINGLE | SWT.BORDER);
		Table table_1 = variableAttributesView.getTable();
		data = new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1);
		data.heightHint = 100;
		table_1.setLayoutData(data);
		variableAttributesView.setContentProvider(new ArrayContentProvider());
		variableAttributesView.setLabelProvider(new LabelProvider(){
			AdapterFactoryLabelProvider aflp = new AdapterFactoryLabelProvider(adapterFactory);

			@Override
			public Image getImage(Object element) {
				return aflp.getImage(element);
			}
			@Override
			public String getText(Object element) {
				return ((VariableAttributeConfiguration) element).getAttribute().getIdName();
			}
		});
		
		GridData gridData = new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1);
		gridData.heightHint = 70;
		VariableInfoElementsDescriptionText = new Text(composite, SWT.MULTI | SWT.BORDER | SWT.WRAP | SWT.V_SCROLL);
		VariableInfoElementsDescriptionText.setLayoutData(gridData);
		VariableInfoElementsDescriptionText.setEditable(false);
		
		gridData = new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1);
		gridData.heightHint = 70;
		VariableAttributesDescriptionText = new Text(composite, SWT.MULTI | SWT.BORDER | SWT.WRAP | SWT.V_SCROLL);
		VariableAttributesDescriptionText.setLayoutData(gridData);
		VariableAttributesDescriptionText.setEditable(false);
		
		Label referenceLabel = new Label(composite, SWT.NONE);
		referenceLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		referenceLabel.setText("References:");
		

		referenceView = new TableViewer(composite, SWT.SINGLE | SWT.BORDER);
		Table referenceTable = referenceView.getTable();
		referenceTable.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1));
		referenceView.setContentProvider(new ArrayContentProvider());
		referenceView.setLabelProvider(new LabelProvider(){
			AdapterFactoryLabelProvider aflp = new AdapterFactoryLabelProvider(adapterFactory);
			@Override
			public Image getImage(Object element) {
				return aflp.getImage(element);
			}
			@Override
			public String getText(Object element) {
				return ((Reference) element).getReferenceName();
			}
		});
		new Label(composite, SWT.NONE);
		
		btnCreateReference = new Button(composite, SWT.PUSH);
		btnCreateReference.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		btnCreateReference.setText("Create reference");
		btnCreateReference.setEnabled(false);
	
	}

	public void onEnterPage(){
		variableInfoElementsView.setInput(values.getVariableIEContentsList());
		variableAttributesView.setInput(values.getVariableAttributeConfigurationList());
	}

	private void hookContextMenu() {
		MenuManager manager = new MenuManager();
		Menu menu = manager.createContextMenu(variableInfoElementsView.getControl());
		manager.addMenuListener(new IMenuListener() {
			@Override
			public void menuAboutToShow(IMenuManager manager) {
				if (variableInfoElementsView.getSelection().isEmpty())
					return;
				if(variableInfoElementsView.getSelection() instanceof IStructuredSelection) {
					IStructuredSelection selection = (IStructuredSelection) variableInfoElementsView.getSelection();
					if (selection.getFirstElement() instanceof InfoElement){
						manager.add(editIEAction);
					}
				}
			}
		});
		manager.setRemoveAllWhenShown(true);
		variableInfoElementsView.getControl().setMenu(menu);
	}
	
	private void addListeners() {
		
		variableInfoElementsView.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				VariableIEContents varIE = getSelectedVariableInfoElement();
				if (varIE != null) {
					showVarIEDescription(varIE.getDescription());
					values.setVariableIEContentsSelected(varIE);
					enableCreateReferenceButton();
					//setPageComplete(true);
				}
			}

		});		
		
		variableAttributesView.addSelectionChangedListener(new ISelectionChangedListener() {
			@Override
			public void selectionChanged(SelectionChangedEvent event) {
				VariableAttributeConfiguration varAttr = getSelectedVariableAttribute();
				if (varAttr != null) {
					showVarAttrDescription(varAttr.getAttribute().getDescription());
					values.setCriterionAttributeConfigurationSelected(varAttr);
					referenceView.setInput(values.getMapVarRefValuesFromKey(varAttr));
					enableCreateReferenceButton();
					//setPageComplete(true);
				}
			}
		});
		
		btnCreateReference.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				values.createReference();
				referenceView.setInput(values.getMapVarRefValuesFromKey(values.getVariableAttributeConfigurationSelected()));
				referenceView.refresh();
				variableInfoElementsTable.remove(variableInfoElementsTable.getSelectionIndices());
				variableInfoElementsTable.update();
				variableInfoElementsTable.deselectAll();
				showVarIEDescription("");
				values.removeSelectedVariableIEContents();
				enableCreateReferenceButton();
			}
		});
		
		
	}

	private void enableCreateReferenceButton() {
		if(values.getVariableAttributeConfigurationSelected() != null &&
				values.getVariableIEContentsSelected() != null){
			btnCreateReference.setEnabled(true);
		}else{
			btnCreateReference.setEnabled(false);
		}
	}
	
	private void makeActions() {
		editIEAction = new EditIEViewerAction(variableInfoElementsView);
		editIEAction.setText("&Edit");
		editIEAction.setToolTipText("Opens the Info Element with the default editor");
		editIEAction.setImageDescriptor(ImageDescriptor
				.createFromImage(RepositoryManagerUIPlugin.getDefault()
						.getImageRegistry()
						.get(RepositoryManagerUIPlugin.IMG_ELCL16_EDIT)));

	}
	
	
	protected void showVarIEDescription(final String description) {
		getShell().getDisplay().asyncExec(new Runnable() {
			@Override
			public void run() {
				if (!VariableInfoElementsDescriptionText.isDisposed())
					VariableInfoElementsDescriptionText.setText(description != null ? description : "");
			}
		});
	}
	
	protected void showVarAttrDescription(final String description) {
		getShell().getDisplay().asyncExec(new Runnable() {
			@Override
			public void run() {
				if (!VariableAttributesDescriptionText.isDisposed())
					VariableAttributesDescriptionText.setText(description != null ? description : "");
			}
		});
	}

	protected Collection<InfoElement> searchString(String searchString) {
		
		CDOView view = getView();
		IIEQueryBuilder ieQueryBuilder = IIEQueryBuilder.FACTORY.createQueryFor(view.getSession().getRepositoryInfo().getStoreType())
				.where()
				.containsSubstring("description", searchString)
				.or()
				.containsSubstring("title", searchString);
		CDOQuery query = view.createQuery(ieQueryBuilder.language(), ieQueryBuilder.build());
		return query.getResult();
	}
		
	protected CDOView getView() {
		if (view == null) {
			try {
				session = IRepositoryManager.INSTANCE.openSession(getLocation().getUuid());
				view = session.openView();
			} catch (UnknownRepositoryException e) {
				e.printStackTrace();
			}
		}
		return view;
	}
	
	protected RepositoryLocation getLocation() {
		return values.getRepositoryLocation();
	}
	
	protected VariableIEContents getSelectedVariableInfoElement() {
		IStructuredSelection selection = (IStructuredSelection) variableInfoElementsView.getSelection();
		return (VariableIEContents) selection.getFirstElement(); 
	}
	
	protected VariableAttributeConfiguration getSelectedVariableAttribute() {
		IStructuredSelection selection = (IStructuredSelection) variableAttributesView.getSelection();
		return (VariableAttributeConfiguration) selection.getFirstElement(); 
	}
	
	@Override
	public void dispose() {
		
		// If uncomment the below lines you will get java.lang.IllegalStateException: Not active: View 1 eclipse
		// when value.getVariablesIEContents() is accesed from SelectInfoElementsVariablesCellEditor.java (line 33)
		// REVISAR, TORNAR EcoreUtils.copyAll(obj) !
		/* 
		if (view != null && !view.isClosed())
			view.close();
		if (session != null && !session.isClosed())
			session.close();
		*/
		super.dispose();
	}
}

