package es.upv.dsic.issi.dplfw.repomanager.ui.wizards;

import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.dialogs.PreferencesUtil;

import es.upv.dsic.issi.dplfw.core.ui.DplfwUiPlugin;
import es.upv.dsic.issi.dplfw.repomanager.IRepositoryManager;
import es.upv.dsic.issi.dplfw.repomanager.ui.RepositoryManagerUIPlugin;

public class NoRepositoriesWizardPage extends WizardPage {


	public NoRepositoriesWizardPage(WizardValues values) {
        super("SelectRepositoryWizardPage");
        setTitle("Select Repository Location");
        setDescription("Configure repository locations");
        setPageComplete(false);
	}

	@Override
	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout());
		setControl(composite);

		Label label = new Label(composite, SWT.NONE);
		label.setText("No repository locations have been configured. Please use the Eclipse Preferences to manage them:");
		
		Button button = new Button(composite, SWT.NONE);
		button.setText("&Configure locations...");
		button.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, true, true));
		button.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(getShell(),
						RepositoryManagerUIPlugin.PREFERENCES_REPOSITORIES_ID, 
						new String[] { DplfwUiPlugin.PREFERENCES_ROOT_ID, 
										RepositoryManagerUIPlugin.PREFERENCES_REPOSITORIES_ID }, 
						null);
				dialog.open();
				checkCanContinue();
			}
		});
	}

	protected void checkCanContinue() {
		if (IRepositoryManager.INSTANCE.getRepositories().size() > 0)
			setPageComplete(true);
		else
			setPageComplete(false);
	}
}
