package es.upv.dsic.issi.dplfw.repomanager.ui.views.providers;

import java.util.Collection;

import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import es.upv.dsic.issi.dplfw.repomanager.ui.model.RepositoryNode;

public class ViewContentProvider implements ITreeContentProvider {
	
	public void dispose() {
	}
	
	public Object[] getChildren(Object parent) {
		Object[] result = new Object[0];
		if (!hasChildren(parent)) {
			// Nothing to do
		} else if (parent instanceof RepositoryNode) {
			RepositoryNode node = (RepositoryNode) parent;
			if (node.getChildren().length > 0) {
				result = node.getChildren();
			}
		} else if (parent instanceof CDOResourceNode) {
			CDOResourceNode resourceNode = (CDOResourceNode) parent;
			if (!resourceNode.eContents().isEmpty()) {
				result = resourceNode.eContents().toArray();
			}
		}
		return result;
	}
	
	public Object[] getElements(Object parent) {
		if (parent instanceof Collection<?>) {
			return ((Collection<?>)parent).toArray();
		}
		return getChildren(parent);
	}
	
	public Object getParent(Object child) {
		return null;
	}
	
	public boolean hasChildren(Object parent) {
		if (parent instanceof RepositoryNode) {
			RepositoryNode node = (RepositoryNode) parent;
			if(node.hasChildren()) {
				return true;
			}
		} else if (parent instanceof CDOResourceNode) {
			CDOResourceNode resourceNode = (CDOResourceNode) parent;
			if(!resourceNode.eContents().isEmpty()) {
				return true;
			}
		}
		return false;
	}
	
	public void inputChanged(Viewer v, Object oldInput, Object newInput) {
	}
}