package es.upv.dsic.issi.dplfw.repomanager.ui.views;

import java.util.List;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;

import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.repomanager.ui.jobs.MoveOrCopyElementsJob;
import es.upv.dsic.issi.dplfw.repomanager.ui.model.RepositoryNode;

public final class RepositoriesViewerDropAdapter extends ViewerDropAdapter {
	/**
	 * 
	 */
	public RepositoriesViewerDropAdapter(Viewer viewer) {
		super(viewer);
	}

	@Override
	public boolean performDrop(Object data) {
		
		final Object target = determineTarget(getCurrentEvent());
		final List<?> sourceElements = ((IStructuredSelection)getViewer().getSelection()).toList();
		
		Job job = null;
		if (getCurrentOperation() == DND.DROP_MOVE) {
			job = new MoveOrCopyElementsJob("Moving elements", target, sourceElements, true);
		} else if (getCurrentOperation() == DND.DROP_COPY) {
			job = new MoveOrCopyElementsJob("Copying elements", target, sourceElements, false);
		}
		job.setUser(true);
		job.schedule();
		return true;
	}

	@Override
	public boolean validateDrop(Object target, int operation, TransferData transferType) {
		List<?> sourceElements = ((IStructuredSelection)getViewer().getSelection()).toList();
		
		// Restrictions regarding the source elements
		{
			// Check if selection is not empty
			if (!(sourceElements.size() > 0)) 
				return false;
			
			// Only selections with the same parent can be d&d
			EObject parent = ((CDOObject)sourceElements.get(0)).eContainer();
			for (Object element : sourceElements) {
				if (element instanceof CDOObject) {
					if (((CDOObject) element).eContainer() != parent) {
						return false;
					}
				}
			}
			
			// An element can't be dropped over itself or over its parent (when moving)
			// Resources inside the Root CDOResource do not have an eContainer,
			// thus, we user eResource instead.
			for (Object element : sourceElements) {
				if (element == target || 
					 ((operation == DND.DROP_MOVE) &&
						(((EObject)element).eContainer() != null ?
						((EObject)element).eContainer() == Platform.getAdapterManager().getAdapter(target, CDOResourceNode.class) :
						((EObject)element).eResource() == Platform.getAdapterManager().getAdapter(target, CDOResourceNode.class))))
					return false;
			}
		}
		
		// Restrictions regarding the target element
		{
			// Root resource can contain any kind of children
			if (target instanceof RepositoryNode) {
				return true;
			} else if (target instanceof CDOResource) {
				// Only InfoElements can be dropped in CDOResource
				for (Object element : sourceElements) {
					if (!(element instanceof InfoElement)) {
						return false;
					}
				}
				return true;
			} else if (target instanceof CDOResourceFolder) {
				// Only CDOResourceNodes can be dropped in CDOResourceFolders
				for (Object element : sourceElements) {
					if (!(element instanceof CDOResourceNode)) {
						return false;
					}
				}
				return true;
			} else {
				return false;
			}
		}
	}
}