package es.upv.dsic.issi.dplfw.repomanager.ui.model;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.net4j.CDOSession.Options;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOObjectHandler;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.ui.IActionFilter;

import es.upv.dsic.issi.dplfw.repomanager.IRepositoryManager;
import es.upv.dsic.issi.dplfw.repomanager.RepositoryLocation;
import es.upv.dsic.issi.dplfw.repomanager.UnknownRepositoryException;

public class RepositoryNode implements IAdaptable, IActionFilter {
	
	private static final int COMMIT_TIMEOUT = 200000;

	private RepositoryLocation location;
	private CDOSession session;
	private CDOView view;
	private Adapter eObjectAdapter;
	
	public RepositoryNode(RepositoryLocation location) {
		this.location = location;
	}

	public RepositoryLocation getLocation() {
		return location;
	}
	
	protected CDOSession getSession() {
		if (session == null) {
			try {
				connect();
			} catch (UnknownRepositoryException e) {
				e.printStackTrace();
			}
		}
		return session;
	}

	protected CDOSession createSession() throws UnknownRepositoryException {
		session = IRepositoryManager.INSTANCE.openSession(location.getUuid());
		((Options) session.options()).setCommitTimeout(COMMIT_TIMEOUT);
		session.options().setCollectionLoadingPolicy(CDOUtil.createCollectionLoadingPolicy(0, 300));
		session.addListener(new LifecycleEventAdapter() {
			@Override
			protected void onDeactivated(ILifecycle lifecycle) {
				super.onDeactivated(lifecycle);
				session = null;
			}
		});
		return session;
	}
	
	protected CDOView getView() {
		if (view == null) {
			view = session.openView();
			view.addListener(new LifecycleEventAdapter() {
				@Override
				protected void onDeactivated(ILifecycle lifecycle) {
					super.onDeactivated(lifecycle);
					view = null;
				}
			});
			view.addObjectHandler(new CDOObjectHandler() {
				@Override
				public void objectStateChanged(CDOView view, CDOObject object,
						CDOState oldState, CDOState newState) {
					if (!object.eAdapters().contains(eObjectAdapter)) {
						object.eAdapters().add(eObjectAdapter);
					}
				}
			});
		}
		return view;
	}
	
	protected void closeSession() {
		view.close();
		view = null;
		session.close();
		session = null;
	}

	public boolean hasChildren() {
		if (session == null)
			return false;
		else 
			return getChildren().length > 0;
	}
	
	public Object[] getChildren() {
		if (isConnected()) {
			return getView().getRootResource().getContents().toArray();
		} else {
			return new Object[0];
		}
	}
	
	public CDOResource getRootResource() {
		if (isConnected()) {
			return getView().getRootResource();
		} else {
			return null;
		}
	}
	
	@Override
	protected void finalize() throws Throwable {
		if (session != null && !session.isClosed()) {
			view.close();
			session.close();
		}
		super.finalize();
	}

	public boolean isConnected() {
		return session != null;
	}
	
	public String getName() {
		return location.toStringURI();
	}
	
	public void connect() throws UnknownRepositoryException {
		if (!isConnected()) {
			session = createSession();
		}
	}


	public void disconnect() throws BusyRepositoryException {
		if (session.getViews().length > 1)
			throw new BusyRepositoryException("Repository + " + location.getHost() + " has open views!");
		closeSession();
	}
	
	public void forceDisconnect() {
		closeSession();
	}

	@Override
	public <T> T getAdapter(Class<T> adapter) {
		return Platform.getAdapterManager().getAdapter(this, adapter);
	}
	
	@Override
	public boolean testAttribute(Object target, String name, String value) {
		if (target == this) {
			if (name.equals("connected")) {
				return isConnected() == Boolean.parseBoolean(value);
			}
		}

		return false;
	}
	
	/**
	 * Sets an adapter that will be attached to every object loaded 
	 * using the view contained in this repository node
	 * 
	 * @param eObjectAdapter
	 */
	public void setEObjectAdapter(Adapter eObjectAdapter) {
		this.eObjectAdapter = eObjectAdapter;
	}
}