package es.upv.dsic.issi.dplfw.repomanager.ui.jobs;

import java.util.Collection;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.transaction.CDOSavepoint;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CommitException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

import es.upv.dsic.issi.dplfw.infoelements.InfoElement;
import es.upv.dsic.issi.dplfw.infoelements.util.InfoelementsEcoreUtil;
import es.upv.dsic.issi.dplfw.repomanager.ui.RepositoryManagerUIPlugin;
import es.upv.dsic.issi.dplfw.repomanager.ui.model.RepositoryNode;

public final class MoveOrCopyElementsJob extends Job {
	
	private final Object target;
	private final List<?> sourceElements;
	private final boolean move;

	public MoveOrCopyElementsJob(String name, Object target, List<?> sourceElements, boolean move) {
		super(name);
		this.target = target;
		this.sourceElements = sourceElements;
		this.move = move;
	}

	@SuppressWarnings("unchecked")
	protected IStatus run(IProgressMonitor monitor) {
		
		monitor.beginTask("", IProgressMonitor.UNKNOWN);
		CDOResourceNode targetNode = null;
		
		if (target instanceof CDOResource) {
			targetNode = (CDOResource) target;
		} else if (target instanceof CDOResourceFolder) {
			targetNode = (CDOResourceNode) target;
		} else if (target instanceof RepositoryNode) {
			targetNode = ((RepositoryNode) target).getRootResource();
		} else {
			// Unsupported target
			return Status.OK_STATUS;
		}
		
		CDOTransaction transaction = targetNode.cdoView().getSession().openTransaction();
		CDOSavepoint savepoint = transaction.setSavepoint();
		try {
			// TODO: check this in the future
			// We duplicate the elements to avoid hibernate errors with orphan references
			// (Error: "Deleted object will be re-saved")
			// See CDO documentation: moving is unsupported in CDO 4.0
			// (http://wiki.eclipse.org/CDO_Hibernate_Store#.28Un.29Supported_Functions_and_Features)
			
			Collection<Object> copyElements = null;
			if (move) {
				// We perform a full copy to preserve the UUIDs
				copyElements = InfoelementsEcoreUtil.fullCopyAll(sourceElements);
				// Delete source elements
				for (Object element : sourceElements) {
					if (element instanceof EObject) {
						EObject eObject = transaction.getObject((EObject) element);
						EcoreUtil.delete(eObject);
					}
				}
				// First commit: to delete the source Objects. If not deleted these objects first,
				// the next commit (after the new elements are added) fails since the primary key 
				// constraint is violated
				transaction.commit();
			} else {
				copyElements = EcoreUtil.copyAll(sourceElements);
				// We need to initialize the UUIDs
				for (Object element : copyElements) {
					if (element instanceof InfoElement) {
						InfoElement infoElement = (InfoElement) element;
						infoElement.createUUID();
					}
				}
			}
			
			
			if (targetNode instanceof CDOResource) {
				CDOResource targetResource = (CDOResource) transaction.getObject(targetNode);
				targetResource.getContents().addAll((Collection<? extends EObject>) copyElements);
			} else if (targetNode instanceof CDOResourceFolder) {
				CDOResourceFolder targetFolder = (CDOResourceFolder) transaction.getObject(targetNode);
				targetFolder.getNodes().addAll((Collection<? extends CDOResourceNode>) copyElements);
			}

			// Add the newly created elements to the corresponding resources 
			transaction.commit();
			
		} catch (CommitException e) {
			savepoint.rollback();
			return new Status(Status.ERROR, RepositoryManagerUIPlugin.PLUGIN_ID, e.getLocalizedMessage(), e);
		} catch (Exception e) {
			return new Status(Status.ERROR, RepositoryManagerUIPlugin.PLUGIN_ID, e.getLocalizedMessage(), e);
		} finally {
			transaction.close();
		}
		monitor.done();
		return Status.OK_STATUS;
	}
}