package es.upv.dsic.issi.dplfw.repomanager.ui.adapters;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;

import es.upv.dsic.issi.dplfw.repomanager.ui.model.RepositoryNode;

public class CDOAdapterFactory implements IAdapterFactory {

	private static final Class<?>[] SUPPORTED_CLASSES = new Class<?>[] { 
		CDOResource.class,
		CDOObject.class,
		CDOResourceNode.class };

	@SuppressWarnings("unchecked")
	@Override
	public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
		if (adapterType == CDOObject.class || 
				adapterType == CDOResource.class ||
				adapterType == CDOResourceNode.class) {
			if (adaptableObject instanceof RepositoryNode)
				return (T) ((RepositoryNode) adaptableObject).getRootResource();
		}
		return null;
	}

	@Override
	public Class<?>[] getAdapterList() {
		return SUPPORTED_CLASSES;
	}
}
