package es.upv.dsic.issi.dplfw.repomanager.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.actions.LongRunningActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

import es.upv.dsic.issi.dplfw.repomanager.ui.model.RepositoryNode;

public class RepositoryConnectActionDelegate extends LongRunningActionDelegate implements IObjectActionDelegate {

	private IWorkbenchPart targetPart;

	public RepositoryConnectActionDelegate() {
	}

	@Override
	protected void doRun(IProgressMonitor progressMonitor) throws Exception {
		UIUtil.getElement(getSelection());
	    RepositoryNode node = UIUtil.getElement(getSelection(), RepositoryNode.class);
	    if (node != null) {
	    	node.connect();
	    }
	}

	@Override
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
	    this.targetPart = targetPart;
	    selectionChanged(action, getSelection());
	}

	
	public IWorkbenchPart getTargetPart() {
		return targetPart;
	}
}
