package es.upv.dsic.issi.dplfw.repomanager.ui.actions;

import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

import es.upv.dsic.issi.dplfw.infoelement.singleeditor.IESingleEditorPlugin;
import es.upv.dsic.issi.dplfw.infoelement.singleeditor.editor.CDOObjectEditorInput;
import es.upv.dsic.issi.dplfw.repomanager.ui.RepositoryManagerUIPlugin;

public class EditIEViewerAction extends Action {
	
	Viewer viewer;
	
	public EditIEViewerAction(Viewer viewer) {
		this.viewer = viewer;
	}

	@Override
	public void run() {
		IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
		ISelection selection = viewer.getSelection();
		Object element = ((IStructuredSelection) selection).getFirstElement();
		CDOObject cdoObject = (CDOObject) element;
		try {
			CDOView transaction = CDOUtil.getSession(cdoObject).openTransaction();
			CDOObjectEditorInput input = new CDOObjectEditorInput(
					transaction,
					((CDOResource)cdoObject.eResource()).getPath(), 
					cdoObject.eResource().getURIFragment(cdoObject),
					true);
			IEditorPart editor = page.openEditor(input, IESingleEditorPlugin.EDITOR_ID);
			if (editor.getEditorInput() != input) {
				// The EObject is already opened in an editor, close the transaction
				// because the editor input is not needed
				transaction.close();
			}
		} catch (PartInitException e) {
			StatusManager.getManager().handle(
					new Status(Status.ERROR, RepositoryManagerUIPlugin.PLUGIN_ID, e.getLocalizedMessage(), e),
					StatusManager.BLOCK | StatusManager.LOG);
		} finally {
			// Transaction can't be closed yet because it is used in the Editor Input
			// As the editor input owns the transaction, it will be closed when editor 
			// input is disposed					
		}
	}
}